// ************************************************************
//	Clean Linear Algebra Subroutines - CLAS
//	Version 0.7 - June 23, 1999 - Thorsten Zoerner
// 	Catholic University of Nijmegen - zoerner@cs.kun.nl
// ************************************************************

implementation module slicing

import Clas3

:: Sli = Sli ![Int] ![Int]
:: Row = Row !Int ![Int]
:: Col = Col ![Int] !Int
:: Ele = Ele !Int !Int

sliceSCR s f c g r a :== sliceSCR s c r a
where
	sliceSCR (Sli sv sh) (Col cv c) (Row r rh) a = sliceSCRv sv cv a
	where
		sliceSCRv [] [] a = a
		sliceSCRv [i:is] [j:js] a = sliceSCRv is js (sliceSCRh sh rh a)
		where
			sliceSCRh [] [] a = a
			sliceSCRh [u:us] [v:vs] a =: { [i,u] = aiu, [j, c] = ajc, [r, v] = arv}
				#! g1 = g ajc arv
				= sliceSCRh us vs { a & [i,u] = f aiu g1} 

sliceERC e f r g c a :== sliceERC e r c a
where
	sliceERC (Ele e1 e2) (Row r rh) (Col cv c) a 
		#! v = sliceERC` rh cv 0.0 a
		= { a & [e1, e2] = v}
	where
		sliceERC` [] [] acc a = acc
		sliceERC` [u:us] [i:is] acc a =: { [r, u] = aru, [i, c] = aic} 
			#! g1 = g aru aic
			= sliceERC` us is (f acc g1) a

sliceSSS s1 f s2 g s3 a :== sliceSSS s1 s2 s3 a
where
	sliceSSS (Sli s1v s1h) (Sli s2v s2h) (Sli s3v s3h) a = sliceSSSv s1v s2v s3v a
	where
		sliceSSSv [] [] [] a = a
		sliceSSSv [i:is] [j:js] [k:ks] a = sliceSSSv is js ks (sliceSSSh s1h s2h s3h a)
		where
			sliceSSSh [] [] [] a = a
			sliceSSSh [u:us] [v:vs] [w:ws] a =: { [i, u] = aiu, [j, v] = ajv, [k, w] = akw}
				#! g1 = g ajv akw
				= sliceSSSh us vs ws { a & [i, u] = f aiu g1} 

sliceCCC c1 f c2 g c3 a :== sliceCCC c1 c2 c3 a
where
	sliceCCC (Col c1v c1) (Col c2v c2) (Col c3v c3) a = sliceCCCv c1v c2v c3v a
	where
		sliceCCCv [] [] [] a = a
		sliceCCCv [i:is] [j:js] [k:ks] a =: { [i, c1] = aic, [j, c2] = ajc, [k, c3] = akc}
			#! g1 = g ajc akc
			= sliceCCCv is js ks { a & [i, c1] = f aic g1} 
	
sliceRRR r1 f r2 g r3 a :== sliceRRR r1 r2 r3 a
where
	sliceRRR (Row r1 r1h) (Row r2 r2h) (Row r3 r3h) a = sliceRRRh r1h r2h r3h a
	where
		sliceRRRh [] [] [] a = a
		sliceRRRh [u:us] [v:vs] [w:ws] a =: { [r1, u] = aru, [r2, v] = arv, [r3, w] = arw}
			#! g1 = g arv arw
			= sliceRRRh us vs ws { a & [r1, u] = f aru g1} 

sliceEEE e1 f e2 g e3 a :== sliceEEE e1 e2 e3 a
where
	sliceEEE (Ele e1v e1h) (Ele e2v e2h) (Ele e3v e3h) a =: { [e1v, e1h] = ae1, [e2v, e2h] = ae2, [e3v, e3h] = ae3}
		#! g1 = g ae2 ae3
		= { a & [e1v, e1h] = f ae1 g1} 

sliceSSE s1 f s2 g e a :== sliceSSE s1 s2 e a
where
	sliceSSE (Sli s1v s1h) (Sli s2v s2h) (Ele e3v e3h) a =: { [e3v, e3h] = e}
		= sliceSSEv s1v s2v a
	where
		sliceSSEv [] [] a = a
		sliceSSEv [i:is] [j:js] a = sliceSSEv is js (sliceSSEh s1h s2h a)
		where
			sliceSSEh [] [] a = a
			sliceSSEh [u:us] [v:vs] a =: { [i, u] = aiu, [j, v] = ajv}
				#! g1 = g ajv e
				= sliceSSEh us vs { a & [i, u] = f aiu g1} 

sliceCCE c1 f c2 g e a :== sliceCCE c1 c2 e a
where
	sliceCCE (Col c1v c1) (Col c2v c2) (Ele e3v e3h) a =: { [e3v, e3h] = e}
		= sliceCCEv c1v c2v a
	where
		sliceCCEv [] [] a = a
		sliceCCEv [i:is] [j:js] a =: { [i, c1] = aic, [j, c2] = ajc}
				#! g1 = g ajc e
				= sliceCCEv is js { a & [i, c1] = f aic g1} 

sliceRRE r1 f r2 g e a :== sliceRRE r1 r2 e a
where
	sliceRRE (Row r1 r1h) (Row r2 r2h) (Ele e3v e3h) a =: { [e3v, e3h] = e}
		= sliceRREh r1h r2h a
	where
		sliceRREh [] [] a = a
		sliceRREh [u:us] [v:vs] a =: { [r1, u] = aru, [r2, v] = arv}
			#! g1 = g arv e
			= sliceRREh us vs { a & [r1, u] = f aru g1} 

sliceSVV s f v g w a :== sliceSVV s v w a
where
	sliceSVV (Sli sv sh) x y a = sliceSVVv sv 0 a
	where
		n = size x
		m = size y
		sliceSVVv [] _ a = a
		sliceSVVv [s1:sv] i a 
			| i==n = a
		    = sliceSVVv sv (inc i) (sliceSVVh sh 0 a)
		where
			sliceSVVh [] j a = a
			sliceSVVh [s2:sh] j a
				| j==m = a
			sliceSVVh [s2:sh] j a =: { [s1, s2] = ass}
				#! g1 = g x.[i] y.[j]
				= sliceSVVh sh (inc j) { a & [s1, s2] = f ass g1} 

sliceEVV e f v g w a :== sliceEVV e v w a
where
	sliceEVV (Ele e1 e2) x y a = { a & [e1, e2] = sliceEVV` 0 0.0}
	where
		n = size x
		sliceEVV` k acc 
			| k==n = acc 
			#! g1 = g x.[k] y.[k]
			= sliceEVV` (inc k) (f acc g1) 

sliceSE s f e a :== sliceSE s e a
where
	sliceSE (Sli sv sh) (Ele ev eh) a =: { [ev, eh] = ae} 
		= sliceSEv sv a
	where
		sliceSEv [] a = a
		sliceSEv [i:is] a
			= sliceSEv is (sliceSEh sh a)
		where
			sliceSEh [] a = a
			sliceSEh [u:us] a =: { [i, u] = aiu}
				= sliceSEv us { a & [i, u] = f aiu ae} 

sliceCE c f e a :== sliceCE c e a
where
	sliceCE (Col cv c) (Ele ev eh) a =: { [ev, eh] = ae} 
		= sliceCEv cv a
	where
		sliceCEv [] a = a
		sliceCEv [i:is] a =: { [i, c] = aic}
			= sliceCEv is { a & [i, c] = f aic ae} 

sliceRE r f e a :== sliceRE r e a
where
	sliceRE (Row r rh) (Ele ev eh) a =: { [ev, eh] = ae} 
		= sliceREh rh a
	where
		sliceREh [] a = a
		sliceREh [u:us] a =: { [r, u] = aru}
			= sliceREh us { a & [r, u] = f aru ae} 
	
sliceSS s1 f s2 a :== sliceSS s1 s2 a
where
	sliceSS (Sli s1v s1h) (Sli s2v s2h) a 
		= sliceSSv s1v s2v a
	where
		sliceSSv [] [] a = a
		sliceSSv [i:is] [j:js] a 
			= sliceSSv is js (sliceSSh s1h s2h a)
		where
			sliceSSh [] [] a = a
			sliceSSh [u:us] [v:vs] a =: { [i, u] = aiu, [j, v] = ajv}
			= sliceSSh us vs { a & [i, u] = f aiu ajv} 

sliceCC c1 f c2 a :== sliceCC c1 c2 a
where
	sliceCC (Col c1v c1) (Col c2v c2) a 
		= sliceCCv c1v c2v a
	where
		sliceCCv [] [] a = a
		sliceCCv [i:is] [j:js] a =: { [i, c1] = aic1, [j, c2] = ajc2}
			= sliceCCv is js { a & [i, c1] = f aic1 ajc2} 

sliceRR r1 f r2 a :== sliceRR r1 r2 a
where
	sliceRR (Row r1 r1h) (Row r2 r2h) a 
		= sliceRRh r1h r2h a
	where
		sliceRRh [] [] a = a
		sliceRRh [u:us] [v:vs] a =: { [r1, u] = aru, [r2, v] = arv}
			= sliceRRh us vs { a & [r1, u] = f aru arv} 

sliceEE e1 f e2 a :== sliceEE e1 e2 a
where
	sliceEE (Ele e1v e1h) (Ele e2v e2h) a =: { [e1v, e1h] = ae1, [e2v, e2h] = ae2}
		= { a & [e1v, e1h] = f ae1 ae2} 

sliceSM s f m a :== sliceSM s m a
where
	sliceSM (Sli s1v s1h) b a 
		= sliceSMv s1v 0 a
	where
		sliceSMv [] _ a = a
		sliceSMv [i:is] j a 
			= sliceSMv is (inc j) (sliceSMh s1h 0 a)
		where
			sliceSMh [] _ a = a
			sliceSMh [u:us] v a =: { [i, u] = aiu}
			= sliceSMh us (inc v) { a & [i, u] = f aiu b.[j, v]} 

sliceCV c f v a :== sliceCV c v a
where
	sliceCV (Col c1v c1) x a 
		= sliceCVv c1v 0 a
	where
		sliceCVv [] _ a = a
		sliceCVv [i:is] j a =: { [i, c1] = aic1}
			= sliceCVv is (inc j) { a & [i, c1] = f aic1 x.[j]} 

sliceRV r f v a :== sliceRV r v a
where
	sliceRV (Row r1 r1h) y a 
		= sliceRVh r1h 0 a
	where
		sliceRVh [] _ a = a
		sliceRVh [u:us] v a =: { [r1, u] = aru}
			= sliceRVh us (inc v) { a & [r1, u] = f aru y.[v]} 

sliceMipC :: .Matrix Col *Matrix -> *Matrix
sliceMipC b (Col cv c) a 
	#! v = cutC (Col cv c) a
	= imbedC (Col cv c) (b ** v) a
	 
sliceMipS :: .Matrix Sli *Matrix -> *Matrix
sliceMipS b (Sli sv sh) a 
	= sliceMipSh sh a
where
	sliceMipSh [] a = a
	sliceMipSh [i:is] a = sliceMipSh is (sliceMipC b (Col sv i) a)	

imbedC :: Col Vector *Matrix -> *Matrix
imbedC (Col cs cc) v a = ivc cs 0 a
where
	n = size v
	ivc :: [Int] Int *Matrix -> *Matrix 
	ivc [] _ a = a
	ivc [c:cs] k a 
		| (k==n) = a
		= ivc cs (inc k) { a & [c, cc] = v.[k]}

imbedR :: Row Vector *Matrix -> *Matrix
imbedR (Row rr rs) v a = ivr rs 0 a
where
	n = size v
	ivr :: [Int] Int *Matrix -> *Matrix 
	ivr [] _ a = a
	ivr [r:rs] k a 
		| (k==n) = a
		= ivr rs (inc k) { a & [rr, r] = v.[k]}

imbedS :: Sli .Matrix *Matrix -> *Matrix
imbedS (Sli cs rs) b a = imc cs 0 a
where
	n = size b
	m = size b.[0]
	imc :: [Int] Int *Matrix -> *Matrix 
	imc [] _ a = a
	imc [c:cs] i a 
		| (i==n) = a
		= imc cs (inc i) (imr rs 0 a)
	where
		imr :: [Int] Int *Matrix -> *Matrix
		imr [] _ a = a
		imr [r:rs] j a 
			| (j==m) = a
			= imr rs (inc j) { a & [c, r] = b.[i, j]}

cutR :: Row .Matrix -> .Vector
cutR (Row r rs) a = crk 0 rs (zeros n)
where
	n = length rs
	crk k [] v = v
	crk k [rr:rs] v = crk (inc k) rs { v & [k] = a.[r, rr]}

cutC :: Col .Matrix -> .Vector
cutC (Col cs c) a = cck 0 cs (zeros m)
where
	m = length cs
	cck k [] v = v
	cck k [cc:cs] v = cck (inc k) cs { v & [k] = a.[cc, c]}

cutS :: Sli .Matrix -> .Matrix
cutS (Sli s1 s2) a = csi 0 s1 (zeroMatrix n m)
where
	n = length s1
	m = length s2
	csi i [] b = b
	csi i [s1:ss1] b = csi (inc i) ss1 (csj 0 s2 b)
	where
		csj j [] b = b
		csj j [s2:ss2] b = csj (inc j) ss2 { b & [i, j] = a.[s1, s2]}

cutRM :: Row .Matrix -> .Matrix
cutRM (Row r rs) a = crj 0 rs (zeroMatrix 1 m)
where
	m = length rs
	crj j [] v = v
	crj j [rr:rs] v = crj (inc j) rs { v & [0, j] = a.[r, rr]}

cutCM :: Col .Matrix -> .Matrix
cutCM (Col cs c) a = cci 0 cs (zeroMatrix n 1)
where
	n = length cs
	cci i [] v = v
	cci i [cc:cs] v = cci (inc i) cs { v & [i, 0] = a.[cc, c]}

instance MatrixVectorProduct (Sli, {# {# Real}})
where
	(**) (s, a) x = ipVector s a x
	 

instance MatrixMatrixProduct (Sli, {# {# Real}})
where
	(***) (s, a) b = ipMatrix s a b

	 
ipVector :: Sli .Matrix .Vector -> .Vector
ipVector (Sli sv sh) a x = ipvv sv 0 (zeros lv)
where
	lv = length sv
	ipvv []      _ w = w
	ipvv [s1:sv] i w = ipvv sv (inc i) { w & [i] = ipvh sh 0 0.0}
	where
		ipvh []      _ acc = acc
		ipvh [s2:sh] j acc = ipvh sh (inc j) (acc + a.[s1, s2] * x.[j])

ipMatrix :: Sli .Matrix .Matrix -> .Matrix
ipMatrix (Sli sv sh) a b = transpose { (Sli sv sh, a) ** bb \\ bb <-: (transpose b)}

transposeSlice :: (Sli, .Matrix) -> (Sli, .Matrix)
transposeSlice ((Sli sv sh), a) = (Sli sh sv, transpose a)