// ************************************************************
//	Clean Linear Algebra Subroutines - CLAS
//	Version 0.7 - June 23, 1999 - Thorsten Zoerner
// 	Catholic University of Nijmegen - zoerner@cs.kun.nl
// ************************************************************

implementation module SampleVec

import StdArray, StdEnum, StdList, StdReal, StdString

:: Vector :== {# Real}

uniVec :: .Vector -> *Vector
uniVec x = { xx \\ xx <-: x}

zeros :: Int -> .Vector
zeros n = createArray n 0.0

ones :: Int -> .Vector
ones n = createArray n 1.0

one2n :: Int -> .Vector
one2n n = { toReal i \\ i <- [1 .. n]}

ek :: Int Int -> .Vector
ek k n = { zeros n & [k] = 1.0}

prettyRowVector :: Vector -> String
prettyRowVector x = "\n" +++ (prettyRowVector_i 0)
where
	n = size x
	prettyRowVector_i :: Int -> String
	prettyRowVector_i i 
		| (i==n) = "\n"
		= (toString x.[i]) +++ "\t\t" +++ (prettyRowVector_i (inc i))
  
prettyColumnVector :: Vector -> String
prettyColumnVector x = "\n" +++ (prettyColumnVector_i 0)
where
	n = size x
	prettyColumnVector_i :: Int -> String
	prettyColumnVector_i i 
		| (i==n) = "\n"
		= (toString x.[i]) +++ "\n" +++ (prettyColumnVector_i (inc i))
