// ************************************************************
//	Clean Linear Algebra Subroutines - CLAS
//	Version 0.7 - June 23, 1999 - Thorsten Zoerner
// 	Catholic University of Nijmegen - zoerner@cs.kun.nl
// ************************************************************

implementation module Clas1

import SampleVec, StdBool

dot :: !.Vector .Vector -> Real
dot x y = dot_i 0 0.0
where
	n = size x
	m = size y
	dot_i :: !Int !Real -> Real
	dot_i i acc 
		| (i==n) || (i==m) = acc
		= dot_i (inc i) (acc + (x.[i] * y.[i]))   
	
nrm1 :: !.Vector -> Real
nrm1 x = nrm1_i 0 0.0
where
	n = size x
	nrm1_i :: !Int !Real -> Real
	nrm1_i i acc 
		| (i==n) = acc
		= nrm1_i (inc i) (acc + (abs x.[i])) 
	
nrm2 :: !.Vector -> Real
nrm2 x = sqrt (dot x x)

nrmInf :: !.Vector -> Real
nrmInf x = nrmInf_i 0 0.0
where
	n = size x
    nrmInf_i :: !Int !Real -> Real
    nrmInf_i i max 
        | (i==n) = max
        | (abs x.[i])>max = nrmInf_i (inc i) (abs x.[i]) 
        = nrmInf_i (inc i) max

amax :: !.Vector -> Int
amax x = amax_i 0 0
where
	n = size x
	amax_i :: !Int !Int -> Int
	amax_i i max 
		| (i==n) = max
		| ((abs x.[i])>(abs x.[max])) = amax_i (inc i) i
		= amax_i (inc i) max

givens :: Real !Real -> (Real, Real)    // (a,b) -> (c,s)
givens a 0.0 = (0.0, 1.0) 
givens a b | ((abs b)>(abs a)) = (s * tau, s) 
where 
	tau=(~a)/b 
	s=1.0 / (sqrt (1.0 + (tau * tau)))
givens a b = (c, c * tau) 
where 
	tau=(~b)/a
	c=1.0 / (sqrt (1.0 + (tau * tau)))
  
class swap a :: *{# .a} .Int .Int -> .{# .a}

instance swap Int
where 
	swap x i j
		| (i==j) = x
		#! (xi, x) = replace x i 0
		#! (xj, x) = replace x j xi
		= { x & [i] = xj}

instance swap {# Real}
where 
	swap x i j 
		| (i==j) = x
		#! (xi, x) = replace x i {}
		#! (xj, x) = replace x j xi
		= { x & [i] = xj}

instance + {# a} | + , ArrayElem a
where 
	(+) a b = { aa + bb \\ aa <-: a & bb <-: b}

instance - {# a} | - , ArrayElem a
where 
	(-) a b = { aa - bb \\ aa <-: a & bb <-: b}

instance * {# a} | *, ArrayElem a			// Hadamard product
where
	(*) a b = { aa * bb \\ aa <-: a & bb <-: b}
	
instance / {# a} | /, ArrayElem a			// Hadamard division
where
	(/) a b = { aa / bb \\ aa <-: a & bb <-: b}
	
class ScalarProduct a
where
	(.*) infix 7 :: Real a -> a

instance ScalarProduct Real
where	
	(.*) a x = a * x

instance ScalarProduct {# a} | ScalarProduct , ArrayElem a
where	
	(.*) a x = { a .* xx \\ xx <-: x}
	
class ScalarDivision a
where
	(/.) infix 7 :: a Real -> a

instance ScalarDivision Real
where	
	(/.) x a = x / a

instance ScalarDivision {# a} | ScalarDivision , ArrayElem a
where	
	(/.) x a = { xx /. a \\ xx <-: x}
