// ************************************************************
//	Clean Linear Algebra Subroutines - CLAS
//	Version 0.6 - February 23, 1998 - Thorsten Zoerner
// 	Catholic University of Nijmegen - zoerner@cs.kun.nl
// ************************************************************

definition module Clas3

import Clas2, StdMisc

class MatrixMatrixProduct a
where
	(***) infix 7 :: a a -> a

instance MatrixMatrixProduct {# {# Real}}

solve 			:: *Matrix .Vector -> .Vector
solvePartPiv	:: *Matrix .Vector -> .Vector

lu 		:: *Matrix -> *Matrix					// LU factorization A=LU
// overwrites the input matrix A with both factors L and U:
//        u_00      u_01    ..        ..        u_0(n-1)
//        l_10      u_11    ..        ..           ..
//         ..       l_21    ..        ..           ..
//         ..        ..     ..  u_(n-2)(n-1)  u_(n-2)(n-1)
//      l_(n-1)0  l_(n-1)1  ..  l_(n-1)(n-1)  u_(n-1)(n-1)
// The diagonal l_ii, i=1,...,n of L is constant 1 by construction.

luPartPiv :: *Matrix -> (*Matrix, *{# Int})		// LU factorization with
												// partial pivoting PA=LU
// Overwrites the input matrix A with both factors L and U (cf. above)
// and returns the permutation P as an array of integers. The right hand side 
// vector has to be permuted accordingly.

invert 	:: *Matrix -> .Matrix					// inverts matrix by means of
												// the Gauss-Jordan algorithm

