// ************************************************************
//	Clean Linear Algebra Subroutines - CLAS
//	Version 0.6 - February 23, 1998 - Thorsten Zoerner
// 	Catholic University of Nijmegen - zoerner@cs.kun.nl
// ************************************************************

implementation module Clas2

import Clas1, SampleMat, StdDebug

class MatrixVectorProduct a
where
	(**) infix 7 :: a .Vector -> .Vector
	
instance MatrixVectorProduct {# {# Real}}
where
	(**) a x = { dot aa x \\ aa <-: a}

//	instance MatrixVectorProduct .{# Int}
//	where
//		(**) p x = perVec p x
	
transpose :: .Matrix -> .Matrix
transpose a = transpose_i 0 (zeroMatrix m n)
where
	n = size a
	m = size a.[0]
	transpose_i :: Int *Matrix -> *Matrix
	transpose_i i b
		| (i==m) = b
		= transpose_i (inc i) { b & [i] = { a.[j,i] \\ j <- [0 .. (dec n)]}}  

perVec :: {# Int} .Vector -> .Vector
perVec p x = perVec_k 0 (zeros n) 
where
	n = size x
	perVec_k :: Int *Vector -> *Vector
	perVec_k k y
		| (k==n) = y
		= perVec_k (inc k) { y & [k] = x.[p.[k]]}

forwardSubst :: Matrix Vector -> *Vector
forwardSubst l b = forwardSubst_i 1 { zeros n & [0] = b.[0] }
where
	n = size l
	forwardSubst_i :: Int *Vector -> *Vector
	forwardSubst_i i y
		#! dotly = dot l.[i] y
		| (i==dec n) = { y & [i] = b.[i] - dotly }
		= forwardSubst_i (inc i) { y & [i] = b.[i] - dotly }

backwardSubst :: Matrix Vector -> *Vector
backwardSubst u y = backwardSubst_i (n-2) { zeros n & [dec n] = (y.[dec n] / u.[dec n, dec n]) }
where
	n = size u
	backwardSubst_i :: Int *Vector -> *Vector
	backwardSubst_i i x 
		#! dotux = dot u.[i] x
		| (i==0) = {x & [i] = (y.[i] - dotux) / u.[i,i]}
		= backwardSubst_i (dec i) {x & [i] = (y.[i] - dotux) / u.[i,i]}

