module HelloWorld

/*
	Hello World!
*/

import deltaEventIO, deltaMenu, deltaWindow, deltaPicture


Don`tCareId	:==	0

//	Start: this is where the execution of our program starts

Start	:: * World -> * World
Start initialWorld
	=  finalWorld
	where

		// fetch the event stream from the world
		(events, world1)
			= OpenEvents initialWorld

		// perform our IO function on the event stream
		finalEvents
			=	HelloWorldIO events

		// close the event stream
		finalWorld
			=	CloseEvents finalEvents world1;


// HelloWorldIO: this is the function that performs the IO on the event stream

HelloWorldIO :: *EVENTS -> *EVENTS
HelloWorldIO events
	=	finalEvents
	where

		// this program doesn't use the program state, so we can specify anything
		initialProgramState
			=	0

		(finalProgramState, finalEvents)
			=	StartIO [menuSystem, windowSystem] initialProgramState [] events

		// this program only uses menus and windows
		ioSystem
			= [menuSystem, windowSystem]

		menuSystem
			=	MenuSystem [fileMenu]
			where
				fileMenu
					=	PullDownMenu Don`tCareId "File" Able
	      		  		[MenuItem Don`tCareId "Quit" (Key 'Q') Able quitFunction]

				// bye, bye
				quitFunction programState io
					=	(programState, QuitIO io)

		windowSystem
			=	WindowSystem [window]
			where	
				// this the only window in our program
				window
					=	FixedWindow  Don`tCareId (10, 10) "Greeting" ((0,0),(162,100)) updateFunction []

				// update the contens of the window
				updateFunction area programState
					=	(programState, [MovePenTo (30, 30), DrawString "Hello World!"])
