definition module FractalTypes;

import deltaEventIO, deltaMenu, deltaWindow, deltaTimer, deltaPicture;

     

  MyWindow :== 1;
    MyPos :== (0,0);

  TimerID :== 1;

  FileID :== 2;
    QuitID :== 21;
  OptionsID :== 3;
    FixedDepthsID :== 33;
      Depth32ID   :== 331;
      Depth64ID   :== 332;
      Depth128ID  :== 333;
      Depth256ID  :== 334;
      Depth512ID  :== 335;
      Depth1024ID :== 336;
    AreasID :== 34;
      Area1ID :== 341;
      Area2ID :== 342;
      Area3ID :== 343;
      Area4ID :== 344;
      Area5ID :== 345;
      Area6ID :== 346;
      Area7ID :== 347;
    FunctionsID :== 35;
      Function1ID :== 351;
      Function2ID :== 352;
      Function3ID :== 353;
      Function4ID :== 354;
      Function5ID :== 355;
	ColoursID :== 36;
	  Colour1ID :== 361;
	  Colour2ID :== 362;
	  Colour3ID :== 363;
	  Colour4ID :== 364;
	  Colour5ID :== 365;
  CommandsID :== 4;
    DrawID :== 41;
    ZoomInID :== 43;
    ZoomOutID :== 44;
    StopDrawID :== 45;
    ContinueID :== 46;

  ScreenWidth :== 664;  // was: 540;
  ScreenHeight :== 400; // was: 340;
  
  NrOfColours :== 512;

  AreaIds :== [Area1ID,Area2ID,Area3ID,Area4ID,Area5ID,Area6ID,Area7ID];
 
    
:: * FractalState :== (FunctionState, DrawState, ZoomState);
::   FunctionState :== (Area, Colours, CalcDepth, FractalFunction);
::     Area :== (Centrum, Width, Height);
::       Centrum :== (Real, Real);
::       Width :== Real;
::       Height :== Real;
::     Colours :== (Int,Int,Int,Int,Int,Int);
::     CalcDepth :== Int;
::     FractalFunction =  MSquare | MCube | MSin | MCos | MExp;
::   DrawState :== (Layer, GrainSize, LineNr);
::     Layer :== Int;
::     GrainSize :== Int;
::     LineNr :== Int;
::   ZoomState :==  Rectangle;

:: *IO :==  IOState FractalState;

    
SetFFunction :: FractalState FractalFunction -> FractalState;
SetArea :: FractalState	Area -> FractalState;
SetNrOfColours :: FractalState Colours -> FractalState;
SetCalcDepth ::	FractalState CalcDepth -> FractalState;
SetDrawState ::	FractalState DrawState -> FractalState;
SetZoomState :: FractalState ZoomState -> FractalState;

