implementation module showtm;

import	StdClass;
from	deltaIOSystem	import UpdateArea;
import	deltaPicture;
import	StdInt;
from	StdString			import !!, #, %;
from	StdChar			import toString;
from	StdBool          import &&;

import	tm;


     

	StatePos :== (10,17);
	ErrorPos :== (10,17);
	NamePos  :== (130,17);
	TapeY	 :== 40;
	Room	 :== 14;
	Offset	 :== 10;
	TransY	 :== 40;
	MaxX	 :== 29900;


    

/*	Draw a Turing machine: tape, transitions, name and state.
*/

ShowTape	:: Tape Picture -> Picture;
ShowTape (cont,pos) pic
		=  ShowMachine hpos cont (EraseRectangle ((0,0),(MaxX,100)) pic);
		   where {
		   hpos=: HeadPos pos;
		   };

ShowTransitions	:: [Trans] String Picture -> Picture;
ShowTransitions trs state pic
		=  DrawTransitions 0 trs frame;
		   where {
		   frame=: ShowTransFrame sstat;
		   sstat=: ShowState state (EraseRectangle ((0,0),(MaxX,300)) pic);
		   };

ShowTransFrame	:: Picture -> Picture;
ShowTransFrame pic
		=  ShowTransBorders (Offset + 135) limit y1 y2 frame;
		   where {
		   frame=: DrawRectangle ((Offset - 4,y1), (limit, inc y2)) pic;
		   limit=: MaxX - 80;
		   y1=: TransY - 14;
		   y2=: TransY + 201;
		   };

ShowTransBorders	:: Int Int Int Int Picture -> Picture;
ShowTransBorders x limit y1 y2 pic
		| x >= limit =  pic;
		=  ShowTransBorders (x + 140) limit y1 y2 pic1;
		   where {
		   pic1=: LinePenTo (x, y1) (MovePenTo (x, y2) pic);
		   };

DrawTransitions	:: Int [Trans] Picture -> Picture;
DrawTransitions n [] pic =  pic;
DrawTransitions n [((from_new,head),(to,move)):trs] pic
		=  DrawTransitions (inc n) trs (DrawTrans n from_new head to move pic);

DrawTrans	:: Int String Char String Char Picture -> Picture;
DrawTrans n from_new head to move pic
		=  DrawString (toString move) p1;
		   where {
		   p1=: DrawString ","    (DrawString to p2);
		   p2=: DrawString " -> " (DrawString (toString head) p3);
		   p3=: DrawString ","    (DrawString from_new p4);
		   p4=: MovePenTo (x + 5,y) pic;
		   (x,y)=: TransPos n;
		   };

ShowTapePart	:: Tape Int Int Picture -> Picture;
ShowTapePart (cont,pos) from_new to pic
		=  DrawHeadRect (HeadPos pos) RedColour tape;
		   where {
		   tape=:  ShowContPart 0 (# cont) Offset cont (from_new - 30) (to + 30) lines;
		   lines=: LinePenTo (MaxX,y1) (MovePenTo (x,y1) line);
		   line=:  LinePenTo (MaxX,y2) (MovePenTo (x,y2) pic);
		   x=:	  Offset - 4;
		   y1=:	  TapeY - 13;
		   y2=:	  TapeY + 5;
		   };

ShowContPart	:: Int Int Int String Int Int Picture -> Picture;
ShowContPart i l x s f t pic
		| x > t =  pic;
		| x < f =  ShowContPart (inc i) l (x + Room) s f t pic;
		| i < l =  ShowContPart (inc i) l (x + Room) s f t dstr;
		=  ShowContPart (inc i) l (x + Room) s f t dfrm;
		   where {
		   dstr=: DrawString char (MovePenTo (x,TapeY) dfrm);
		   dfrm=: LinePenTo (x`,TapeY - 13) (MovePenTo (x`,TapeY + 5) pic);
		   char=: toString (s !! i);
		   x`  =: x - 4;
		   };

ShowMachine	:: Int String Picture -> Picture;
ShowMachine pos cont pic
		=  DrawHeadRect pos RedColour tape;
		   where {
		   tape=: ShowTapeContents cont pic;
		   };

ShowState	:: String Picture -> Picture;
ShowState state pic
		=  ShowNextState state title;
		   where {
		   title=: DrawString "State:" (MovePenTo StatePos frame);
		   frame=: DrawRectangle ((x - 4, y - 11), (x + 81, y + 4)) pic;
		   (x,y)=: StatePos;
		   };

ShowTapeContents	:: String Picture -> Picture;
ShowTapeContents cont pic
		=  DrawTapeFrame (ShowCont 0 (# cont) Offset cont pic);

ShowCont	:: Int Int Int String Picture -> Picture;
ShowCont i l x s pic
		| i == l =  pic; 
		=  ShowCont (inc i) l (x + Room) s (DrawString char move);
		   where {
		   char=: toString (s !! i);
		   move=: MovePenTo (x, TapeY) pic;
		   };

DrawTapeFrame	:: Picture -> Picture;
DrawTapeFrame pic
		=  DrawCellBorders x y1 y2 lines;
		   where {
		   lines=: LinePenTo (MaxX,y1) (MovePenTo (x,y1) line);
		   line=:  LinePenTo (MaxX,y2) (MovePenTo (x,y2) pic);
		   x=:	  Offset - 4;
		   y1=:	  TapeY - 13;
		   y2=:	  TapeY + 5;
		   };

DrawCellBorders	:: Int Int Int Picture -> Picture;
DrawCellBorders x y1 y2 pic
		| x > MaxX =  pic;
		=  DrawCellBorders (x + Room) y1 y2 border;
		   where {
		   border=: LinePenTo (x,y1) (MovePenTo (x,y2) pic);
		   };


/*	Make a step of the T.M. (transition) visible on the screen.
*/
		   
ShowNewTape	:: Comm Int Picture -> Picture;
ShowNewTape com pos pic
		=  ShowComm com (HeadPos pos) pic;

ShowNextState	:: String Picture -> Picture;
ShowNextState state pic
		=  SetPenColour BlackColour p1;
		   where {
		   p1=:	  DrawString state (MovePenTo (x + 40, y) p2);
		   p2=:	  EraseRectangle ((x + 39,y - 10),(x + 80, y + 3)) p3;
		   p3=:	  SetPenColour RedColour pic;
		   (x,y)=: StatePos;
		   };

ShowTransition	:: Int Int Picture -> Picture;
ShowTransition old new pic
		=  DrawTransRect new RedColour (DrawTransRect old WhiteColour pic);

DrawTransRect	:: Int Colour Picture -> Picture;
DrawTransRect nr color pic
		=  SetPenColour BlackColour rect;
		   where {
		   rect=: DrawRectangle ((x - 1, y - 11), (x + 133, y + 4)) col;
		   col=:  SetPenColour color pic;
		   (x,y)=: TransPos nr;
		   };

DrawHeadRect	:: Int Colour Picture -> Picture;
DrawHeadRect pos color pic
		=  SetPenColour BlackColour rect;
		   where {
		   rect=: DrawRectangle ((pos, TapeY - 11), (pos + 11, TapeY + 4)) col;
		   col=:  SetPenColour color pic;
		   };

HeadPos	:: Int -> Int;
HeadPos pos =   Offset +  Room * pos   - 2;

TransPos	:: Int -> (Int,Int);
TransPos nr =  (Offset +  140 * (nr / 14) , TransY +  15 * (nr mod 14) );

MoveToHeadPos	:: Int Picture -> Picture;
MoveToHeadPos pos pic =  MovePenTo (pos + 2, TapeY) pic;

EraseCell	:: Int Picture -> Picture;
EraseCell x pic =  EraseRectangle ((inc x, TapeY - 10), (x + 10, TapeY + 3)) pic;

ShowComm	:: Comm Int Picture -> Picture;
ShowComm Erase pos pic
		=  DrawString "#" (MoveToHeadPos pos (EraseCell pos pic));
ShowComm None pos pic
		=  pic;
ShowComm (Write c) pos pic
		=  DrawString (toString c) (MoveToHeadPos pos (EraseCell pos pic));
ShowComm MoveR1 pos pic
		=  DrawHeadRect newpos RedColour (DrawHeadRect pos WhiteColour draw);
		   where {
		   newpos=: pos + Room;
		   draw=: DrawString "#" (MovePenTo (newpos + 2,TapeY) pic);
		   };
ShowComm MoveR pos pic
		=  DrawHeadRect newpos RedColour (DrawHeadRect pos WhiteColour pic);
		   where {
		   newpos=: pos + Room;
		   };
ShowComm MoveL pos pic
		=  DrawHeadRect newpos RedColour (DrawHeadRect pos WhiteColour pic);
		   where {
		   newpos=: pos - Room;
		   };
ShowComm Halt pos pic
		=  pic;
ShowComm ErrorL pos pic
		=  DrawError "Error: Head went over left edge." pic;
ShowComm ErrorT pos pic
		=  DrawError "Error: No Transition applicable." pic;
ShowComm x pos pic
		=  DrawError "Fatal Error: Unknown Command." pic;

DrawError	:: String Picture -> Picture;
DrawError mes pic
		=  SetPenColour BlackColour p4;
		   where {
		   p4    =: DrawString mes (MovePenTo (x,y) p3);
		   p3    =: SetPenColour RedColour p2;
		   p2    =: DrawRectangle ((x - 5, y - 11), (x + (w + 5), y + 4)) p1;
		   (w,p1)=: PictureStringWidth mes pic;
		   (x,y) =: ErrorPos;
		   };

EraseError	:: Picture -> Picture;
EraseError pic =  EraseRectangle ((ex - 5, ey - 11), (ex + 299, ey + 4)) pic;
					  where {
					  (ex,ey)=: ErrorPos;
					  };


/*	For the dialogs:
*/

StrToInt	:: String -> Int;
StrToInt str =  CharToInt (str !! 0);

CharToInt	:: Char -> Int;
CharToInt '1' =  1;
CharToInt '2' =  2;
CharToInt '3' =  3;
CharToInt '4' =  4;
CharToInt '5' =  5;
CharToInt '6' =  6;
CharToInt '7' =  7;
CharToInt '8' =  8;
CharToInt '9' =  9;
CharToInt chr =  0;

FourCharString	:: String -> String;
FourCharString str |  # str  > 4 =  str % (0, 3);
					   =  str;

FirstChar	:: String -> Char;
FirstChar str |  # str  == 0 =  '#';
				  =  str !! 0;


/*	ClickedIn... determines where the mouse clicked: on a tape cell,
	on a transition, on the state or on the name.
*/

ClickedInWindow	:: (Int,Int) -> (Int,Bool,Bool);
ClickedInWindow (x,y)
		| trans =  (trnr, True , False);
		| state =  (0   , False, True );
		=  (0   , False, False);
		   where {
		   trans=: InRectangle (x,y) (Offset, TransY - 13, MaxX, TransY + 201);
		   state=: InRectangle (x,y) (statex - 3, statey - 10, statex + 79, statey + 3);
		   trnr=:    (x - Offset) / 120  * 14  +  (y - (TransY - 10)) / 15 ;
		   (statex,statey)=: StatePos;
		   };

ClickedInTapeWd	:: (Int,Int) -> (Int,Bool);
ClickedInTapeWd (x,y)
		| tape =  (tpos, True );
		=  (0   , False);
		   where {
		   tape=:  InRectangle (x,y) (Offset, TapeY - 11, MaxX, TapeY + 4);
		   tpos=: ( x - Offset  + 3) / Room;
		   };

InRectangle	:: (Int, Int) (Int, Int, Int, Int) -> Bool;
InRectangle (x, y) (lx, ly, ux, uy)
		=    x >= lx  &&  x < ux   && ( y > ly  &&  y < uy );


/*	Functions to show a change of the T.M. when the T.M. is edited.
*/

HiliteTransition	:: Int Trans Picture -> Picture;
HiliteTransition tnr ((from_new,head),(to,move)) pic
		=  DrawTrans tnr from_new head to move pc1;
		   where {
		   pc1=: SetPenColour BlackColour pc2;
		   pc2=: FillRectangle ((x, y - 9), (x + 131, y + 2)) pc3;
		   pc3=: SetPenColour YellowColour pic;
		   (x,y)=: TransPos tnr;
		   };

ShowTrans	:: Int Trans Picture -> Picture;
ShowTrans tnr ((from_new,head),(to,move)) pic
		=  DrawTrans tnr from_new head to move (EraseTrans tnr pic);

EraseTrans	:: Int Picture -> Picture;
EraseTrans tnr pic =  EraseRectangle ((x, y - 9), (x + 131, y + 2)) pic;
		   				  where {
		   				  (x,y)=: TransPos tnr;
		   				  };
		   
HiliteState	:: String Picture -> Picture;
HiliteState state pic
		=  DrawString state (MovePenTo (x + 40,y) pc3);
		   where {
		   pc3=: SetPenColour BlackColour pc2;
		   pc2=: FillRectangle ((x + 39, y - 9), (x + 78, y + 2)) pc1;
		   pc1=: SetPenColour YellowColour pic;
		   (x,y)=: StatePos;
		   };

HiliteCell	:: Int Char Picture -> Picture;
HiliteCell pos cell pic
		=  DrawString (toString cell) (MovePenTo (x + 2, TapeY) pc3);
		   where {
		   pc3=: SetPenColour BlackColour pc2;
		   pc2=: FillRectangle ((inc x, TapeY - 10), (x + 10, TapeY + 3)) pc1;
		   pc1=: SetPenColour YellowColour (EraseError pic);
		   x=:   HeadPos pos;
		   };

DrawTapeCell	:: Int Char Picture -> Picture;
DrawTapeCell pos cell pic
		=  DrawString (toString cell) (MovePenTo (x + 2, TapeY) (EraseCell x pic));
		   where {
		   x=: HeadPos pos;
		   };

ShowHeadMove	:: String Int Int Int Int Picture -> Picture;
ShowHeadMove cont from_new to left right pic
		=  DrawHeadRect xto RedColour (DrawHeadRect xfrom WhiteColour tape);
		   where {
		   tape=:  ShowTapePart (cont,from_new) left right pic;
		   xto=:   HeadPos to;
		   xfrom=: HeadPos from_new;
		   };

//	Set the font of the Turing machine windows.

SetTuringFont	:: Picture -> Picture;
SetTuringFont pict =  SetFontSize 10 (SetFontName "Courier" pict);
