implementation module Help;

import	StdClass;
import StdString, StdInt, StdChar, StdBool, StdFile;
import deltaSystem, deltaEventIO, deltaIOSystem, deltaWindow, deltaPicture, deltaFont;

    
::	* UFILE	:== * File;
::	InfoDef		:== (Int,Int,[InfoLine]);
::	InfoLine		:== (InfoFontDef,Int,Int,String);
::	InfoFontDef	=  InfoFont Font Centred | NoFont Centred;
::	Centred		:== Bool;
::	Fonts			:== (Font,Font,Font,Font);
::	Heights		:== (Int,Int);

     
	HelpWdID			:== 30000;
	InfoFontName1	:== "Geneva";
	InfoFontName2	:== "Helvetica";
	InfoFontName3	:== "Times";
	NormalSize1		:== 9;
	NormalSize2		:== 12;
	LargeSize1		:== 12;
	LargeSize2		:== 14;
	NormalStyle		:== [];
	BoldStyle		:== ["Bold"];
	Margin			:== 8;
	AboutBegin		:== "\\About";
	AboutEnd			:== "\\EndAbout";
	HelpBegin		:== "\\Help";
	HelpEnd			:== "\\EndHelp";
	About				:== False;
	Help				:== True;

    

//
//	General AboutDialog construction.
//

MakeAboutDialog	:: String String Files (*s -> *( (IOState *s) -> (*s, IOState *s) ))
	                                       -> (DialogDef *s (IOState *s), Files);
MakeAboutDialog appname infofile files helpf
	=  (AboutDialog appname ((0,0),(xmax,ymax)) picture (AboutHelp "Help" helpf), files`);
		where {
		picture                =: DrawAboutInfo nft (xmax,ymax,text);
		(xmax,ymax,text,files`)=: ReadInfo About fonts AboutBegin AboutEnd infofile files;
		fonts                  =: InfoFonts;
		(nft,lft,bft,dft)      =: fonts;
		};

InfoFonts	::    Fonts;
InfoFonts = (nft,lft,bft,dft);
		where {
		nft=: SelectNormalFont NormalStyle;
		lft=: SelectLargeFont  NormalStyle;
		bft=: SelectNormalFont BoldStyle;
		dft=: SelectLargeFont  BoldStyle;
		};

SelectLargeFont	:: [FontStyle] -> Font;
SelectLargeFont style
	| found1 =  first;
	| found2 =  second;
	=  third;
	   where {
	   (found1,first )=: SelectFont InfoFontName1 style LargeSize1;
	   (found2,second)=: SelectFont InfoFontName2 style LargeSize2;
	   (dummy ,third )=: SelectFont InfoFontName3 style LargeSize2;
	   };

SelectNormalFont	:: [FontStyle] -> Font;
SelectNormalFont style
	| found1 =  first;
	| found2 =  second;
	=  third;
	   where {
	   (found1,first )=: SelectFont InfoFontName1 style NormalSize1;
	   (found2,second)=: SelectFont InfoFontName2 style NormalSize2;
	   (dummy ,third )=: SelectFont InfoFontName3 style NormalSize2;
	   };

/*	Reading and pre-processing of the file containing the about- and help-info. */

ReadInfo	:: Bool Fonts String String String Files -> (Int,Int,[InfoLine],Files);
ReadInfo help fonts begin end filename files
	| not succes && help =  (x1,y1,lines1,files1);
	| not succes =  (x3,y3,lines3,files1);
	| not found   && help =  (x2,y2,lines2,files`);
	| not found =  (x3,y3,lines3,files`);
	=  (xm,ym,lines ,files`);
		where {
		(b,files`)          =: fclose file` files1;
		(xm,ym,lines)       =: ProcessInfoStrings fonts info;
		(found,info,file`)  =: ReadInfoFile begin end file;
		(succes,file,files1)=: fopen (ApplicationPath filename) FReadText files;
		(x1,y1,lines1)      =: ProcessInfoStrings fonts [errpref +++ "could not be found."];
		(x2,y2,lines2)      =: ProcessInfoStrings fonts [errpref +++ "does not contain help information."];
		(x3,y3,lines3)      =: ProcessInfoStrings fonts ["\\DThis is a Clean program."];
		errpref             =: "The help file \'" +++  filename +++ "\' " ;
		};

ProcessInfoStrings	:: Fonts [String] -> InfoDef;
ProcessInfoStrings fonts=:(nft,lft,bft,dft) lines
	=  (maxx`,  maxy + Margin  - lat, lines``);
		where {
		lines``           =: CenterInfoLines nft maxx` lines`;
		maxx`             =: Margin + (maxx + Margin);
		(maxx,maxy,lines`)=: AddFontToInfoLines fonts heights 0 (Margin + lat) lines;
		heights				=: (nat + (ndt + nld), lat + (ldt + lld));
		(nat,ndt,nmw,nld) =: FontMetrics nft;
		(lat,ldt,lmw,lld)	=: FontMetrics lft;
		};

CenterInfoLines	:: Font Int [InfoLine] -> [InfoLine];
CenterInfoLines nft maxx [info=:(inft=:NoFont centered,x,y,line) : rest]
	| centered =  [(inft,x`,y,line) : CenterInfoLines nft maxx rest];
	=  [info : CenterInfoLines nft maxx rest];
		where {
		x`=: (maxx -  FontStringWidth line nft ) / 2;
		};
CenterInfoLines nft maxx [info=:(inft=:InfoFont font centered,x,y,line) : rest]
	| centered =  [(inft,x`,y,line) : CenterInfoLines nft maxx rest];
	=  [info : CenterInfoLines nft maxx rest];
		where {
		x`=: (maxx -  FontStringWidth line font ) / 2;
		};
CenterInfoLines nft maxx [] =  [];

AddFontToInfoLines	:: Fonts Heights Int Int [String] -> InfoDef;
AddFontToInfoLines fonts heights maxx maxy [line : rest]
	=  (maxx`, maxy`, [(font,Margin,maxy,line`) : rest`]);
		where {
		(maxx`,maxy`,rest`) =: AddFontToInfoLines fonts heights (max maxx wid) (maxy + hgt) rest;
		(font,wid,hgt,line`)=: ParseInfoLine fonts heights line;
		};
AddFontToInfoLines fonts heights maxx maxy [] =  (maxx, maxy, []);

ParseInfoLine	:: Fonts Heights String -> (InfoFontDef,Int,Int,String);
ParseInfoLine fonts=:(nft,lft,bft,dft) heights=:(nhgt,lhgt) line
	| linelen < 2 ||  line !! 0  <> '\\' =  (NoFont False, FontStringWidth line nft, nhgt, line);
	=  (infofont, FontStringWidth line` font, height, line`);
		where {
		(infofont,font,height)=: GetInfoFont_and_Height (line !! 1) fonts heights;
		linelen=: # line;
		line`  =: line % (2, dec linelen);
		};

GetInfoFont_and_Height	:: Char Fonts Heights -> (InfoFontDef,Font,Int);
GetInfoFont_and_Height 'L' (nft,lft,bft,dft) (nhgt,lhgt) =  (InfoFont lft False, lft, lhgt);
GetInfoFont_and_Height 'b' (nft,lft,bft,dft) (nhgt,lhgt) =  (InfoFont bft False, bft, nhgt);
GetInfoFont_and_Height 'B' (nft,lft,bft,dft) (nhgt,lhgt) =  (InfoFont dft False, dft, lhgt);
GetInfoFont_and_Height 'c' (nft,lft,bft,dft) (nhgt,lhgt) =  (NoFont True       , nft, nhgt);
GetInfoFont_and_Height 'C' (nft,lft,bft,dft) (nhgt,lhgt) =  (InfoFont lft True , lft, lhgt);
GetInfoFont_and_Height 'd' (nft,lft,bft,dft) (nhgt,lhgt) =  (InfoFont bft True , bft, nhgt);
GetInfoFont_and_Height 'D' (nft,lft,bft,dft) (nhgt,lhgt) =  (InfoFont dft True , dft, lhgt);
GetInfoFont_and_Height chr (nft,lft,bft,dft) (nhgt,lhgt) =  (NoFont False      , nft, nhgt);

ReadInfoFile	:: String String UFILE -> (Bool,[String],UFILE);
ReadInfoFile begin end file
	| not begin_found =  (False, []   , file1);
	=  (True , lines, file`);
		where {
		(lines      ,file`)=: ReadInfoUntil end file1;
		(begin_found,file1)=: FindInfoBegin begin file;
		};

FindInfoBegin	:: String UFILE -> (Bool,UFILE);
FindInfoBegin begin file
	| sfend file =  (False,file);
	| eq_PRFX begin line =  (True,file`);
	=  FindInfoBegin begin file`;
		where {
		(line,file`)=: freadline file;
		};

ReadInfoUntil	:: String UFILE -> ([String],UFILE);
ReadInfoUntil end file
	| sfend file =  ([], file );
	| eq_PRFX end line =  ([], file1);
	=  ([StripNewline line : lines], file`);
		where {
		(lines,file`)=: ReadInfoUntil end file1;
		(line ,file1)=: freadline file;
		};

/*	The drawing of the about/help info. */

DrawAboutInfo	:: Font InfoDef -> [DrawFunction];
DrawAboutInfo nft (xmax,ymax,lines) =  [SetFont nft, DrawInfo nft 0 ymax lines];

DrawInfo	:: Font Int Int [InfoLine] Picture -> Picture;
DrawInfo nft top bot [(InfoFont font c,x,y,line) : rest] pic
	| y > bot =  pic;
	| y < top =  DrawInfo nft top bot rest pic;
	=  DrawInfo nft top bot rest (SetFont nft (DrawString line (SetFont font (MovePenTo (x,y) pic))));
DrawInfo nft top bot [(NoFont c,x,y,line) : rest] pic
	| y > bot =  pic;
	| y < top =  DrawInfo nft top bot rest pic;
	=  DrawInfo nft top bot rest (DrawString line (MovePenTo (x,y) pic));
DrawInfo nft top bot [] pic =  pic;

//
//	The Help function.
//

ShowHelp	:: String Files (IOState s) -> (Files, IOState s);
ShowHelp infofile files io =  (files`,OpenWindows [window] io);
		where {
		window=: FixedWindow HelpWdID (0,0) "Help" ((0,0),(xmax,ymax))
							                           (UpdateHelpWd nft text) [];
		(xmax,ymax,text,files`)=: ReadInfo Help fonts HelpBegin HelpEnd infofile files;
		fonts                  =: InfoFonts;
		(nft,lft,bft,dft)      =: fonts;
		};
		
UpdateHelpWd	:: Font [InfoLine] UpdateArea * s -> (*s, [DrawFunction]);
UpdateHelpWd nft lines areas s =  (s, [SetFont nft, RedrawAreas nft lines areas]);

RedrawAreas	:: Font [InfoLine] UpdateArea Picture -> Picture;
RedrawAreas nft lines [area=:((l,t),(r,b)) : rest] pict
	=  RedrawAreas nft lines rest (DrawInfo nft (dec t) (b + 40) lines pict);
RedrawAreas nft lines [] pict =  pict;

/*	Support functions for the AboutDialog construction. */

eq_PRFX	:: String String -> Bool;
eq_PRFX prefix string
	| prefixlen >  # string  =  False;
	=  prefix ==  string % (0, dec prefixlen) ;
		where {
		prefixlen=: # prefix;
		};

StripNewline	:: String -> String;
StripNewline ""     =  "";
StripNewline string
	|  string !! last  <> '\n' =  string;
	=  string % (0, dec last);
		where {
		last=: dec (# string);
		};

