module FileCopy;

/*
Menu driven version of a file copying program, extended with
a progress dialog (window).

Run the program using the "No Console" option.

To generate an application for this program the memory of the Clean
0.8 application should be set to at least 1.6 Mb. To launch the
generated application another 450K of free memory is needed.
*/

import	StdClass;
import StdBool, StdInt, StdChar, StdString, StdFile, deltaPicture;
import deltaEventIO, deltaIOSystem, deltaFileSelect, deltaWindow;
import deltaDialog, deltaSystem;

    
::	* IO	:==  IOState Files;

     
	BlockSize	:== 1024;
	BarWid		:== 200;
	BarHgt		:== 10;

    

Start	:: * World -> * World;
Start world =  CloseEvents events` (closefiles files` world``);
		where {
		(files`,events`)=: StartIO [MenuSystem [menu]] files [] events;
		(files ,world``)=: openfiles world`;
		(events,world` )=: OpenEvents world;
		menu=: PullDownMenu 1 "Copy" Able [
					MenuItem 1 "Copy..." (Key 'C') Able Copy,
					MenuItem 2 "Quit"    (Key 'Q') Able Quit];
		};

Quit	:: Files IO -> (Files,IO);
Quit files io =  (files, QuitIO io);

Copy	:: Files IO -> (Files,IO);
Copy files io
	| not srcopen =  (files1,io1);
	| not dstopen =  (files2,io2);
	| source == dest =  (files2, Alert ["Copying succeeded."] io2);
	=  CopyFile source dest files2 io2;
		where {
		(dstopen,dest  ,files2,io2)=: SelectOutputFile "" "" files1 io1;
		(srcopen,source,files1,io1)=: SelectInputFile files io;
		};

CopyFile	:: String String Files IO -> (Files,IO);
CopyFile source dest files io
	| not sopen = 	(files1,alert1);
	| not dopen = 	(files2,alert2);
	| io_error = 	(files4,alert3);
	| not dclose = 	(files4,alert4);
	| not sclose = 	(files4,alert5);
	= 	(files4,io2);
		where {
		(sclose,files4)              =: fclose sfile`` files3;
		(dclose,files3)              =: fclose dfile`  files2;
		(io_error,sfile``,dfile`,io2)=: CopyFiles 0 (inc length) sfile` dfile io1;
		(length,sfile`)              =: FileLength sfile;
		io1                          =: OpenProgressWindow source dest io;
		(dopen,dfile,files2)         =: fopen dest FWriteText files1;
		(sopen,sfile,files1)         =: fopen source FReadData files;
		alert1=: Alert ["Copying failed.","Source file could not be opened."]      io;
		alert2=: Alert ["Copying failed.","Destination file could not be opened."] io;
		alert3=: Alert ["Copying failed.","An I/O error occurred during copying."] io2;
		alert4=: Alert ["Copying failed.","Destination file could not be closed."] io2;
		alert5=: Alert ["Copying failed.","Source file could not be closed."]      io2;
		};

//	Stricness annotation is necessary. Otherwise the bar would be updated after the copy.

CopyFiles	:: Int Int * File * File !IO -> (Bool, * File, * File, IO);
CopyFiles nr total source dest io
	| srcend || wrterror =  (wrterror,source1,dest1,CloseActiveWindow io);
	=  CopyFiles nr` total source2 (fwrites block dest1) io`;
		where {
		nr`             =: nr +  # block ;
		(block, source2)=: freads source1 BlockSize;
		(srcend,source1)=: fend source;
		(wrterror,dest1)=: ferror dest;
		io`             =: ShowProgress nr` total io;
		};

ShowProgress	:: Int Int IO -> IO;
ShowProgress nr total io
	=  DrawInActiveWindow [FillRectangle ((0,0),(progress,BarHgt))] io;
		where {
		progress=: (nr * BarWid) / total;
		};

OpenProgressWindow	:: String String IO -> IO;
OpenProgressWindow source dest io
	=  DrawInActiveWindow (BarLook line1 line2) (OpenWindows [window] io);
		where {
		window =: FixedWindow 1 (70,50) "Copy" ((-10,-50),(width,20)) Update_new [];
		width  =: max 210 (meswid + 15);
		meswid =: max (FontStringWidth line1 font) (FontStringWidth line2 font);
		line1  =: "Copying \"" +++   DriveAndName source  +++ "\"" ;
		line2  =: "to \"" +++   DriveAndName dest  +++ "\"" ;
		(b,font)         =: SelectFont name style size;
		(name,style,size)=: DefaultFont;
		};

Update_new	:: UpdateArea Files -> (Files,[DrawFunction]);
Update_new area files =  (files,[]);
	
BarLook	:: String String -> [DrawFunction];
BarLook line1 line2
	=  [MovePenTo (0,-30), DrawString line1,
		 MovePenTo (0,-10), DrawString line2,
		 SetPenPattern LtGreyPattern, FillRectangle bar,
		 SetPenPattern BlackPattern , DrawRectangle bar];
		where {
		bar    =: ((0,0),(BarWid,BarHgt));
		};

FileLength	:: * File -> (Int,* File);
FileLength file =  (length, file```);
		where {
		(dummy2,file```)=: fseek file`` 0 FSeekSet;
		(length,file`` )=: fposition file`;
		(dummy1,file`  )=: fseek file 0 FSeekEnd;
		};

Alert	:: [String] IO -> IO;
Alert mes io =  io`;
		where {
		(id,io`)=: OpenNotice (Notice mes (NoticeButton 1 "OK") []) io;
		};

DriveAndName	:: String -> String;
DriveAndName path
	| not found || fpos == lpos =  path;
	=  drive +++  (sep +++  "..." +++ sep ) +++ name ;
		where {
		drive       =: path % (0, dec fpos);
		name        =: path % (inc lpos, last);
		sep         =: toString DirSeparator;
		(found,fpos)=: FirstColon path 1 last;
		lpos        =: LastColon  path last;
		last        =: dec (# path);
		};

FirstColon	:: String Int Int -> (Bool,Int);
FirstColon path i last
	| i > last =  (False,0);
	| DirSeparator ==  path !! i  =  (True ,i);
	=  FirstColon path (inc i) last;

LastColon :: String Int -> Int;
LastColon path i
	| i <= 0 =  0;
	| DirSeparator ==  path !! i  =  i;
	=  LastColon path (dec i);

StripNewline	:: String -> String;
StripNewline str | len <= 1 =  "";
	                 =  str % (0, (len - 2));
	where {
	len=:(# str);
		
	};

FirstChar	:: String -> Char;
FirstChar "" =  ' ';
FirstChar str =  str !! 0;
