module Editor;

/*	A full featured text editor
	---------------------------

	To generate an application for this program the memory of the Clean
	0.8 application should be set to at least 2600K.
	The linker needs an additional 700K of free memory inside or outside
	the Clean 0.8 application. When linking fails because there is not enough
	memory available try quitting the Clean 0.8 application. Restart it and
	try to link again.
	
	To launch the generated application 1400K of free memory is needed
	outside the Clean 0.8 application.
*/

import	StdClass;
import StdInt, StdString;
import deltaEventIO, deltaTimer, deltaFont;
from deltaWindow import DrawInActiveWindow;

import EdFileMenu, EdEditMenu, EdSearchMenu, EdWindowsMenu;
import EdProgramState, EdDraw, EdFiles;


    

Start	:: * World -> * World;
Start world =  CloseDisk (SaveDefaultSettings editor`) (CloseEvents events` world``);
	where {
	(editor`,events`)=: StartIO [about, menus, timer] editor [] events;
	editor           =: ReadDefaultSettings (InitEditor files`);
	(events ,world` )=: OpenEvents world;
	(files  ,world``)=: openfiles  world`;
	
	about=:	DialogSystem [about_dialog];
	(about_dialog,files`)=: MakeAboutDialog "Clean Editor" files Help;
	
	menus=:	MenuSystem [file, edit, search, windows];

	file=:		PullDownMenu MFileID "File" Able
				[	MenuItem	INewID	"New..."			(Key 'N')	Able		New,
					MenuItem	IOpenID	"Open..."		(Key 'O')	Able		Open,
					MenuItem	ICloseID	"Close"			(Key 'W')	Unable	Close,
					MenuSeparator,
					MenuItem	ISaveID	"Save"			(Key 'S')	Unable	Save,
					MenuItem	ISavesID	"Save As..."	NoKey			Unable	SaveAs,
					MenuItem	IReverID	"Revert"			NoKey			Unable	Revert,
					MenuSeparator,
					MenuItem IQuitID	"Quit"			(Key 'Q')	Able		Quit
				];

	edit=:		PullDownMenu MEditID "Edit" Unable
				[	MenuItem	IUndoID	"Undo"			(Key 'Z')	Able		Undo,
					MenuSeparator,
					MenuItem	ICutID	"Cut"				(Key 'X')	Unable	Cut,
					MenuItem	ICopyID	"Copy"			(Key 'C')	Unable	Copy,
					MenuItem	IPasteID	"Paste"			(Key 'V')	Unable	Paste,
					MenuItem	IClearID	"Clear"			NoKey			Unable	Clear,
					MenuSeparator,
					MenuItem	IBalanID	"Balance"		(Key 'B')	Able		Balance,
					MenuSeparator,
					MenuItem IFormaID "Format"       (Key 'J')   Able     Format
				];
	
	search=:	PullDownMenu MSearcID "Search" Unable
				[	MenuItem	IFindID	"Find..."			(Key 'F')	Able		Find,
					MenuItem	IFindNID	"Find Next"			(Key 'G')	Unable	FindNext,
					MenuItem	IFindSID	"Find Selection"	(Key 'H')	Unable	FindSelection,
					MenuItem	IReplaID	"Replace & Find"	(Key 'T')	Unable	Replace_and_Find,
					MenuSeparator,
					MenuItem	IGotoCID	"Goto Cursor"		(Key 'L')	Able		GotoCursor,
					MenuItem	IGotoLID	"Goto Line..."		NoKey			Able		GotoLine
				];

	windows=:	PullDownMenu MWindoID "Windows" Able
				[	MenuItem	IHelpID	"Help..."			(Key '/')	Able		Help,
					MenuItem	ISaveaID	"Save All"			NoKey			Unable	SaveAll,
					MenuItem	IClosaID	"Close All"			NoKey			Unable	CloseAll,
					MenuSeparator,
					MenuItemGroup IWindoID []
				];

	timer=: 	TimerSystem [Timer TimerID Unable BlinkRate BlinkCursor];
	};

BlinkCursor	:: TimerState Editor IO -> EdIO;
BlinkCursor state editor io
	| blink > 0 =  (editor`, io`);
	=  (editor1, CloseTimer TimerID io2);
	where {
	editor`			=: SetFrontWindow (EW_ToggleCursor front) editor1;
	(editor1,front)=: GetFrontWindow editor;
	io`				=: SetTimerInterval TimerID blink io2;
	(blink,io2)		=: GetTimerBlinkInterval io1;
	io1				=: DrawInActiveWindow [DrawCursor cursorpos (at_new + dt) ld] io;
	cursorpos		=: EW_GetCursorPos front;
	(at_new,dt,ld,ht)	=: EW_GetFontMetrics front;
	};
