implementation module EdWindows;

import	StdClass;
import StdInt, StdBool, StdString, deltaFileSelect;
import deltaEventIO, deltaWindow, deltaMenu, deltaTimer, deltaPicture, deltaDialog;

import EdProgramState, EdDraw, EdDialogs, EdMouse, EdKeyboard, EdSupport, EdFiles;
from EdFileMenu import Close;

     

HorBar		:== ScrollBar (Thumb PictureLeft) (Scroll HorScroll);
VerBar hght	:== ScrollBar (Thumb PictureTop) (Scroll hght);
WindowItem id name :== CheckMenuItem id name NoKey Able Mark (SetThisWindow id);

YesID		:== 1;
NoID		:== 2;
CancelID	:== 3;


    

//
//	Create a new edit-window
//

CreateWindow	:: EditWdId EditWindow String Editor IO -> EdIO;
CreateWindow wdid editwd title editor io
	| windows_present =  (AddWindow wdid editwd editor3, io3);
	=  (AddWindow wdid editwd editor1, io2);
	where {
	(editor3,oldfr)          =: ResetCurLine_and_GetFrontWindow editor2;
	(editor2,oldid)          =: GetWdIdOfFrontWindow editor1;
	(editor1,windows_present)=: WindowsPresent editor;
	io3		=: UnmarkMenuItems [oldid] io2;
	io2		=: DrawInActiveWindow [SetFont rfont, SetPenMode CopyMode] io1;
	io1		=: OpenWindows [window] io;
	window   =: ScrollWindow wdid WdCorner title HorBar (VerBar hght)
				               ((PictureLeft,PictureTop),(PictureRight,bottom))
				               WdMinSize WdInitSize (UpdateWindow wdid)
				               [ Activate (ActivWindow wdid),
				                 Deactivate (DeactivWindow wdid),
				                 GoAway (CloseWindow "closing" wdid),
				                 Keyboard Able Type,
				                 Mouse Able Track,
				                 Cursor IBeamCursor ];
	bottom	          =: PictureBottom nrlines hght;
	nrlines	          =: EW_GetNrLines editwd;
	(font,size,rfont)	 =: EW_GetWindowFont editwd;
	(at_new,dt,ld,hght)	 =: EW_GetFontMetrics editwd;
	};

//
//	Draw the visible lines in the edit window
//

DrawVisibleLines	:: EditWindow Editor IO -> EdIO;
DrawVisibleLines front editor io
	=  DrawInActiveWindowFrame (DrawTheLines front) editor io;	

DrawTheLines	:: EditWindow UpdateArea Editor -> (Editor, [DrawFunction]);
DrawTheLines editwd areas editor
	=  (editor, [EraseTheAreas areas, RedrawTheAreas editwd areas]);

EraseTheAreas	:: UpdateArea Picture -> Picture;
EraseTheAreas [area : rest] pict =  EraseTheAreas rest (EraseRectangle area pict);
EraseTheAreas no_areas      pict =  pict;

//
// The update function for the edit windows
//

UpdateWindow	:: EditWdId UpdateArea Editor -> (Editor, [DrawFunction]);
UpdateWindow wdid areas editor
	=  (editor`, [update]);
	where {
	(editor`,editwd`)	=: UpdateFrontWindow wdid editwd editor1;
	(editor1,editwd)	=: GetWindow wdid editor;
	update				=: RedrawTheAreas editwd` areas;
	};

UpdateFrontWindow	:: EditWdId EditWindow Editor -> (Editor,EditWindow);
UpdateFrontWindow wdid front editor
	| wdid <> frontid =  (editor1,front);
	=  (editor`,front`);
	where {
	(editor1,frontid)=: GetWdIdOfFrontWindow editor;
	(editor`,front`)=: ResetCurLine_and_GetFrontWindow editor1;
	};

//
//	Special Update function to disable updating of windows
//
	
NoUpdates	:: UpdateArea Editor -> (Editor, [DrawFunction]);
NoUpdates area editor =  (editor, []);


/*	Auxiliary functions for UpdateWindow and DrawVisibleLines */

RedrawTheAreas	:: EditWindow UpdateArea Picture -> Picture;
RedrawTheAreas editwd areas pic
	=  RedrawAreas ptop height tabwidth nrlines editwd areas areas pic;
	where {
	ptop						=: PictureTop + (asct + lead);
	(asct,dt,lead,height)=: EW_GetFontMetrics editwd;
	(dummy,tabwidth)		=: EW_GetTabWidth editwd;
	nrlines					=: EW_GetNrLines editwd;
	};

RedrawAreas	:: Int Int Int Int EditWindow UpdateArea UpdateArea Picture -> Picture;
RedrawAreas ptop height tabwidth nrlines editwd [] areas pic
	| IsEmptySelection selection =  RemoveCursor curpos (at_new + dt) ld pic;
	=  RedrawSelection psel height areas pic;
	where {
	selection	 =: EW_GetSelection editwd;
	curpos		 =: EW_GetCursorPos editwd;
	(at_new,dt,ld,ht)=: EW_GetFontMetrics editwd;
	(tsel,psel)	 =: selection;
	};
RedrawAreas ptop height tabwidth nrlines editwd [((left,top),(rght,bot)):rest] areas pic
	=  RedrawAreas ptop height tabwidth nrlines editwd rest areas drawlines;
	where {
	drawlines=: DrawLines yoffset height tabwidth rght lines pic;
	yoffset	=: ptop +  first * height ;
	lines		=: Text_GetLines first number (EW_GetText editwd);
	first		=: Between 0 (dec nrlines) ((top - PictureTop) / height);
	number	=: Between 0 (nrlines - first) ( (bot - top) / height  + 2);
	};

RedrawSelection	:: (Int,Int,Int,Int) Int UpdateArea Picture -> Picture;
RedrawSelection selection height [] pic =  pic;
RedrawSelection selection height [area:areas] pic
	=  RedrawSelection selection height areas (DrawReSelect area selection height pic);

//
// The activate function for the edit windows
//

ActivWindow	:: EditWdId Editor IO -> EdIO;
ActivWindow wdid editor io
	| has_selection =  (editor`,ioa);
	=  (editor`,iob);
	where {
	ioa=: ChangeIOState [ EnableMenuItems [ICutID, ICopyID, IClearID],
		                  DisableTimer TimerID ] io`;
	iob=: ChangeIOState [ DisableMenuItems [ICutID, ICopyID, IClearID],
		                  EnableTimer TimerID ] io`;
	io`=: Apply (If saved (DisableMenuItems [ISaveID, IReverID])
		                  (EnableMenuItems  [ISaveID, IReverID])) io2;
	io2=: MarkMenuItems [wdid] (UnmarkMenuItems [oldid] io1);
	io1=: ChangeIOState [ EnableMenus [MEditID,MSearcID],
								EnableMenuItems [ISavesID],
								ChangeMenuItemFunctions [(ICloseID,Close)] ] io;
	has_selection		=:  bx <> ex  ||  by <> ey ;
	(bx,ex,by,ey)		=: pslctn;
	(tsel,pslctn)		=: EW_GetSelection editwd;
	saved					=: EW_Saved editwd;
	name 					=: RemovePath (EW_GetPathname editwd);
	(editor`,editwd)	=: GetFrontWindow editor2;
	editor2				=: SetWindowInFront wdid editor1;
	(editor1,oldid)	=: GetWdIdOfFrontWindow editor;
	};

//
// The de-activate function for the edit windows
//

DeactivWindow	:: EditWdId Editor IO -> EdIO;
DeactivWindow wdid editor io =  (editor`, io);
	where {
	(editor`,front)=: ResetCurLine_and_GetFrontWindow editor;
	};

//
// The close function for the edit windows
//

CloseWindow	:: String EditWdId Editor IO -> EdIO;
CloseWindow mes wdid editor io
	| EW_Saved front =  CloseTheWindow wdid editor2 io1;
	=  (editor`,io`);
	where {
	(editor`,io`)	=: SaveBeforeCloseNotice wdid name mes editor2 io1;
	io1				=: ActivateWindow wdid io;
	(editor2,front)=: ResetCurLine_and_GetFrontWindow editor1;
	editor1			=: SetWindowInFront wdid editor;
	name				=: RemovePath (EW_GetPathname front);
	};
	
CloseTheWindow	:: EditWdId Editor IO -> EdIO;
CloseTheWindow wdid editor io
	| windows_left =  (editor`, io1);
	=  (editor`, io2);
	where {
	(editor`,windows_left)=: WindowsPresent editor1;
	editor1=: RemoveFrontWindow editor;
	io1=: ChangeIOState [ RemoveMenuItems [wdid],
		                  CloseWindows    [wdid] ] io;
	io2=: ChangeIOState [ DisableMenuItems  [ICloseID, ISavesID, ISaveID, IReverID,
	                                        ISaveaID, IClosaID ],
	                     DisableMenus [MEditID, MSearcID],
	                     DisableTimer TimerID,
	                     CloseDialog DFindID, CloseDialog DTabWID, CloseDialog DGotoLID ] io1;
	};

SaveBeforeCloseNotice	:: EditWdId String String Editor IO -> EdIO;
SaveBeforeCloseNotice wdid name mes editor io
	| butid == YesID =  SvBfClSave wdid editor io`;
	| butid == NoID =  SvBfClDontSave wdid editor io`;
	=  (editor, io`);
	where {
	(butid,io`)=: OpenNotice (Notice [line1,line2] yes [no,cancel]) io;
	line1	=: "Save changes to \"" +++  name +++ "\"" ;
	line2	=: "before " +++  mes +++ "?" ;
	yes	=: NoticeButton YesID "Yes";
	no		=: NoticeButton NoID "No";
	cancel=: NoticeButton CancelID "Cancel";
	};

SvBfClSave	:: EditWdId Editor IO -> EdIO;
SvBfClSave wdid editor io
	| path == "Untitled" =  DoSaveAs wdid path front editor1 io;
	| good =  CloseTheWindow wdid editorb io;
	=  (editorb, AlertDialog ["The file could not be saved because",
	                          "of a file I/O error."] io);
	where {
	(editorb,good)	=: SaveFile path (EW_GetText front) editor1;
	(editor1,front)=: GetFrontWindow editor;
	path				=: EW_GetPathname front;
	};

DoSaveAs :: EditWdId Pathname EditWindow Editor IO -> EdIO;
DoSaveAs wdid oldpath oldwd editor io
	| not save =  (editor1,io`);
	| name == HelpFile =  (editor1,HelpFileAlert io`);
	| good =  CloseTheWindow wdid editor` io`;
	=  (editor`, AlertDialog ["The file could not be saved because",
	                          "of a file I/O error."] io`);
	where {
	(editor`,good)			  =: SaveFile path (EW_GetText oldwd) editor1;
	(save,path,editor1,io`)=: OpenOutputFileSelector (RemovePath oldpath) editor io;
	name						  =: RemovePath path;
	};

SvBfClDontSave	:: EditWdId Editor IO -> EdIO;
SvBfClDontSave wdid editor io =  CloseTheWindow wdid editor io;

//
// SetThiswindow is called when one of the windows in the Windows menu is selected
//

SetThisWindow	:: EditWdId Editor IO -> EdIO;
SetThisWindow wdid editor io =  ActivWindow wdid editor (ActivateWindow wdid io); 

//
// WindowSetFont&Size changes the font and fontsize of the active window
//

WindowSetFont_and_Size	:: FontName FontSize EditWindow Editor IO -> EdIO;
WindowSetFont_and_Size font size editwd editor io
	| IsEmptySelection selection
		                                               =  (editora, ChangeActiveUpdateFunction (UpdateWindow wdid) ioa);
	=  (editorb, ChangeActiveUpdateFunction (UpdateWindow wdid) iob);
	where {
	(editora,ioa)=: DrawVisibleLines fronta (SetFrontWindow fronta editor4) io9;
	(editorb,iob)=: DrawVisibleLines frontb (SetFrontWindow frontb editor4) io9;
	(editor4,io9)=: ChangeActiveScrollBar (ChangeVBar verttmb hght) editor3 io8;
	(editor3,io8)=: ChangeActivePictureDomain picdom editor2 io7;
	io7			 =: DrawInActiveWindow [EraseRectangle visrect] io6;
	(visrect,io6)=: ActiveWindowGetFrame io3;
	io3			 =: DrawInActiveWindow [SetFont rfont] io2;
	io2			 =: ChangeActiveUpdateFunction NoUpdates io1;
	(b,wdid,io1) =: GetActiveWindow io;
	(editor2,frt)=: GetFrontWindow editor1;
	editor1		 =: ChangeFrontWindow [ EW_SetFontMetrics (asct,desc,lead,hght),
					                       EW_SetTabWidth (tabw, rtabw),
					                       EW_SetWindowFont (font,size,rfont) ] editor;
	fronta			 				=: EW_SetCursorPos (False,cx,cy,cx) frt;
	frontb			 				=: EW_SetSelection (tsel,psel) frt;
	psel								=: CalcPixelSelection tsel rtabw hght (EW_GetText editwd) rfont;
	cx									=: CalcCursorX LinesLeft rtabw (Reverse before) rfont;
	selection						=: EW_GetSelection editwd;
	(tsel,ops)						=: selection;
	picdom							=: ((PictureLeft,PictureTop),(PictureRight,bottom));
	bottom							=: PictureBottom nrlines hght;
	nrlines							=: EW_GetNrLines editwd;
	(tabw,dummy)					=: EW_GetTabWidth editwd;
	rtabw								=: tabw *  FontCharWidth ' ' rfont ;
	hght								=: asct + (desc + lead);
	(asct,desc,mw,lead)			=: FontMetrics rfont;
	(c,rfont)          			=: SelectFont font style size;
	(df,style,sz)      			=: DefaultFont;
	verttmb							=: Between PictureTop bottom thumb;
	thumb								=: PictureTop +  hght * ((top - PictureTop) / oldht) ;	
	(lft,top)						=: toplft;
	(toplft,botrgt)				=: visrect;
	(at_new,dt,ld,oldht)				=: EW_GetFontMetrics editwd;
	cy									=: PictureTop +  hght * linenr ;
	(before,aft,linenr,charnr)	=: EW_GetCurLine editwd;
	};

//
//	Set the tab width of a window
//

WindowSetTabWidth	:: Int EditWindow Editor IO -> EdIO;
WindowSetTabWidth rtabw front editor io
	| IsEmptySelection selection =  DrawVisibleLines fronta editora io;
	=  DrawVisibleLines frontb editorb io;
	where {
	editora			 =: SetFrontWindow fronta editor;
	editorb			 =: SetFrontWindow frontb editor;
	fronta			 =: EW_SetCursorPos (False,cx,cy,cx) front1;
	frontb			 =: EW_SetSelection (tsel,psel) front1;
	front1			 =: EW_SetTabWidth (rtabw, tabw) front;
	cx					 =: CalcCursorX LinesLeft tabw (Reverse before) rfont;
	psel				 =: CalcPixelSelection tsel tabw hght (EW_GetText front) rfont; 
	cy					 =: PictureTop +  hght * linenr ;
	tabw				 =: rtabw *  FontCharWidth ' ' rfont ;
	(ft,sz,rfont)	 =: EW_GetWindowFont front;
	selection		 =: EW_GetSelection front;
	(tsel,ops)		 =: selection;
	(at_new,dt,ld,hght) =: EW_GetFontMetrics front;
	(before,aft,linenr,charnr)=: EW_GetCurLine front;
	};

//
//	Adjusts the thumbs such that the indicated line is in the middle of the window
//

WindowGotoLine	:: Int Int EditWindow Editor IO -> EdIO;
WindowGotoLine linenr curx front editor io
	| curx > lft && curx < rgt =  ChangeActiveScrollBar (ChangeVThumb vertmb) editor io`;
	| curx <  PictureLeft + horwidth 
		                                                 =  ChangeActiveScrollBar (ChangeThumbs PictureLeft vertmb) editor io`; 
	=  ChangeActiveScrollBar (ChangeThumbs hortmb vertmb) editor io`;
	where {
	nrlines			=: EW_GetNrLines front;
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	hortmb			=: curx -  horwidth / 2 ;
	vertmb			=: PictureTop +  hght * (linenr -  (bot - top) / (hght + hght) ) ;
	horwidth			=: rgt - lft;
	(rgt,bot)		=: botrgt;
	(lft,top)		=: toplft;
	(toplft,botrgt)=: visrect;
	(visrect,io`)	=: ActiveWindowGetFrame io;
	};


/*	Miscellaneous functions */

Maximum	:: Int Int -> Int;
Maximum x y | x > y =  x;
	            =  y;

SingletonElement	:: [t] -> t;
SingletonElement [x] =  x;

Apply	:: (* t -> *t) *t -> *t;
Apply f x =  f x;
