implementation module EdSearchMenu;

/*	The commands of the Search menu */

import	StdClass;
import StdInt, StdString, StdBool;
import deltaEventIO, deltaMenu, deltaTimer, deltaWindow, deltaDialog, deltaPicture, deltaIOState;

import EdProgramState, EdDialogs, EdWindows, EdDraw, EdSupport, EdKeyboard;

     
	Lin1ID	:== 1;
	Lin2ID	:== 2;
	But1ID	:== 3;
	But2ID	:== 4;

	BIgnID 	:== 51;
	BBacID	:== 52;
	BWraID	:== 53;
	BMatID	:== 54;
	EFinID	:== 2;
	ERepID	:== 4;

    

//
//	Device function for the Find... command: The Find dialog
//

Find :: Editor IO -> EdIO;
Find editor io =  (editor`, OpenDialog dialog io);
	where {
	dialog=: CommandDialog DFindID "Find" [] 9 [st1,et1,st2,et2,boxes,bt1,bt2,bt3,bt4];
	st1	=: StaticText 1 Left "Find:";
	et1	=: EditText EFinID (YOffset 1 (MM 1.0)) (MM 120.0) 1 (FI_GetFind findinfo);
	st2	=: StaticText 3 (Below EFinID) "Replace With:";
	et2	=: EditText ERepID (YOffset 3 (MM 1.0)) (MM 120.0) 1 (FI_GetReplace findinfo);
	boxes	=: CheckBoxes 5 Left (Rows 2) [
				CheckBox BIgnID "Ignore Case" Able (BoolToMark ignore) Donothing,
				CheckBox BBacID "Backward"    Able (BoolToMark backw)  Donothing,
				CheckBox BWraID "Wrap Around" Able (BoolToMark wrap)   Donothing,
				CheckBox BMatID "Match Words" Able (BoolToMark match)  Donothing ];
	bt1	=: DialogButton 6 Left        "Cancel"      Able Cancel;
	bt2	=: DialogButton 7 (RightTo 6) "Replace All" Able ReplaceAll;
	bt3	=: DialogButton 8 (RightTo 7) "Replace"     Able Replace;
	bt4	=: DialogButton 9 (RightTo 8) "Find"        Able FindFind;
	(editor`,findinfo)=: GetFindInfo editor;
	(ignore,backw,wrap,match)=: FI_GetOptions findinfo;
	};


GetFindDialogInfo	:: DialogInfo -> FindInfo;
GetFindDialogInfo dinfo =  (find,replace,ignore,backw,wrap,match);
	where {
	find		=: GetEditText EFinID dinfo;
	replace	=: GetEditText ERepID dinfo;
	ignore	=: CheckBoxMarked BIgnID dinfo;
	backw		=: CheckBoxMarked BBacID dinfo;
	wrap		=: CheckBoxMarked BWraID dinfo;
	match		=: CheckBoxMarked BMatID dinfo;
	};


FindFind	:: DialogInfo Editor IO -> EdIO;
FindFind dialog editor io =  FindNext editor` io`;
	where {
	editor`					=: SetFindInfo findinfo editor;
	io`						=: AbleFindItems find backw io;
	(find,r,i,backw,w,m)	=: findinfo;
	findinfo					=: GetFindDialogInfo dialog;
	};


Replace	:: DialogInfo Editor IO -> EdIO;
Replace dialog editor io
	| fnd && rpl =  GotoCursor editora (ResetCursor ioa);
	| fnd =  GotoCursor editorb (ResetCursor iob);
	=  (editor2, Alert io1);
	where {
	editora			=: ChangeFrontWindow [ EW_SetSaved False ] editorb;
	editorb			=: ChangeFrontWindow [ EW_SetCurLine (bef,aft,l1,c1),
						                      EW_SetText text`,
						                      EW_SetSelection selection,
						                      EW_SetCursorPos curpos ] editor2;
	(editor2,front)=: ResetCurLine_and_GetFrontWindow editor1;
	editor1			=: SetFindInfo findinfo editor;
	ioa				=: ChangeIOState [ DrawInActiveWindow [
						                    Erase_and_DrawLine (cy + ofs) hght ofs tabw PictureRight line,
						                    DrawReHilite selection hght],
						                  EnableMenuItems [ISaveID, IReverID] ] iob;
	iob				=: ChangeIOState [ EnableMenuItems [ICutID,ICopyID,IClearID,IFindSID],
						                  DrawInActiveWindow [DrawReHilite selection hght],
						                  DisableTimer TimerID,
						                  ChangeActiveKeyboardFunction TypeSelect ] io2;
	io2				=: EvtUnSelect front (SetGlobalCursor BusyCursor io1);
	io1				=: AbleFindItems find backw io;
	(rpl,text`)		=: If (replace == "") (False,text) (Text_Replace l1 c1 find replace text);
	(fnd,fsel)		=: Text_Find nrlines ln cn find ignore backw wrap match text;
	tsel				=: (l1,c1,l2,If rpl (c1 +  # replace ) c2);
	psel				=: CalcPixelSelection tsel tabw hght text` rfont;
	(l1,c1,l2,c2)	=: fsel;
	(x2,y2,cx,cy)	=: psel;
	selection		=: (tsel,psel);
	(bef,aft)		=: Line_SplitLine c1 line;
	curpos			=: (True,cx,cy,x2);
	(ln,cn)			=: If backw (bl,bc) (el,ec);
	ofs				=: at_new + ld;
	line				=: Text_GetLine l1 text`;
	text				=: EW_GetText front;
	(bl,bc,el,ec)	=: EW_GetTextPosition front;
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	(ft,sz,rfont)	=: EW_GetWindowFont front;
	(rtw,tabw)		=: EW_GetTabWidth front;
	nrlines			=: EW_GetNrLines front;
	findinfo			=: GetFindDialogInfo dialog;
	(find,replace,ignore,backw,wrap,match)=: findinfo;
	};


Cancel	:: DialogInfo Editor IO -> EdIO;
Cancel dialog editor io =  (editor, ActivateWindow wdid io1);
	where {
	(b,wdid,io1)=: GetActiveWindow io;
	};


ReplaceAll	:: DialogInfo Editor IO -> EdIO;
ReplaceAll dialog editor io
	| fnd =  FinishReplaceAll replace editor` io`;
	=  (editor2, Alert io1);
	where {
	editor`			=: ChangeFrontWindow [ EW_SetCurLine (bef,aft,lnr,c1),
						                      EW_SetText text,
						                      EW_SetSelection selection,
						                      EW_SetCursorPos curpos,
						                      EW_SetSaved False ] editor2;
	(editor2,front)=: ResetCurLine_and_GetFrontWindow editor1;
	editor1			=: SetFindInfo (find,replace,ignore,backw,wrap,match) editor;
	io`				=: EvtUnSelect front (EnableMenuItems [ISaveID, IReverID] io1);
	io1				=: AbleFindItems find backw io;
	(fnd,tsel,text)=: Text_ReplaceAll find replace ignore match (EW_GetText front);
	psel				=: CalcPixelSelection tsel tabw hght text rfont;
	(lnr,c1,ln2,c2)=: tsel;
	(x2,y2,cx,cy)	=: psel;
	selection		=: (tsel,psel);
	curpos			=: (False,cx,cy,x2);
	(bef,aft)		=: Line_SplitLine c1 (Text_GetLine lnr text);
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	(ft,sz,rfont)	=: EW_GetWindowFont front;
	(rtw,tabw)		=: EW_GetTabWidth front;
	findinfo			=: GetFindDialogInfo dialog;
	(find,replace,ignore,backw,wrap,match)=: findinfo;
	};

FinishReplaceAll	:: String Editor IO -> EdIO;
FinishReplaceAll "" editor io
	=  GotoCursor editor` io`;
	where {
	(editor`,io`)	=: DrawVisibleLines front editor2 io2;
	editor2			=: SetFrontWindow (EW_SetSelection EmptySelection front) editor1;
	(editor1,front)=: GetFrontWindow editor;
	io2				=: DisableMenuItems [ICutID,ICopyID,IClearID,IFindSID,IReplaID] io1;
	io1				=: EnableTimer TimerID io;
	};
FinishReplaceAll repl editor io
	=  GotoCursor editor` io`;
	where {
	(editor`,io`)	=: DrawVisibleLines front editor1 io1;
	(editor1,front)=: GetFrontWindow editor;
	io1				=: ChangeIOState [ EnableMenuItems [ICutID,ICopyID,IClearID,IFindSID],
						                  DisableTimer TimerID,
						                  ChangeActiveKeyboardFunction TypeSelect ] io;
	};


Donothing	:: DialogInfo (DialogState Editor IO) -> DialogState Editor IO;
Donothing def dstate =  dstate;

//
//	Device function for the Find Next/Find Previous command
//

FindNext :: Editor IO -> EdIO;
FindNext editor io
	| fnd =  GotoCursor editor` io`;
	=  (editor2, Alert io);
	where {
	editor`			=: ChangeFrontWindow [ EW_SetCurLine (bef,aft,l1,c1),
						                      EW_SetSelection selection,
						                      EW_SetCursorPos curpos ] editor2;
	(editor2,front)=: ResetCurLine_and_GetFrontWindow editor1;
	(editor1,finfo)=: GetFindInfo editor;
	io`				=: ChangeIOState
						    [ EnableMenuItems [ICutID,ICopyID,IClearID,IFindSID,IReplaID],
						      DrawInActiveWindow [DrawReHilite selection hght],
						      DisableTimer TimerID,
						      ChangeActiveKeyboardFunction TypeSelect ] io1;
	io1				=: EvtUnSelect front io;
	psel				=: CalcPixelSelection tsel tabw hght text rfont;
	(fnd,tsel)		=: Text_Find nrlines ln cn find ignore backw wrap match text;
	(l1,c1,l2,c2)	=: tsel;
	(x2,y2,cx,cy)	=: psel;
	selection		=: (tsel,psel);
	(bef,aft)		=: Line_SplitLine c1 (Text_GetLine l1 text);
	curpos			=: (True,cx,cy,x2);
	(ln,cn)			=: If backw (bl,bc) (el,ec);
	text				=: EW_GetText front;
	(bl,bc,el,ec)	=: EW_GetTextPosition front;
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	(ft,sz,rfont)	=: EW_GetWindowFont front;
	(rtw,tabw)		=: EW_GetTabWidth front;
	nrlines			=: EW_GetNrLines front;
	find				=: FI_GetFind finfo;
	(ignore,backw,wrap,match)=: FI_GetOptions finfo;
	};

//
//	Device function for the Find Selection command
//

FindSelection :: Editor IO -> EdIO;
FindSelection editor io
	| ol1 <> ol2 =  (editor1,io);
	| fnd =  GotoCursor editor` io`;
	=  (editor3,Alert io2);
	where {
	editor`			=: ChangeFrontWindow [ EW_SetCurLine (bef,aft,l1,c1),
						                      EW_SetSelection selection,
						                      EW_SetCursorPos curpos ] editor3;
	editor3			=: SetFindInfo (FI_SetFind find finfo) editor2;
	(editor2,finfo)=: GetFindInfo editor1;
	(editor1,front)=: ResetCurLine_and_GetFrontWindow editor;
	io`				=: DrawInActiveWindow
						    [DrawReHilite oldsel hght, DrawReHilite selection hght] io2;
	io2				=: ChangeDialog DFindID [ChangeEditText EFinID find] io1;
	io1				=: EnableMenuItems [IFindNID] io;
	psel				=: CalcPixelSelection tsel tabw hght text rfont;
	(fnd,tsel)		=: Text_Find nrlines ln cn find ignore backw wrap match text;
	(l1,c1,l2,c2)	=: tsel;
	(x2,y2,cx,cy)	=: psel;
	selection		=: (tsel,psel);
	(bef,aft)		=: Line_SplitLine c1 (Text_GetLine l1 text);
	curpos			=: (True,cx,cy,x2);
	(ln,cn)			=: If backw (bl,bc) (el,ec);
	text				=: EW_GetText front;
	oldsel			=: EW_GetSelection front;
	(bl,bc,el,ec)	=: EW_GetTextPosition front;
	(ft,sz,rfont)	=: EW_GetWindowFont front;
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	(rtw,tabw)		=: EW_GetTabWidth front;
	nrlines			=: EW_GetNrLines front;
	find				=: SingletonElement (Text_CopySelection oldsel text);
	(ignore,backw,wrap,match)=: FI_GetOptions finfo;
	(ol1,oc1,ol2,oc2)			 =: otsel;
	(otsel,opsel)				 =: oldsel;
	};

//
//	Device function for the Repace & Find command
//

Replace_and_Find :: Editor IO -> EdIO;
Replace_and_Find editor io
	| ol1 <> ol2 || no_match =  (editor2,io);
	| fnd =  GotoCursor editor` ioa;
	| lenrepl > 0 =  (editor`,Alert ioa);
	=  (editor`,Alert iob);
	where {
	editor`				=: ChangeFrontWindow [ EW_SetText text`,
							                      EW_SetCurLine (bef,aft,l1,c1),
							                      EW_SetSelection selection,
							                      EW_SetCursorPos curpos ] editor2;
	(editor2,finfo)	=: GetFindInfo editor1;
	(editor1,front)	=: ResetCurLine_and_GetFrontWindow editor;
	ioa					=: DrawInActiveWindow [DrawReHilite selection hght] io`;
	iob					=: ChangeIOState
							    [ DisableMenuItems [ICutID,ICopyID,IClearID,IFindSID,IReplaID],
						         EnableTimer TimerID,
						         ChangeActiveKeyboardFunction Type ] io`;
	io`					=: DrawInActiveWindow [DrawReHilite oldsel hght,
		 						     Erase_and_DrawLine basey hght ofs tabw PictureRight line] io;
	fpsel					=: CalcPixelSelection ftsel tabw hght text` rfont;
	rpsel					=: CalcPixelSelection rtsel tabw hght text` rfont;
	(fnd,ftsel)			=: Text_Find nrlines ln cn find ignore backw wrap match text`;
	(rpl,text`)			=: Text_Replace ol1 oc1 find repl text;
	rtsel					=: (ol1,oc1,ol1,oc1 + lenrepl);
	(ft,sz,rfont)		=: EW_GetWindowFont front;
	text					=: EW_GetText front;
	oldsel				=: EW_GetSelection front;
	(bl,bc,el,ec)		=: EW_GetTextPosition front;
	(at_new,dt,ld,hght)	=: EW_GetFontMetrics front;
	(rtw,tabw)			=: EW_GetTabWidth front;
	nrlines				=: EW_GetNrLines front;
	no_match				=: not (StringMatch 0 (# find) find selstr ignore False);
	selstr				=: SingletonElement (Text_CopySelection oldsel text);
	selection			=: If fnd (ftsel,fpsel) (rtsel,rpsel);
	(bef,aft)			=: Line_SplitLine c1 (Text_GetLine l1 text`);
	curpos				=: (False,cx,cy,x2);
	(l1,c1,l2,c2)		=: If fnd ftsel rtsel;
	(x2,y2,cx,cy)		=: If fnd fpsel rpsel;
	(ln,cn)				=: If backw (bl,bc) (bl,bc + lenrepl);
	(ol1,oc1,ol2,oc2)	=: otsel;
	(obx,oby,oex,oey)	=: opsel;
	(otsel,opsel)		=: oldsel;
	basey					=: oby + ofs;
	ofs					=: at_new + ld;
	line					=: Text_GetLine ol1 text`;
	lenrepl				=: # repl;
	(find,repl,ignore,backw,wrap,match)=: finfo;
	};
	

//
//	Device function for the Goto Line command
//

GotoLine :: Editor IO -> EdIO;
GotoLine editor io =  OpenModalDialog dialog editor` io;
	where {
	dialog=: CommandDialog IGotoLID "Goto Line" [] But2ID [stext,etext,cancel,ok];
	stext	=: StaticText Lin1ID Center "Goto Line:";
	etext	=: EditText Lin2ID (RightTo Lin1ID) (Inch 0.5) 1 (toString (inc curlnr));
	cancel=: DialogButton But1ID (Below Lin2ID) "Cancel" Able GotoLineCancel;
	ok		=: DialogButton But2ID (RightTo But1ID) "OK" Able GotoLineOK;
	(editor`,front)	=: GetFrontWindow editor;
	(curlnr,cnr,d1,d2)=: EW_GetTextPosition front;
	};

GotoLineOK	:: DialogInfo Editor IO -> EdIO;
GotoLineOK dinfo editor io
	| linenr == curlnr =  (editor1, io0);
	=  (editor`, io`);
	where {
	(editor`,io`)			=: WindowGotoLine linenr LinesLeft front editor2 io3;
	editor2					=: ChangeFrontWindow 
								    [ EW_SetCurLine ([],line,linenr,0),
								      EW_SetCursorPos curpos,
								      EW_SetSelection EmptySelection ] editor1;
	io3						=: EnableTimer TimerID io2;
	io2						=: DrawInActiveWindow [DrawCursor curpos (at_new + dt) ld] io1;
	io1						=: EvtUnSelect front io0;
	io0						=: CloseActiveDialog io;
	(editor1,front)		=: GetFrontWindow editor;
	line						=: Text_GetLine linenr (EW_GetText front);
	linenr					=: Between 0 (dec nrlines) lnr;
	cy							=: PictureTop +  hght * linenr ;
	nrlines					=: EW_GetNrLines front;
	curpos					=: (True,LinesLeft,cy,LinesLeft);
	(curlnr,cnr,d1,d2)	=: EW_GetTextPosition front;
	(at_new,dt,ld,hght)		=: EW_GetFontMetrics front;
	lnr						=: dec (StringToInt lnrstr);
	lnrstr					=: GetEditText Lin2ID dinfo;
	};

GotoLineCancel	:: DialogInfo Editor IO -> EdIO;
GotoLineCancel dialog editor io =  (editor, CloseActiveDialog io);

//
//	Device function for the Goto Cursor command
//

GotoCursor :: Editor IO -> EdIO;
GotoCursor editor io
	| cy >= top &&  cy + (at_new + dt)  <= bot && cx > lft && cx < rgt =  (editor1,io1);
	=  (editor`,io`);
	where {
	(editor`,io`)			=: WindowGotoLine linenr cx front editor1 io1;
	(editor1,front)		=: GetFrontWindow editor;
	(visrect,io1)			=: ActiveWindowGetFrame io;
	(at_new,dt,ld,ht)			=: EW_GetFontMetrics front;
	(linenr,cnr,d1,d2)	=: EW_GetTextPosition front;
	(v,cx,cy,ux)			=: EW_GetCursorPos front;
	(lft,top)				=: topl;
	(rgt,bot)				=: botr;
	(topl,botr)				=: visrect;
	};


/*	Aux. function: enables/disables the proper Search menu items */

AbleFindItems	:: String Bool IO -> IO;
AbleFindItems find backw io
	| hasfind && backw =  EnableMenuItems  [IFindNID,IReplaID] io1;
	| hasfind =  EnableMenuItems  [IFindNID,IReplaID] io2;
	| backw =  DisableMenuItems [IFindNID,IReplaID] io1;
	=  DisableMenuItems [IFindNID,IReplaID] io2;
	where {
	io1=: ChangeMenuItemTitles [(IFindNID,"Find Previous")] io;
	io2=: ChangeMenuItemTitles [(IFindNID,"Find Next"    )] io;
	hasfind=: find <> "";
	};

/* Misc. function(s) */

SingletonElement	:: [t] -> t;
SingletonElement [x] =  x;
