definition module EdProgramState;

/*	Access functions on the programstate */

import StdFile, deltaPicture, deltaEventIO;

import EdTypes, EdConstants, EdText, EdTextFind;

               // The IOState
::	* EdIO		:== (Editor, IO);
::	* IO		:==  IOState Editor;

               // The program state
::	* Editor;


     

SelectedCurLine linenr :== ([],[],linenr,0);

	ZeroCursor		:== (False,LinesLeft,PictureTop,LinesLeft);
	EmptyCurLine	:== ([],[],0,0);
	EmptyPathname	:== "";
	EmptySelection	:== ((0,0,0,0),(0,0,0,0));
	EmptyRemoved	:== (False,[],0,0);
	EmptyAdded		:== (0,0,0,0);
	IsSaved			:== True;

    

//	The initial Editor

InitEditor	:: Files -> Editor;

//	A fresh EditWindow

NewEditWindow	:: Defaults Text Pathname NrLines -> EditWindow;

//	Operations on the Disk (FILES)

CloseDisk	:: Editor * World -> * World;
OpenInputFileSelector	:: Editor IO -> (Bool, String, Editor, IO);
OpenOutputFileSelector	:: String Editor IO -> (Bool, String, Editor, IO);
OpenUFile	:: String Int Editor -> (Editor, Bool, UFILE);
CloseUFile	:: UFILE Editor -> Editor;

//	Default values operations

GetDefaults	:: Editor -> (Editor, Defaults);
SetDefaults	:: Defaults Editor -> Editor;

//	Clipboard operations

GetClipboard	:: Editor -> (Editor, Clipboard);
SetClipboard	:: Clipboard Editor -> Editor;

//	FindInfo operations

GetFindInfo	:: Editor -> (Editor, FindInfo);
SetFindInfo	:: FindInfo Editor -> Editor;

FI_GetFind	:: FindInfo -> String;
FI_SetFind	:: String FindInfo -> FindInfo;
FI_GetReplace	:: FindInfo -> String;
FI_SetReplace	:: String FindInfo -> FindInfo;
FI_GetOptions	:: FindInfo -> (Bool,Bool,Bool,Bool);
FI_SetOptions	:: Bool Bool Bool Bool FindInfo -> FindInfo;
	//	ignore case, backwards, wrap around, match words

//	Window id operations

GetNewWdId	:: Editor -> (Editor, EditWdId);
GetUsedWdIds	:: Editor -> (Editor, [EditWdId]);
SetUsedWdId	:: EditWdId Editor -> Editor;

//	EditWindow operations

ChangeFrontWindow	:: [EditWindow -> EditWindow] Editor -> Editor; 
GetFrontWindow	:: Editor -> (Editor, EditWindow);
ResetCurLine_and_GetFrontWindow	:: Editor -> (Editor,EditWindow);
GetWdIdOfFrontWindow	:: Editor -> (Editor, EditWdId);
WindowsPresent	:: Editor -> (Editor, Bool);
SetFrontWindow	:: !EditWindow Editor -> Editor;
RemoveFrontWindow	:: Editor -> Editor;
GetWindow	:: EditWdId Editor -> (Editor, EditWindow);
SetWindow	:: EditWdId EditWindow Editor -> Editor;
AddWindow	:: EditWdId EditWindow Editor -> Editor;
SetWindowInFront	:: EditWdId Editor -> Editor;
GetWindowIndex	:: String Editor -> (Editor, Int);
IsExistingPathname	:: Pathname Editor -> (Editor, Bool, EditWdId);

EW_GetText	:: EditWindow -> Text;
EW_GetCursorPos	:: EditWindow -> CursorPos;
EW_GetCurLine	:: EditWindow -> CurLine;
EW_GetPathname	:: EditWindow -> Pathname;
RemovePath	:: Pathname -> String;
EW_GetSelection	:: EditWindow -> Selection;
IsEmptySelection	:: Selection -> Bool;
EW_GetUndoInfo	:: EditWindow -> UndoInfo;
EW_GetTabWidth	:: EditWindow -> TabWidth;
EW_GetWindowFont	:: EditWindow -> WindowFont;
EW_GetFontMetrics	:: EditWindow -> FontMetr;
EW_GetNrLines	:: EditWindow -> NrLines;
EW_GetTextPosition	:: EditWindow -> PartSel;
EW_GetActivePos	:: EditWindow -> PartSel;
EW_GetPassivePos	:: EditWindow -> PartSel;
EW_Saved	:: EditWindow -> Bool;
EW_AutoIndent	:: EditWindow -> Bool;

EW_SetText	:: Text EditWindow -> EditWindow;
EW_SetCursorPos	:: CursorPos EditWindow -> EditWindow;
EW_ToggleCursor	:: EditWindow -> EditWindow;
EW_SetCursorVisibility	:: Bool EditWindow -> EditWindow;
EW_SetCurLine	:: CurLine EditWindow -> EditWindow;
EW_ResetCurLine	:: EditWindow -> EditWindow;
EW_SetPathname	:: Pathname EditWindow -> EditWindow;
EW_SetSelection	:: Selection EditWindow -> EditWindow;
EW_SetUndoInfo	:: UndoInfo EditWindow -> EditWindow;
EW_SetTabWidth	:: TabWidth EditWindow -> EditWindow;
EW_SetWindowFont	:: WindowFont EditWindow -> EditWindow;
EW_SetFontMetrics	:: FontMetr EditWindow -> EditWindow;
EW_SetNrLines	:: NrLines EditWindow -> EditWindow;
EW_SetSaved	:: Saved EditWindow -> EditWindow;
EW_ToggleAutoIndent	:: EditWindow -> EditWindow;
EW_SetAutoIndent	:: AutoIndent EditWindow -> EditWindow;

//	Miscellaneous functions

Between	:: Int Int Int -> Int;
Reverse	:: [t] -> [t];
Length_new	:: [t] -> Int;
