implementation module EdFileMenu;

/*	The commands of the File menu */

from StdString import +, ==, !!, #, +++;
from StdInt import dec;
from StdBool import not;
import deltaEventIO, deltaMenu, deltaWindow, deltaTimer, deltaDialog;

import EdProgramState, EdWindows, EdFiles, EdDialogs;
from EdSupport import AdjustWindowSize;

     
	OKID		:== 1;
	CancelID	:== 2;

    

//
//	The device function for the New command
//

New :: Editor IO -> EdIO;
New editor io =  	OpenEditWindow wdid editwd name editor` io;
	where {
	(editor`,wdid)	=: GetNewWdId editor1;
	(editor1,defs)	=: GetDefaults editor;
	editwd			=: NewEditWindow defs EmptyText name 1;
	name				=: "Untitled";
	};

//
//	The device function for the Open command
//

Open :: Editor IO -> EdIO;
Open editor io
	| not open =  (editor`, io`);
	| name == HelpFile =  (editor`,HelpFileAlert io`);
	| exists =  SetThisWindow id editora io`;
	| good = 	OpenEditWindow wdid editwd name editorb io`;
	=  (editor1, AlertDialog ["The file \"" +++  name +++ "\"" ,
	                             "could not be opened."] io`); 
	where {
	(editora,exists,id)			=: IsExistingPathname pathname editor`;
	(editor1,text,nrlines,good)=: ReadFile pathname editora;
	(editor2,wdid)					=: GetNewWdId editor1;
	(editorb,defaults)			=: GetDefaults editor2;
	editwd							=: NewEditWindow defaults text pathname nrlines;
	name								=: RemovePath pathname;
	(open,pathname,editor`,io`)=: OpenInputFileSelector editor io;
	};

/*	Auxiliary function for the New and Open commands */

OpenEditWindow	:: EditWdId EditWindow String Editor IO -> EdIO;
OpenEditWindow wdid window name editor io
	=  (editor`, io`);
	where {
	(editor`, io`)		 =: CreateWindow wdid window1 name editor1 io1;
	(editor1, index)   =: GetWindowIndex name editor;
	window1				 =: EW_SetCurLine ([],after,0,0) window;
	io1=: ChangeIOState [ EnableMenus [MEditID, MSearcID],
	                     EnableMenuItems  [ICloseID, ISavesID, IClosaID, ISaveaID],
	                     DisableMenuItems [ICopyID, ICutID, IClearID, IFindSID],
	                     InsertMenuItems IWindoID index [WindowItem wdid name],
	                     EnableTimer TimerID ] io;
	after					 =: Text_GetLine 0 (EW_GetText window);
	};

//
//	The device function for the Close command
//

Close :: Editor IO -> EdIO;
Close editor io =  CloseWindow "closing" wdid editor` io;
	where {
	(editor`,wdid)=: GetWdIdOfFrontWindow editor;
	};

//
//	The device function for the Save command
//

Save :: Editor IO -> EdIO;
Save editor io
	| path == "Untitled" =  SaveAs editor1 io;
	| good =  (editor`, io`);
	=  let! {
		strict1;
		} in
		(editor`, AlertDialog ["The file could not be saved because",
	                          "of a file I/O error."] io`);
	where {
	(editor1,front)=: ResetCurLine_and_GetFrontWindow editor;
	path				=: EW_GetPathname front;
	editor2			=: ChangeFrontWindow [EW_SetSaved True] editor1;
	(editor`,good)	=: strict1;
	text				=: EW_GetText front;
	io`				=: DisableMenuItems [ISaveID, IReverID] io;
	strict1=SaveFile path text editor2;
		};

//
//	The device function for the Save As command
//

SaveAs :: Editor IO -> EdIO;
SaveAs editor io
	| not save =  (editor2, io1);
	| name == HelpFile =  (editor2,HelpFileAlert io1);
	| good =  (editor5, io2);
	=  (editor4, AlertDialog ["The file could not be saved because",
	                          "of a file I/O error."] io1);
	where {
	editor5					  =: ChangeFrontWindow [EW_SetSaved True,
						 		                       EW_SetPathname path] editor4;
	(editor4,good)			  =: SaveFile path text editor3;
	(editor3,front)		  =: ResetCurLine_and_GetFrontWindow editor2;
	(save,path,editor2,io1)=: OpenOutputFileSelector (RemovePath oldpath) editor1 io;
	(editor1,oldfr)		  =: GetFrontWindow editor0;
	(editor0,wdid)         =: GetWdIdOfFrontWindow editor;
	oldpath					  =: EW_GetPathname oldfr;
	text						  =: EW_GetText front;
	io2						  =: ChangeIOState [ DisableMenuItems [ISaveID, IReverID],
								                    ChangeWindowTitle wdid name ] io1;
	name						  =: RemovePath path;
	};

//
//	The device function for the Revert command
//

Revert :: Editor IO -> EdIO;
Revert editor io
	| butid == CancelID =  (editor,io0);
	| good =  DrawVisibleLines front editor` io`;
	=  let! {
		editor2;
		path;
		} in
		(editor3, AlertDialog ["The file \"" +++  name +++ "\"" ,
	                             "could not be opened."] io0);
	where {
	(butid,io0)		=: OpenNotice notice io;
	notice			=: Notice [line1,line2] (NoticeButton OKID "Revert")
						                       [NoticeButton CancelID "Cancel"];
	line1				=: "Revert to the last saved version of the document?";
	line2				=: "Changes made since the last save will be lost.";
	(editor`,io`)	=: AdjustWindowSize nrlines front editor5 io1;
	(editor5,front)=: GetFrontWindow editor4;
	editor4	=: ChangeFrontWindow [ EW_SetUndoInfo (EmptyRemoved,EmptyAdded),
											 EW_SetText text,
				                      EW_SetNrLines nrlines,
				                      EW_SetSaved True,
				                      EW_SetSelection EmptySelection,
									       EW_SetCurLine ([],after,0,0),
				            	       EW_SetCursorPos ZeroCursor ] editor3;
	(editor3,text,nrlines,good)=: ReadFile path editor2;
	editor2			=: SetFrontWindow oldfr editor1;
	oldfr				=: EW_SetText EmptyText oldf;
	(editor1,oldf)	=: GetFrontWindow editor;
	io1				=: DisableMenuItems [ISaveID, IReverID, ICutID,
						                    ICopyID, IClearID, IFindSID] io0;
	path				=: EW_GetPathname oldfr;
	after				=: Text_GetLine 0 text;
	name				=: RemovePath path;
	};

//
//	The device function for the Quit command
//

Quit :: Editor IO -> EdIO;
Quit editor io =  DoQuit (-1) editor (CloseWindows [HelpWdID] io);

DoQuit	:: EditWdId Editor IO -> EdIO;
DoQuit id editor io
	| not windows =  (editor, QuitIO io1);
	| id == wdid =  (editor, io1);
	=  DoQuit wdid editor` io`;
	where {
	(windows,wdid,io1)=: GetActiveWindow io;
	(editor`,io`)		=: CloseWindow "quitting" wdid editor io1;
	};
