implementation module EdDialogs;

import StdInt, StdString;
import deltaIOSystem, deltaDialog;

import EdProgramState;

    

//
//	When the Help file is selected the following alert will be shown:
//

HelpFileAlert	:: IO -> IO;
HelpFileAlert io 
	=  AlertDialog ["The Help file \"" +++  HelpFile +++ "\"" ,
			          "cannot be opened."] io;

AlertDialog	:: [String] IO -> IO;
AlertDialog mes io =  io`;
	where {
	(id,io`)=: OpenNotice (Notice mes (NoticeButton 1 "OK") []) io;
	};

/* Miscellaneous functions */

StringToInt	:: String -> Int;
StringToInt string =  TextToNumber string 0;

TextToNumber	:: String Int -> Int;
TextToNumber "" n =  n;
TextToNumber s	 n | isdigit =  number;
	                  =  n;
	where {
	number	  =: TextToNumber (s % (1, dec (# s))) ( 10 * n  + d);
	(isdigit,d)=: Digit (s !! 0);
	};

Digit	:: Char -> (Bool, Int);
Digit '0'  =  (True, 0); 	  Digit '1' =  (True, 1);
Digit '2'  =  (True, 2); 	  Digit '3' =  (True, 3);
Digit '4'  =  (True, 4); 	  Digit '5' =  (True, 5);
Digit '6'  =  (True, 6); 	  Digit '7' =  (True, 7);
Digit '8'  =  (True, 8);	  Digit '9' =  (True, 9);
Digit c	  =  (False,0);
