definition module ioState

import ostypes
import deltaIOSystem
import dialogDef

       

:: * IOState * s
:: * EVENTS

:: DeviceSystemState * s =  TimerSystemState    (TimerHandles s (IOState s))
                           |  WindowSystemState (WindowHandles s) 
                           |  MenuSystemState   (MenuHandles   s (IOState s))
                           |  DialogSystemState (DialogHandles s (IOState s))

// The timer handles.

:: TimerHandles * s * io :== [TimerHandle s io]
:: TimerHandle * s * io  :== (!TimerPtr, TimerId, !TimerInterval, TimerFunction s io)

// The window handles.

:: WindowHandles * s :== [WindowHandle s]
:: WindowHandle  * s :== (!WindowDef s (IOState s), !Window)
:: Window           :== (!WindowPtr, PicturePtr, ScrollState, ScrollState, !CursorPtr, !Offset)
:: ScrollState      = {	scroll_ptr	:: !ControlPtr,
					    scroll_line	:: !Int,
					    scroll_page	:: !Int,
					    scroll_min	:: !Int,
					    scroll_max	:: !Int,
					    scroll_div	:: !Int
					  }
:: Offset           :== (!Int, !Int)


// The menu handles

:: MenuHandles * s * io    :== [MenuHandle s io]
:: MenuHandle  * s * io
        =  PullDownHandle MenuPtr MenuId MenuId MenuTitle SelectState [MenuItemHandle s io]
:: MenuItemHandle * s * io
        =  ItemHandle        MenuPtr MenuItemId MenuItemId ItemTitle KeyShortcut SelectState (MenuFunction s io)
        |  CheckItemHandle   MenuPtr MenuItemId MenuItemId ItemTitle KeyShortcut SelectState MarkState (MenuFunction s io)
        |  SubItemHandle     MenuPtr MenuItemId MenuId ItemTitle SelectState [MenuItemHandle  s io]
        |  ItemGroupHandle   MenuPtr MenuItemGroupId [MenuItemHandle  s io]
        |  RadioItemsHandle  MenuItemId MenuItemId [MenuItemHandle s io]
        |  SeparatorHandle   MenuPtr MenuItemId

// The dialog handles

:: DialogHandles * s * io   :== [DialogHandle s io]

/* this part is special for OS2 */

:: CurrentMenuSystem * s    =  NoCurMenu
                            |  CurMenu (MenuHandles s (IOState s)) [ShortCut] SelectState Int

:: AboutDialogDef * s = NoAbout
                      | About (DialogDef s (IOState s))

:: ShortCut =  ShortCutHandle ShortCutPtr MenuItemId MenuItemId Char SelectState
            |  SubShortCuts MenuItemId MenuItemId SelectState [ShortCut]

/* end of OS2 part */

:: Device =  TimerDevice | MenuDevice | WindowDevice | DialogDevice

:: DeviceFunctions * s :== (!ShowFunction  s,
                             !OpenFunction  s,
                             !DoIOFunction  s,
                             !CloseFunction s,
                             !HideFunction  s)

:: ShowFunction * s :== (IOState s) ->  IOState s 
:: HideFunction * s :== (IOState s) ->  IOState s 
:: OpenFunction * s :== (DeviceSystem s (IOState s)) -> *( (IOState s) ->  IOState s ) 
:: DoIOFunction  * s :== Event -> *( s ->  *((IOState s) -> (Bool, s, IOState s)))  
:: CloseFunction * s :== (IOState s) ->  IOState s 

    

OpenEvents :: !* World -> (!EVENTS, !* World)
CloseEvents :: !EVENTS !* World -> * World
NewIOStateFromOld :: !(IOState s) -> (!IOState t, !IOState s)
EmptyIOState :: !EVENTS -> IOState s
OldIOStateFromNew :: !(IOState s) !(IOState t) -> IOState s
IOStateEvents :: !(IOState s) -> EVENTS
IOStateClosed ::       !(IOState s) -> (!Bool, !IOState s)
IOStateGetAnyDevice :: !(IOState s) -> (!DeviceSystemState s, !IOState s)
IOStateSetDevice ::    !(IOState s) !(DeviceSystemState s) -> IOState s
IOStateHasDevice ::    !(IOState s) !Device -> (!Bool, !IOState s)
IOStateGetDevice ::    !(IOState s) !Device -> (!DeviceSystemState s, !IOState s)
IOStateRemoveDevice :: !(IOState s) !Device -> IOState s
IOStateGetCurrentMenu :: !(IOState s) -> (!CurrentMenuSystem s, ! IOState s)
IOStateSetCurrentMenu :: (CurrentMenuSystem s) !(IOState s) -> IOState s

IOStateSetAbout:: (AboutDialogDef s) !(IOState s) -> IOState s
IOStateGetAbout:: !(IOState s) -> (!AboutDialogDef s, ! IOState s)

// Access-rules on DeviceSystemStates:

DeviceSystemStateToDevice :: !(DeviceSystemState s) -> Device
Priority :: !Device -> Int

