implementation module deltaSystem

import StdReal, StdInt

import oskernel, ostypes

		 

UpKey           :== OSUpKey    // Arrow up
DownKey         :== OSDownKey  // Arrow down
LeftKey         :== OSLeftKey  // Arrow left
RightKey        :== OSRightKey // Arrow right
PgUpKey         :== OSPgUpKey  // Page up
PgDownKey       :== OSPgDownKey// Page down
BeginKey        :== OSBeginKey // Begin of text
EndKey          :== OSEndKey   // End of text
BackSpKey       :== OSBackSpKey// Backspace
DelKey          :== OSDelKey   // Delete
TabKey          :== OSTabKey   // Tab
ReturnKey       :== OSReturnKey// Return
EnterKey        :== OSEnterKey // Enter
EscapeKey       :== OSEscapeKey// Escape
HelpKey         :== OSHelpKey  // Help

DirSeparator    :== '\\'       // Separator between folder-
							   // and filenames in a pathname

ShiftOnly       :== (True,False,False,False)
OptionOnly      :== (False,True,False,False)
CommandOnly     :== (False,False,True,False)
ControlOnly     :== (False,False,False,True)

MMPerInch       :== 25.4

		

HomePath :: !String -> String
HomePath fname = fname

ApplicationPath :: !String -> String
ApplicationPath fname = fname

MMToHorPixels   :: !Real -> Int
MMToHorPixels mm        = toInt (mm * ((toReal hor)  / 1000.0))
		  where 
		  (hor,_)=: OSScreenResolution 0
														   

MMToVerPixels   :: !Real -> Int
MMToVerPixels mm        = toInt (mm *  ((toReal ver) / 1000.0))
		  where 
		  (_,ver)=: OSScreenResolution 0
														   

InchToHorPixels :: !Real -> Int
InchToHorPixels inch = MMToHorPixels (inch * MMPerInch)

InchToVerPixels :: !Real -> Int
InchToVerPixels inch = MMToHorPixels (inch * MMPerInch)

