implementation module dialogAccess

/* Access functions on dialoghandles and the dialogdevice */

import StdEnv, dialogDef, ioState, ostypes
from oswindow import OSWinActivateDialog

/*  Access functions on the dialog device */
IOStateGetDialogs:: !(IOState s) -> (!DialogHandles s (IOState s), !IOState s)
IOStateGetDialogs io
	| has_dialogs
		= (DialogsFromDevice dialogdev, io``)
		= ([],io`)
		  where 
		  (dialogdev,io``)  = IOStateGetDevice io` DialogDevice
		  (has_dialogs,io`) = IOStateHasDevice io  DialogDevice
		

DialogsFromDevice:: !(DeviceSystemState s) -> DialogHandles s (IOState s)
DialogsFromDevice (DialogSystemState dialogs) = dialogs

IOStateSetDialogs:: !(DialogHandles s (IOState s)) !(IOState s) -> IOState s
IOStateSetDialogs dialogs io = IOStateSetDevice io (DialogSystemState dialogs)

IOStateGetActiveDialogInfo:: !(IOState s) -> (!Bool, !DialogInfo, !IOState s)
IOStateGetActiveDialogInfo io
		= (found, DialogHandleToDialogInfo dialog, io`)
		  where 
		  (found,dialog) = GetActiveDialog dialogs
		  (dialogs,io`)  = IOStateGetDialogs io
		  

DialogHandleToDialogInfo:: !(DialogHandle s io) -> DialogInfo
DialogHandleToDialogInfo (id,modal,wptr,info,funs,osids)
		= ItemInfoToDialogInfo info osids

GetActiveDialog:: !(DialogHandles s io) -> (!Bool, !DialogHandle s io)
GetActiveDialog [dialog : rest] = (True,  dialog)
GetActiveDialog no_dialogs      = (False, DummyDialogHandle)

IOStateRemoveActiveDialog:: !(IOState s) -> (!Bool, !DialogHandle s (IOState s), !IOState s)
IOStateRemoveActiveDialog io
		= (found, drep, IOStateSetDialogs dialogs` io`)
		  where 
		  (found,drep,dialogs`) = RemoveActiveDialog dialogs
		  (dialogs,io`)         = IOStateGetDialogs io
		  
		
RemoveActiveDialog:: !(DialogHandles s io) -> (!Bool, !DialogHandle s io, !DialogHandles s io)
RemoveActiveDialog [drep:rest] = (True,drep,rest)
RemoveActiveDialog no_dialogs  = (False,DummyDialogHandle,no_dialogs)

IOStateRemoveActiveDialogPtr:: !DialogPtr !(IOState s) -> (!Bool,!DialogHandle s (IOState s),!IOState s)
IOStateRemoveActiveDialogPtr dptr io
		= (found, drep, IOStateSetDialogs dialogs` io`)
		  where 
		  (found,drep,dialogs`) = RemoveActiveDialogPtr dptr dialogs
		  (dialogs,io`)         = IOStateGetDialogs io
		  
		
RemoveActiveDialogPtr:: !DialogPtr !(DialogHandles s io) -> (!Bool, !DialogHandle s io, !DialogHandles s io)
RemoveActiveDialogPtr dptr [drep=:(dialog,mode,ptr,info,funs,osids) : rest]
	| dptr == ptr
		= (True, drep, rest)
RemoveActiveDialogPtr dptr dialogs
		= (False, DummyDialogHandle, dialogs)

IOStateAddDialog:: !(DialogHandle s (IOState s)) !(IOState s) -> IOState s
IOStateAddDialog drep io
		= IOStateSetDialogs [drep:dialogs] io`
		  where 
		  (dialogs,io`) = IOStateGetDialogs io
		  

IOStateAddInactiveDialog:: !(DialogHandle s (IOState s)) !(IOState s) -> IOState s
IOStateAddInactiveDialog drep io
		= IOStateSetDialogs (AddInactiveDialog drep dialogs) io`
		  where 
		  (dialogs,io`)=: IOStateGetDialogs io
		  

AddInactiveDialog:: !(DialogHandle s io) !(DialogHandles s io) -> DialogHandles s io
AddInactiveDialog drep [dialog : rest] = [dialog,drep : rest]
AddInactiveDialog drep no_dialog       = [drep]

IOStateGetDialog:: !DialogId !(IOState s) -> (!Bool, !DialogHandle s (IOState s), !IOState s)
IOStateGetDialog did io
		= (found, drep, io`)
		  where 
		  (found, drep) = GetDialog did dialogs
		  (dialogs,io`) = IOStateGetDialogs io
		  
		
GetDialog:: !DialogId !(DialogHandles s io) -> (!Bool, !DialogHandle s io)
GetDialog did [drep : rest]
	| did == GetDialogHandleId drep
		= (True, drep)
		= GetDialog did rest
GetDialog did no_dialogs
		= (False, DummyDialogHandle)

IOStateGetDialogInfo:: !DialogId !(IOState s) -> (!Bool, !DialogInfo, !IOState s)
IOStateGetDialogInfo did io
		= (found, DialogHandleToDialogInfo dialog, io`)
		  where 
		  (found,dialog,io`) = IOStateGetDialog did io
		  

IOStateGetDialogPtr:: !DialogPtr !(IOState s) -> (!Bool, !DialogHandle s (IOState s), !IOState s)
IOStateGetDialogPtr dptr io
		= (found, drep, io`)
		  where 
		  (found,drep)  = GetDialogPtr dptr dialogs
		  (dialogs,io`) = IOStateGetDialogs io
		  

GetDialogPtr:: !DialogPtr !(DialogHandles s io) -> (!Bool, !DialogHandle s io)
GetDialogPtr dptr [drep=:(dialog,mode,ptr,info,funs,osids) : rest]
	| dptr == ptr
		= (True, drep)
		= GetDialogPtr dptr rest
GetDialogPtr dptr no_dialogs
		= (False, DummyDialogHandle)

IOStateRemoveDialog:: !DialogId !(IOState s) -> (!Bool, !DialogHandle s (IOState s), !IOState s)
IOStateRemoveDialog did io
		= (found, drep, IOStateSetDialogs dialogs` io`)
		  where 
		  (found,drep,dialogs`) = RemoveDialog did dialogs
		  (dialogs,io`)         = IOStateGetDialogs io
		  
		
RemoveDialog:: !DialogId !(DialogHandles s io) -> (!Bool, !DialogHandle s io, !DialogHandles s io)
RemoveDialog did [drep : rest]
	| did == GetDialogHandleId drep
		= (True, drep, rest)
		= (found, drep`, [drep : rest`])
		  where 
		  (found,drep`,rest`) = RemoveDialog did rest
		
RemoveDialog did no_dialogs 
		= (False, DummyDialogHandle, [])

IOStateRemoveDialogPtr:: !DialogPtr !(IOState s) -> (!Bool, !DialogHandle s (IOState s), !IOState s)
IOStateRemoveDialogPtr dptr io
		= (found, drep, IOStateSetDialogs dialogs` io`)
		  where 
		  (found,drep,dialogs`) = RemoveDialogPtr dptr dialogs
		  (dialogs,io`)         = IOStateGetDialogs io
		  
		
RemoveDialogPtr:: !DialogPtr !(DialogHandles s io) -> (!Bool, !DialogHandle s io, !DialogHandles s io)
RemoveDialogPtr dptr [drep=:(dialog,mode,ptr,info,funs,osids) : rest]
	| dptr == ptr
		= (True, drep, rest)
		= (found, drep`, [drep : rest`])
		  where 
		  (found,drep`,rest`) = RemoveDialogPtr dptr rest
		
RemoveDialogPtr dptr no_dialogs
		= (False,DummyDialogHandle,[])

IOStateReplaceDialog:: !DialogId !(DialogHandle s (IOState s)) !(IOState s) -> IOState s
IOStateReplaceDialog did drep io
		= IOStateSetDialogs (ReplaceDialog did drep dialogs) io`
		  where 
		  (dialogs,io`) = IOStateGetDialogs io
		  

ReplaceDialog:: !DialogId !(DialogHandle s io) !(DialogHandles s io) -> DialogHandles s io
ReplaceDialog did drep [oldrep : rest]
	| did == GetDialogHandleId oldrep
		= [drep : rest]
		= [oldrep : ReplaceDialog did drep rest]
ReplaceDialog did drep no_dialogs
		= abort "Error in ReplaceDialog [dialogAccess]: Unknown dialog id."

IOStateSetDialogInFront:: !DialogId !(IOState s) -> (!Bool, !IOState s)
IOStateSetDialogInFront did io
		= (found, IOStateSetDialogs dialogs` io`)
		  where 
		  (found,dialogs`) = SetDialogInFront did dialogs
		  (dialogs,io`)    = IOStateGetDialogs io
		  

SetDialogInFront:: !DialogId !(DialogHandles s io) -> (!Bool, !DialogHandles s io)
SetDialogInFront did dialogs
	| not found || ptr == DummyPtr
		= (False, dialogs)
		= let! 
			ptr2
		  in (True, [drep2 : dialogs`])
		  where 
		  drep2                             = (dialog,mode,ptr2,info,funs,osids)
		  ptr2                              = OSWinActivateDialog ptr
		  (dialog,mode,ptr,info,funs,osids) = drep
		  (found,drep,dialogs`)             = RemoveDialog did dialogs
		

IOStateModalDialogClosed:: !(IOState s) -> (!Bool,!IOState s)
IOStateModalDialogClosed io
		= (closed, IOStateSetDialogs dialogs` io`)
		  where 
		  (closed,dialogs`) = ModalDialogIsClosed dialogs
		  (dialogs,io`)     = IOStateGetDialogs io
		  

ModalDialogIsClosed:: !(DialogHandles s io) -> (!Bool, !DialogHandles s io)
ModalDialogIsClosed [(id, True, ptr, info,funs,osids) : rest]
	| ptr == DummyPtr
		= (True, rest)
ModalDialogIsClosed dialogs
		= (False, dialogs)

IOStateModalDialogActive:: !(IOState s) -> (!Bool,!IOState s)
IOStateModalDialogActive io
		= (ModalDialogActive dialogs, io`)
		  where 
		  (dialogs,io`) = IOStateGetDialogs io
		  

ModalDialogActive:: !(DialogHandles s io) -> Bool
ModalDialogActive [(id, modal, ptr, info,funs,osids) : rest]
		= modal
ModalDialogActive dialogs
		= False