definition module deltaSystem

import ostypes

//  Version 0.8.3b

//
//  Operating System dependent constants and functions. 
//


     

/*  Keyboard constants */

UpKey           :== OSUpKey        // Arrow up
DownKey         :== OSDownKey  // Arrow down
LeftKey         :== OSLeftKey  // Arrow left
RightKey        :== OSRightKey // Arrow right
PgUpKey         :== OSPgUpKey  // Page up
PgDownKey       :== OSPgDownKey    // Page down
BeginKey        :== OSBeginKey // Begin of text
EndKey          :== OSEndKey   // End of text
BackSpKey       :== OSBackSpKey    // Backspace
DelKey          :== OSDelKey   // Delete
TabKey          :== OSTabKey   // Tab
ReturnKey       :== OSReturnKey    // Return
EnterKey        :== OSEnterKey 		// Enter
EscapeKey       :== OSEscapeKey		// Escape
HelpKey         :== OSHelpKey  		// Help

/*  File constants */

DirSeparator    :== '\\'       // Separator between folder- and
                                    // filenames in a pathname

/*  Constants to check which of the Modifiers is down. */

ShiftOnly       :== (True,False,False,False)
OptionOnly      :== (False,True,False,False)
CommandOnly     :== (False,False,True,False)
ControlOnly     :== (False,False,False,True)

    

/* The functions HomePath and ApplicationPath prefix the
   filename given to them with the full pathnames of the 'home'
   and 'application' directory.
   These functions have been added for compatibility with the
   Sun version of the Clean system. In the 'home' directory
   settings-files (containing preferences, options etc.) should
   be stored. In the 'application' directory (i.e. the
   directory in which the application resides) files that are
   used read-only by the application (such as help files) should
   be stored.
   On the Macintosh these functions just return the filename
   given to them, which means that the file will be stored in
   the same folder as the application.
*/

HomePath :: !String -> String
ApplicationPath :: !String -> String

/*  Screen resolution functions. */

MMToHorPixels   :: !Real -> Int
MMToVerPixels   :: !Real -> Int
InchToHorPixels :: !Real -> Int
InchToVerPixels :: !Real -> Int

/*  Maximum ranges of window PictureDomains:
        MaxScrollWindowSize yields the range at which scrollbars
            are inactive.
        MaxFixedWindowSize yields the range at which the window
            does not change into a ScrollWindow.

::  MaxScrollWindowSize -> (!INT, !INT)
::  MaxFixedWindowSize  -> (!INT, !INT) */

from windowDevice import MaxScrollWindowSize, MaxFixedWindowSize



