definition module deltaIOState

//	Version 0.8.3b

//
//	Operations on the IOState that have a global effect.
//


import deltaIOSystem, ioState

    

/*	Operations on the global cursor:
*/

SetGlobalCursor	:: !CursorShape !(IOState s) -> IOState s
/*	Set the shape of the cursor globally. This shape overrules the local cursor
	shapes of windows. */

ResetCursor	:: !(IOState s) -> IOState s
/*	Undoes the effect of SetGlobalCursor. */

ObscureCursor	:: !(IOState s) -> IOState s
/*	ObscureCursor hides the cursor until the mouse is moved. */


/*	Operations on the double down distance:
*/

SetDoubleDownDistance	:: !Int !(IOState s) -> IOState s
/*	Set the maximum distance the mouse is allowed to move to generate a
	ButtonDouble(Triple)Down button state. Negative values are set to zero. */

