implementation module StdString

// ****************************************************************************************
//	Concurrent Clean Standard Library Module Version 1.0
//	Copyright 1994 University of Nijmegen
// ****************************************************************************************

import	StdOverloaded, StdBool, StdReal, StdInt, StdChar

instance == String
(==) :: !String !String -> Bool
(==) a b
	= code {
		.inline ==+s
			cmpS 0 1
			pushI 0
			eqI
			pop_a 2
		.end
	}


instance < String
(<) :: !String !String -> Bool
(<) a b
	= code {
		.inline <+s
			pushI	0
			cmpS 0 1
			pop_a 2
			ltI
		.end
	}

instance toString String
toString :: !String -> String //	dummy
toString a
	= code {
		.inline toString+s
			no_op
		.end
	}

instance toInt String
toInt::!String -> Int
toInt s
	| len==0
		=	0
	| neg
		=	~signedval
	| pos
		=	signedval
	// otherwise
		=	other
where
	len	=	#s
	neg	=	s!!0 == '-'
	pos	=	s!!0 == '+'

	signedval
			=	toInt2 1 0 s
	other
			=	toInt2 0 0 s

	toInt2:: !Int !Int !String -> Int
	toInt2 posn val s
		|	len==posn		=	val
		|	isdigit			=	toInt2 (posn+1) (n+val*10) s
		//	otherwise
							=	0
	where
		n 		=	toInt (s!!posn) - toInt '0'
		isdigit	=	0<=n && n<= 9

instance toReal String
toReal::!String -> Real
toReal s
	|	len == 0
			=	0.0
	|	first  == '-'
			= 	~ signedval
	|	first  == '+'
			=	signedval
	//	otherwise
			= 	val
where
	len
		=	#s
	signedval
		= 	toReal2 s 1 0.0 False 1.0 False 0 0
	val
		=	toReal2 s 0 0.0 False 1.0 False 0 0
	first
		=	s!!0

	toReal2 s posn val dec_new dval exp eneg eval
		| posn == len
			= 	val*dval*10.0 ^  toReal (eneg*eval)
		| digit && not dec_new && not exp
			= 	toReal2 s (posn+1) (toReal n + 10.0*val) dec_new dval exp eneg eval
		| digit && dec_new && not exp
			= 	toReal2 s (posn+1) (toReal n + 10.0*val) dec_new (dval*0.1) exp eneg eval
		| digit && exp
			= 	toReal2 s (posn+1) val dec_new dval exp eneg (n + 10*eval )
		| not dec_new && not exp && c == '.'
			= 	toReal2 s (posn+1) val True 1.0 exp eneg eval
		| not exp && c=='e' && len>2+posn && s!!(posn+1) == '-'
			= 	toReal2 s (posn+2) val dec_new dval True (-1) 0
		| not exp && c=='e' && len>posn+1
			= 	toReal2 s (posn+1) val dec_new dval True 1 0 
		// otherwise
			= 	0.0
		where
			c		=	s!!posn
			n		=	toInt c  -  toInt '0' 
			digit	=	0<=n  &&  n<=9 

instance fromString String
fromString :: !String -> String //	dummy
fromString a
	= code {
		.inline fromString+s
			no_op
		.end
	}

instance # String
# :: !String -> Int
# a
	= code {
		.inline #+s
			lenS 0
			pop_a 1
		.end
	}

instance ## String
## :: !String -> Int
## a
	= code {
		.inline ##+s
			lenS 0
			decI
			pop_a 1
		.end
	}

instance % String
(%) ::!String !(!Int,!Int) -> String
(%) str (a,b)
	= slice str a b
	where
		slice :: !String !Int !Int -> String
		slice a b c
			= code {
				.inline slice
					sliceS 0 1
					pop_a 1
				.end
			}

instance +++ String
(+++) :: !String !String -> String
(+++) a b
	= code {
		.inline ++++s
			catS 0 1 2
			pop_a 2
		.end
	}

(!!) infixl 9 :: !String !Int  -> Char
(!!)  a b
	= code {
		.inline !!
			indexS	0
			pop_a 1
		.end
	}

(:=) infixl 9 :: !String !(!Int,!Char) -> String
(:=) s (i,c)
	= update s c i
	where
		update :: !String !Char !Int -> String; // replace arg3th char in arg1 with arg2
		update a b c
			= code {
				updateS 0 1
				pop_a 1
			.end
		}

// utilities

(>)  infix  2
(>) x y	 :== y < x 
(<=) infix  2
(<=) x y :== not (y<x)
(>=) infix  2
(>=) x y :== not (x<y) 


InlineDummy
	=	code
		{
			.inline toReal+s
			.end
			.inline toInt+s
			.end
			.inline %+s
			.end
			.inline :=
			.end
		}
