definition module StdList

//	****************************************************************************************
//	Concurrent Clean Standard Library Module Version 1.0
//	Copyright 1995 University of Nijmegen
//	****************************************************************************************


from StdClass import Eq, Ord, ToChar, FromChar, ToString, FromString, #, ##,  %

//	Instances of overloaded functions:

instance == 	[a] | Eq a

instance <		[a] | Ord a

instance #		[a]
instance ##		[a]
instance %		[a]

instance toString 	[x] | ToChar x	 // Convert [x]    via [Char] into String
instance fromString [x] | FromChar x // Convert String via [Char] into [x]

//	List Operators:

(!) 	infixl 9	:: ![.a] Int -> .a				//	Get nth element of the list
(++)	infixr 0	:: ![.a] u:[.a] -> u:[.a]		//	Append args
flatten				:: ![.[a]] -> [a]				//	e0 ++ e1 ++ ... ++ e##
isEmpty				:: ![.a] -> Bool				//	[] ?

//	List breaking or permuting functions:

hd			:: ![.a] -> .a							//	Head of the list
tl			:: !u:[.a] -> u:[.a]					//	Tail of the list
last		:: ![.a] -> .a							//	Last element of the list
take		:: !Int [.a] -> [.a]					//	Take first arg1 elements of the list
takeWhile	:: (a -> .Bool) !.[a] -> .[a]			//	Take elements while pred holds
drop		:: Int !u:[.a] -> u:[.a]				//	Drop first arg1 elements from the list
dropWhile	:: (a -> .Bool) !u:[a] -> u:[a]			//	Drop elements while pred holds
filter		:: (a -> .Bool) !.[a] -> .[a]			//	Drop all elements not satisfying pred
insert 		:: (a a -> .Bool) a !u:[a] -> u:[a]		//	Insert arg2 when pred arg2 elem holds   
remove		:: !Int !u:[.a] -> u:[.a]				//	Remove arg2!arg1 from list
reverse		:: !.[a] -> [a]							//	Reverse the list
span		:: (a -> .Bool) !u:[a] -> (.[a],u:[a])	//	(takeWhile list,dropWhile list)
splitAt		 :: !Int u:[.a] -> ([.a],u:[.a])		//	(take n list,drop n list)

//	Creating lists:

map			:: (.a -> .b) ![.a] -> [.b]				//	[f e0,f e1,f e2,...
iterate		:: (a -> a) a -> .[a]					//	[a,f a,f (f a),...
indexList	:: !.[a] -> [Int]						//	[0..##list]
repeatn		:: !.Int a -> .[a]						//	[e0,e0,...,e0] of length n
repeat		:: a -> [a]								//	[e0,e0,...
unzip		::	![(a,b)] 		-> ([a],[b])		//	([a0,a1,...],[b0,b1,...])
zip2		:: ![.a] [.b] 		-> [(.a,.b)]		//	[(a0,b0),(a1,b1),...
zip			:: !(![.a],[.b]) 	-> [(.a,.b)]		//	[(a0,b0),(a1,b1),...
diag2		:: !.[a] .[b]		-> [.(a,b)]			//	[(a0,b0),(a1,b0),(a0,b1),...
diag3		:: !.[a] .[b] .[c]	-> [.(a,b,c)]		//	[(a0,b0,c0),(a1,b0,c0),...

//	Folding and scanning:

foldl		:: (.a -> .(.b -> .a)) .a ![.b] -> .a	//	op(...(op (op (op r e0) e1)...e##)
foldr		:: (.a -> .(.b -> .b)) .b ![.a] -> .b	//	op e0 (op e1(...(op r e##)...)
scan		::  (a -> .(.b -> a)) a ![.b] -> .[a]	//	[r,op r e0,op (op r e0) e1,...

//	On Booleans

and			:: ![.Bool] -> Bool						//	e0 && e1 ... && e##
or			:: ![.Bool] -> Bool						//	e0 || e1 ... || e##
any			:: (.a -> .Bool) ![.a] -> Bool			//	True, if ei is True for some i
all			:: (.a -> .Bool) ![.a] -> Bool			//	True, if ei is True for all i
