implementation module StdFunc

// ****************************************************************************************
//	Concurrent Clean Standard Library Module Version 1.0
//	Copyright 1995 University of Nijmegen
// ****************************************************************************************

// Some Classical Functions

import StdClass, StdMisc

I::!.a -> .a
I x = x

K::!.a .b -> .a
K x y = x

S::!.(a -> .(.b -> .(a -> .c))) .b a -> .c
S x y z = (x z) y z

flip::!.(.a -> .(.b -> .c)) .b .a -> .c
flip f a b = f b a

(o) infixr	9:: u:(.a -> .b) u:(.c -> .a) -> u:(.c -> .b)
(o) f g = composition
	where composition x = f (g x)
	
seq :: ![.(.s -> .s)] .s -> .s
seq [f:fs] arg	=	seq fs (f arg)
seq [] arg		=	arg

//	for people who like state manipulation with monads

::St s a :== s -> (a,s)

seqList::![St .s .a] .s -> ([.a],.s)
seqList [f:fs] io = ([a:as],iol)
where
	(as,iol) = seqList fs io1 
	(a,io1)  = f io
seqList [] io = ([],io)

(`bind`) infix 0 :: u:(St .s .a) u:(.a -> .(St .s .b)) -> u:(St .s .b);
(`bind`) f_sta a_fstb = stb
where 
	stb st = a_fstb a nst
	where 
		(a,nst)	=	f_sta st	

return::u:a -> u:(St .s u:a)
return x = \s -> (x,s)

//	end of monads

twice :: !(.a -> .a) .a -> .a
twice f x = f (f x)

until::!(a -> .Bool) (a -> a) a -> a
until p f x	| p x 	= x
					= until p f (f x)

while :: !(a -> .Bool) (a -> a) a -> a
while p f x	
	| p x	= 	while p f (f x)
			= 	x

iter :: !Int (.a -> .a) .a -> .a
iter 0 f x	= 	x
iter n f x
	| n > 0	= 	iter (n-1) f (f x)
			= 	abort "Error: Negative index given to iter."

