system module StdChar

// ****************************************************************************************
//	Concurrent Clean Standard Library Module Version 1.0
//	Copyright 1995 University of Nijmegen
// ****************************************************************************************

import	StdOverloaded

instance ==				Char

instance <  			Char

instance toInt			Char
instance toChar			Char
instance toString		Char

instance fromChar		Int
instance fromChar		Char
instance fromChar		String

//	Additional conversions:

digtoChar		:: !Char -> Int				//	Convert Digit into Int
toUpper			:: !Char -> Char			//	Convert Char into an uppercase Char
toLower			:: !Char -> Char			//	Convert Char into a  lowercase Char

//	Tests on Characters:

isAscii				:: !Char -> Bool			//	True if arg1 is an ASCII character
isControl			:: !Char -> Bool			//	True if arg1 is a  control character
isPrint				:: !Char -> Bool			//	True if arg1 is a  printable character
isSpace				:: !Char -> Bool			//	True if arg1 is a  space, tab etc
isUpper				:: !Char -> Bool			//	True if arg1 is an uppercase character
isLower				:: !Char -> Bool			//	True if arg1 is a  lowercase character
isAlpha				:: !Char -> Bool			//	True if arg1 is a  letter
isDigit				:: !Char -> Bool			//	True if arg1 is a  digit
isAlphanum			:: !Char -> Bool			//	True if arg1 is an alphanumerical character
