implementation module menuDevice

import StdEnv
import ostypes, oskernel, osmenu
import deltaIOSystem, ioState, commonDef, misc
from deltaMenu import SelectMenuRadioItem
import deltaDialog

AboutId        :== 1     
AboutDialogId  :== -1
AppendPosition :== -1 /*MIT_END in headerfile os2emx.h*/

MenuFunctions:: DeviceFunctions *s
MenuFunctions = (ShowMenu, OpenMenu , MenuIO, CloseMenu, HideMenu)

CloseMenu:: !(IOState s) -> IOState s
CloseMenu io_state = IOStateRemoveDevice io_state MenuDevice

HideMenu:: !(IOState s) -> IOState s
HideMenu io_state = io_state

ShowMenu:: !(IOState s) -> IOState s
ShowMenu io_state = io_state

OpenMenu:: !.(DeviceSystem s (IOState s)) !(IOState s) -> IOState s
OpenMenu menus io_state = io_state

/*
	Menus are opened whenever a new window is opened.
	The current menu state found in the IOState is used
*/

OpenWindowMenu  :: !(IOState s) -> IOState s
OpenWindowMenu io_state
	= let! 
		menusystem`
	  in IOStateSetCurrentMenu menusystem` io_state`
	where 
		menusystem`             = CreateMenuBarSystem menusystem
		(menusystem, io_state`) = StrictAbout io_state x
		x`                      = OSInsertSystemMenuItem AboutId "~About..." 0
		x                       = OSInsertSystemSeparatorItem (AboutId - 1) 0 (x` + 0)

StrictAbout:: !(IOState s) !Int -> (CurrentMenuSystem s, IOState s)
StrictAbout io_state itemid = IOStateGetCurrentMenu io_state

CreateMenuBarSystem:: (CurrentMenuSystem s) -> CurrentMenuSystem s
CreateMenuBarSystem NoCurMenu
	= NoCurMenu
CreateMenuBarSystem (CurMenu menus shortcuts state itemid)
	= let! 
		shortcuts`
		menus`
	  in CurMenu menus` shortcuts` Able itemid
	where 
		shortcuts` = CreateShortCuts (OSInitShortCuts (NrOfCuts shortcuts)) shortcuts state
		menus`     = CreateMenuBarItems menus

NrOfCuts:: [ShortCut] -> Int
NrOfCuts [ShortCutHandle p i i2 c a : css]
		= inc (NrOfCuts css)
NrOfCuts [SubShortCuts     i i2 a cs : css]
		= NrOfCuts cs + NrOfCuts css 
NrOfCuts css 
		= 0

CreateShortCuts:: !Int ![ShortCut] !SelectState -> [ShortCut]
CreateShortCuts n [ShortCutHandle ptr myid id cut state : scs] globalstate
		= let! 
			ptr`
			scs`
			sc`
		  in [sc` : scs`]
		  where 
		  sc`  = ShortCutHandle ptr` myid id cut state
		  ptr` = OSInsertShortCut cut myid (GetState globalstate state)
		  scs` = CreateShortCuts n scs globalstate
CreateShortCuts n [SubShortCuts id id2 state cs : scs] globalstate
		= let! 
			sc`
			cs`
			scs`
		  in [sc` : scs`]
		  where 
		  sc`  = SubShortCuts id id2 state cs`
		  cs`  = CreateShortCuts n cs (NewState globalstate state)
		  scs` = CreateShortCuts n scs globalstate
		
CreateShortCuts n [] globalstate
		= []

GetState:: !SelectState !SelectState -> Bool
GetState Unable state  = False
GetState able   Able   = True
GetState able   unable = False

NewState:: !SelectState !SelectState -> SelectState
NewState Unable state = Unable
NewState able   state = state

CreateMenuBarItems:: !(MenuHandles s (IOState s)) -> MenuHandles s (IOState s)
CreateMenuBarItems [PullDownHandle ptr myid id title able items : menus]
	= let! 
			ptr2
			item_handles
		 	menus`
	  in [pulldown_handle : menus`]
	where 
		pulldown_handle = PullDownHandle ptr2 myid id title able item_handles
		item_handles    = CreateMenuItems ptr2 items
		menus`          = CreateMenuBarItems menus

		ptr2 = case able of
				Able -> ptr1
				Unable -> OSEnOrDisableMenuItem ptr1 False
				
		ptr1            = OSInsertMenuBarItem myid title AppendPosition
CreateMenuBarItems menus 
	= []

CreateMenuItems:: !MenuPtr ![MenuItemHandle s (IOState s)] -> [MenuItemHandle s (IOState s)]
CreateMenuItems menuptr [ItemHandle ptr myid id title cut able f : items]
		= let! 
			items`
			ptr`
		  in [item` : items`]
		  where 
		  item`  = ItemHandle ptr` myid id title cut able f
		  items` = CreateMenuItems menuptr items
		  ptr`   = OSInsertMenuItem myid title menuptr AppendPosition (GetAbility able) False False
CreateMenuItems menuptr [CheckItemHandle ptr myid id title cut able mark f : items]
		= let! 
			items`
			ptr`
		  in [item` : items`]
		  where 
		  item`  = CheckItemHandle ptr` myid id title cut able mark f
		  items` = CreateMenuItems menuptr items
		  ptr`   = OSInsertMenuItem myid title menuptr AppendPosition (GetAbility able) (GetMark mark) False
CreateMenuItems menuptr [SubItemHandle ptr myid id title able sub_items : items]
		= let! 
			item`
			items`
			sub_items`
			ptr`
		  in [item` : items`]
		  where 
		  item`      = SubItemHandle ptr` myid id title able sub_items`
		  items`     = CreateMenuItems menuptr items
		  sub_items` = CreateMenuItems ptr` sub_items
		  ptr`       = OSInsertMenuItem myid title menuptr AppendPosition (GetAbility able) False True
CreateMenuItems menuptr [ItemGroupHandle ptr id sub_items : items]
		= let! 
			item`
		 	items`
			sub_items`
		  in [item` : items`]
		  where 
		  item`      = ItemGroupHandle menuptr id sub_items`
		  items`     = CreateMenuItems menuptr items
		  sub_items` = CreateMenuItems menuptr sub_items
CreateMenuItems menuptr [RadioItemsHandle myid id radio_items : items]
		= let! 
			item`
			items`
			radio_items`
		  in [item` : items`]
		  where 
		  item`        = RadioItemsHandle myid id radio_items`
		  items`       = CreateMenuItems menuptr items
		  radio_items` = CreateRadioItems menuptr myid radio_items
CreateMenuItems menuptr [SeparatorHandle ptr myid : items]
		= let! 
			items`
			ptr`
		  in [item` : items`]
		  where 
		  items` = CreateMenuItems menuptr items
		  item`  = SeparatorHandle ptr` myid
		  ptr`   = OSInsertSeparatorItem myid menuptr AppendPosition
		
CreateMenuItems menuptr items
		= []  

CreateRadioItems:: !MenuPtr !MenuItemId ![MenuItemHandle s (IOState s)] -> [MenuItemHandle s (IOState s)]
CreateRadioItems menuptr selid [ItemHandle ptr myid id title cut able f : items]
	| selid == myid
		= let! 
			items`
			ptr`
		  in [item` : items`]
		  where 
		  item`  = ItemHandle ptr` myid id title cut able f
		  items` = CreateRadioItems menuptr selid items
		  ptr`   = OSInsertMenuItem myid title menuptr AppendPosition (GetAbility able) True False
CreateRadioItems menuptr selid [ItemHandle ptr myid id title cut able f : items]
		= let! 
			items`
			ptr`
		  in [item` : items`]
		  where 
		  item`  = ItemHandle ptr` myid id title cut able f
		  items` = CreateRadioItems menuptr selid items
		  ptr`   = OSInsertMenuItem myid title menuptr AppendPosition (GetAbility able) False False
CreateRadioItems menuptr selid []
		= []

GetAbility:: SelectState -> Bool
GetAbility Able = True
GetAbility able = False
		
GetMark:: MarkState -> Bool
GetMark Mark = True
GetMark mark = False
		
ValidateMenuSystem:: !(DeviceSystem s (IOState s)) -> CurrentMenuSystem s
ValidateMenuSystem (MenuSystem menus)
	=	CurMenu menus` cuts Able itemid
	where 
		(menus`, cuts, itemid) = ValMenuBarItems menus (AboutId + 1) []
		
ValMenuBarItems:: ![MenuDef s (IOState s)] !Int ![Char] -> (MenuHandles s (IOState s), [ShortCut], Int)
ValMenuBarItems [PullDownMenu id title able items : menus] newid character
		= ([thismenu : menus`], [subcuts : cuts`], newid``)
		  where 
		  thismenu                 = PullDownHandle (-1) newid id title` able items`
		  (title`, character`)     = AddAltShortKey title character
		  subcuts                  = SubShortCuts newid id able cuts
		  (items`, cuts, newid`)   = ValMenuItems items (inc newid) []
		  (menus`, cuts`, newid``) = ValMenuBarItems menus (inc newid`) character`
ValMenuBarItems [] nsc character
		= ([], [], nsc)


Aboutfunc:: !*s !(IOState *s) -> (!*s, !IOState *s)
Aboutfunc s io
		= (s,OpenAboutDialog io)


OpenAboutDialog:: !(IOState s) -> IOState s
OpenAboutDialog io_state
		= OpenDialog dialog io_state`
		  where 
		  (io_state`,dialog) = GetAboutDialog (io_state)
		

SetAboutDialog:: !(AboutDialogDef s) -> DialogDef s (IOState s)
SetAboutDialog (About (about)) 
		= ConvertAboutToCommandDialog (about)
SetAboutDialog NoAbout
		= CommandDialog AboutDialogId ("About") [] 2 items
		  where 
		  text1item = StaticText 3 Center "This is a Clean Program."
		  text2item = StaticText 4 Center "Clean is freely available from ftp.cs.kun.nl"
		  text3item = StaticText 5 Center "Please send remarks to clean@cs.kun.nl"
		  items     = [text1item,text2item,text3item,okitem]
		  okitem    = DialogButton 2 Center "OK" Able CloseDialogButtonFunction
		

GetAboutDialog:: !(IOState s) -> (IOState s,!DialogDef s (IOState s))
GetAboutDialog io_state
		= (io_state`,dialog``)
		  where 
		  dialog``            = SetAboutDialog (dialog`)
		  (dialog`,io_state`) = IOStateGetAbout(io_state)
		

ConvertAboutToCommandDialog   :: (DialogDef s (IOState s)) -> DialogDef s (IOState s)
ConvertAboutToCommandDialog (AboutDialog name domain draw help)
		= CommandDialog AboutDialogId ("About " +++ name) [] 2 items
		  where 
		  iconitem = DialogIconButton 1 Center domain (AboutLook draw) Unable DummyButtonFunction
		  okitem   = DialogButton 2 Center "OK" Able CloseDialogButtonFunction
		  items    = [iconitem, okitem] ++ (HelpButton help (RightTo 2))
		

AboutLook:: [DrawFunction] SelectState -> [DrawFunction]
AboutLook funs state = funs

HelpButton:: (AboutHelpDef s io) ItemPos -> [DialogItem s io]
HelpButton (AboutHelp title about) pos
		= [DialogButton 3 pos title Able (HelpButtonFunction about)]
HelpButton nohelp pos
		= []

DummyButtonFunction:: DialogInfo * s * io -> (*s, *io)
DummyButtonFunction info s io = (s, io)

CloseDialogButtonFunction:: DialogInfo * s (IOState *s) -> (*s, IOState *s)
CloseDialogButtonFunction info s io = (s, CloseActiveDialog io)

HelpButtonFunction:: (AboutHelpFunction *s *io) DialogInfo * s * io -> (*s, *io)
HelpButtonFunction about info s io = about s io

ValMenuItems:: ![MenuElement s (IOState s)] !Int ![Char] -> ([MenuItemHandle s (IOState s)], [ShortCut], Int)
ValMenuItems [MenuItem itemid title cut able f : items] newid character
		= ([item : items`], cuts``, newid`)
		  where 
		  item                  = ItemHandle (-1) newid itemid title`` cut able f
		  (title`,character`)   = AddAltShortKey title character
		  (cuts``,title``)      = ValTitle cut newid itemid title` able cuts`
		  (items`,cuts`,newid`) = ValMenuItems items (inc newid) character`
		 
ValMenuItems [CheckMenuItem itemid title cut able mark f : items] newid character
		= ([item : items`], cuts``, newid`)
		  where 
		  item                  = CheckItemHandle (-1) newid itemid title`` cut able mark f
		  (title`,character`)   = AddAltShortKey title character
		  (cuts``,title``)      = ValTitle cut newid itemid title` able cuts`
		  (items`,cuts`,newid`) = ValMenuItems items (inc newid) character`
		
ValMenuItems [SubMenuItem id title able sub_items : items] newid character
		= ([item : items`], [subcuts:cuts``], newid``)
		  where 
		  item                      = SubItemHandle (-1) newid id title` able sub_items`
		  (title`,character`)       = AddAltShortKey title character
		  subcuts                   = SubShortCuts newid id able cuts`
		  (sub_items`,cuts`,newid`) = ValMenuItems sub_items (inc newid) ['\0']
		  (items`,cuts``,newid``)   = ValMenuItems items newid` character`
		
ValMenuItems [MenuItemGroup groupid sub_items : items] newid character
		= ([item : items`], cuts` ++ cuts``, newid``)
		  where 
		  item                      = ItemGroupHandle (-1) groupid sub_items`
		  (sub_items`,cuts`,newid`) = ValMenuItems sub_items (inc newid) ['\0']
		  (items`,cuts``,newid``)   = ValMenuItems items newid` character
		
ValMenuItems [MenuRadioItems selid radioitems : items] newid character
		= ([item : items`], cuts` ++ cuts``, newid``)
		  where 
		  item                                = RadioItemsHandle newselid selid radioitems`
		  (radioitems`,cuts`,newselid,newid`) = ValRadioItems radioitems selid newid character
		  (items`,cuts``,newid``)             = ValMenuItems items newid` character
		
ValMenuItems [MenuSeparator : items] newid character
		= ([item : items`], cuts`, newid`)
		  where 
		  item                  = SeparatorHandle (-1) newid
		  (items`,cuts`,newid`) = ValMenuItems items (inc newid) character
		
ValMenuItems [] newid character
		= ([], [], newid)  

ValRadioItems:: [RadioElement s (IOState s)] Int Int [Char] -> ([MenuItemHandle s (IOState s)], [ShortCut], Int, Int)
ValRadioItems [MenuRadioItem id title cut able f : items] selid newid character
		= ([item : items`], cuts``, selid``, newid`)
		  where 
		  item                         = ItemHandle (-1) newid id title`` cut able f`
		  f`                           = MenuRadioFunction id f
		  (title`,character`)          = AddAltShortKey title character 
		  (cuts``,title``)             = ValTitle cut newid id title` able cuts`
		  selid``                      = CheckRadioSelection selid id newid selid`
		  (items`,cuts`,selid`,newid`) = ValRadioItems items selid (inc newid) character`
		
ValRadioItems [] selid newid character
		= ([], [], -1, newid)

MenuRadioFunction:: !MenuItemId !(MenuFunction *s (IOState *s)) !*s !(IOState *s) -> (!*s, !IOState *s)
MenuRadioFunction the_id f state io_state
		= (state`, SelectMenuRadioItem the_id io_state`)
		  where 
		  (state`, io_state`) = f state io_state

CheckRadioSelection:: Int Int Int Int -> Int
CheckRadioSelection id1 id2 id3 id4
	| id1 == id2
		= id3
		= id4

ValTitle:: KeyShortcut MenuItemId MenuItemId String SelectState [ShortCut] -> ([ShortCut], String)
ValTitle (Key k) myid id title able cuts
	= (cuts`,title +++ "\tCtrl + " +++ toString k`)
	where 
		cuts`  = [newcut:cuts]
		newcut = ShortCutHandle (-1) myid id k` able
		k`     = ValChar k
ValTitle k myid id title able cuts
	= (cuts, title)

ValChar:: !Char -> Char
ValChar c
	| 'A' <= c && c <= 'Z'
		= toChar (code_a + (charcode - code_A))
		= c
		  where 
		  charcode = toInt c
		  code_a   = toInt 'a'
		  code_A   = toInt 'A'

/* Doing menu I/O */
MenuIO:: !.Event !*s !(IOState *s) -> (!Bool, !*s, !IOState *s)
MenuIO (OSMenuDevice, AboutId, x, y) state io_state
	=	(True, state, iostate`)
	where 
		iostate` = OpenAboutDialog io_state
MenuIO (OSMenuDevice, menu_id, x, y) state io_state 
	=	(True, state`, io_state``)
	where 
		(state`, io_state``) = MenuIO` menu_id menus state io_state`
		(menus,  io_state` ) = IOStateGetDevice  io_state MenuDevice
MenuIO no_menu_device state io_state
		= (False, state, io_state)

MenuIO`:: !Int !(DeviceSystemState *s) !*s !(IOState *s) -> (!*s, !IOState *s)
MenuIO` id (MenuSystemState menuhandles) state io_state
	=	menu_f state io_state
	where 
		menu_f = GetMenuFunction id menuhandles	

GetMenuFunction:: !Int ![MenuHandle s (IOState s)] -> MenuFunction s (IOState s)
GetMenuFunction id [PullDownHandle ptr id1 id2 t state itemhandles : menus]
	| found
		= f
		= GetMenuFunction id menus
		  where 
		  (found, f) = GetMenuFunction` id itemhandles

GetMenuFunction`:: !Int ![MenuItemHandle s (IOState s)] -> (!Bool, !MenuFunction s (IOState s))
GetMenuFunction` id [ItemHandle ptr myid id2 title cut able f : items]
	| id == myid
		= (True, f)
		= GetMenuFunction` id items
GetMenuFunction` id [CheckItemHandle ptr myid id2 title cut able mark f : items]
	| id == myid
		= (True, f)
		= GetMenuFunction` id items
GetMenuFunction` id [SubItemHandle ptr myid id2 title able sub_items : items]
		= GetMenuFunction` id (sub_items ++ items)
GetMenuFunction` id [ItemGroupHandle ptr id2 sub_items : items]
		= GetMenuFunction` id (sub_items ++ items)
GetMenuFunction` id [RadioItemsHandle id1 id2 radioitems : items]
	| found 
		= (True, f)
		= GetMenuFunction` id items
		  where 
		  (found, f) = GetRadioFunction id radioitems
GetMenuFunction` id [item : items]
		= GetMenuFunction` id items
GetMenuFunction` id item
		= (False, NoFunc)

GetRadioFunction:: !Int ![MenuItemHandle s (IOState s)] -> (!Bool, !MenuFunction s (IOState s))
GetRadioFunction id [ItemHandle ptr myid id2 t cut able f : radios] 
	| id == myid
		= (True, f)
		= GetRadioFunction id radios
GetRadioFunction id radios
		= (False, NoFunc)

NoFunc:: *s (IOState *s) -> (*s, IOState *s)
NoFunc s io = (s,io)

AddAltShortKey:: !String ![Char]-> (String, [Char])
AddAltShortKey title character 
	| altKeyExist
		= (title , [(SelectAltKey character``) : character])
		= (InsertCharIntoString title insertChar numberKey , character`)
	where 
		  character`                = [(SelectAltKey(title !! numberKey)) : character]
		  (numberKey,insertChar)    = SelectShortKey title character 0
		  (altKeyExist,character``) = AlreadyAltKey title 0

AlreadyAltKey:: !String !Int -> (!Bool, !Char) 
AlreadyAltKey title current 
	| current == (# (title) - 1)
		= (False, '\0') 
	| (title !! current) == '~'
		= (True, (title !! (current + 1)))
		= AlreadyAltKey title (inc current)

InsertCharIntoString:: !String !Char !Int -> String
InsertCharIntoString title ' ' position  
		= title
InsertCharIntoString title character position
		= title % (0, position -1) +++ toString character +++ title % (position, # title)

SelectShortKey:: !String ![Char] !Int -> (Int, Char)
SelectShortKey title characters current 
	| not (AltShortKeyUsed (title !! current) characters)
		= (current,'~') 
	| (current <= # (title)) 
		= SelectShortKey title characters (inc current)
		= (current,' ')

AltShortKeyUsed:: !Char ![Char] -> Bool
AltShortKeyUsed newKey [ usedKey : usedKeys]
	| (SelectAltKey(newKey)) == usedKey 
		= True 
	| (SelectAltKey(newKey)) == '\0' 
		= True
		= AltShortKeyUsed newKey usedKeys
AltShortKeyUsed newKey [] 
		= False

SelectAltKey:: !Char ->Char
SelectAltKey character
	| character == 'a' = 'A'
	| character == 'b' = 'B'
	| character == 'c' = 'C'
	| character == 'd' = 'D'
	| character == 'e' = 'E'
	| character == 'f' = 'F'
	| character == 'g' = 'G'
	| character == 'h' = 'H'
	| character == 'i' = 'I'
	| character == 'j' = 'J'
	| character == 'k' = 'K'
	| character == 'l' = 'L'
	| character == 'm' = 'M'
	| character == 'n' = 'N'
	| character == 'o' = 'O'
	| character == 'p' = 'P'
	| character == 'q' = 'Q'
	| character == 'r' = 'R'
	| character == 's' = 'S'
	| character == 't' = 'T'
	| character == 'u' = 'U'
	| character == 'v' = 'V'
	| character == 'w' = 'W'
	| character == 'x' = 'X'
	| character == 'y' = 'Y'
	| character == 'z' = 'Z'
	| 'A' <= character && character <= 'Z' = character
	| '0' <= character && character <= '9' = character
		= '\0'
