implementation module files

import osfiles, StdEnv

::	DATE = {	exists	:: !Bool,	// file bestaat
				yy		:: !Int,	// jaar van laatste wijziging
				mm		:: !Int,	// maand van laatste wijziging
				dd		:: !Int,	// dag van laatste wijziging
				h		:: !Int,	// uur van laatste wijziging
				m		:: !Int,	// minuut van laatste wijziging
				s		:: !Int } 	// seconde van laatste wijziging


FExists	:: !String !Files -> (!Bool, !Files)
FExists fname fs
		= (OSFileExists fname, fs)


FRemove	:: !String !Files -> (!Bool, !Files)
FRemove fname fs
		= (OSFileRemove fname, fs)
		

FModified :: !String !Files -> (!DATE, !Files)
FModified fname fs
		= (date, fs)
		  where
		  date = {exists = exists, yy = yy, mm = mm, dd = dd, h = h, m = m, s = s}
		  (exists, yy, mm, dd, h, m, s) = OSFileModified fname


FStartUpDir :: !String !Files -> (!String, !Files)
FStartUpDir fname fs
		= (OSFileStartUpDir fname, fs)
		

FTempFileName :: !String !Files -> (!String, !Files)
FTempFileName fname fs
		= (OSFileTempFileName fname, fs)
		

Launch :: !Bool !String ![String] !Files !.x -> (!Int,!Files,!.x)
Launch pm appname args fs io
		= (result, fs, io)
		  where
		  args2  = BuildArgVector appname args
		  result = OSFileStartNewApplication pm appname args2


LaunchSub :: !Bool !String ![String] !Files !.x -> (!Int, ![String],!Files,!.x)
LaunchSub sync appname args fs io
	| result == 0
		= (0, read fstdout, fs, io)
		= (result, [], fs, io)
		  where
		  args2             = BuildArgVector appname args
		  (result, fstdout) = OSFileStartSubApplication appname args2
		  
		  read f
		  	| not ok
		  		= []
		  	| sync
		  		= let!
		  			ss = read f2
		  		  in [s : ss]
		  		= [s : read f2]
		  		  where
		  		  (ok, f2, s) = OSFileReadString f
		  		  

BuildArgVector :: String [String] -> String
BuildArgVector appname args
		= build [convert appname : args]
		  where
		  convert appname
		  	| l > 4 && appname % (l - 4, l - 1) == ".exe"
		  		= appname % (0, l - 5) +++ "\000"
		  		= appname +++ "\000"
		  		  where
		  		  l = # appname
		  
		  build [s : ss]
		  		= s +++ " " +++ build ss
		  build []
		  		= "\000"
