implementation module dialogDef

/* The type definitions for the dialog device.
*/

import commonDef, StdInt
from deltaPicture import DrawFunction,Picture
from ostypes import DialogPtr, DummyPtr

		

/* Type definitions for deltaIOSystem.
*/

:: DialogDef * s * io
		= PropertyDialog DialogId DialogTitle [DialogAttribute] (SetFunction s io)
		  (ResetFunction s io) [DialogItem s io]
	|  CommandDialog  DialogId DialogTitle [DialogAttribute] 
		  DialogItemId [DialogItem s io]
	|  AboutDialog    ApplicationName PictureDomain [DrawFunction] 
		  (AboutHelpDef s io)

:: ApplicationName :== String
:: AboutHelpDef * s * io
		= NoHelp
	|  AboutHelp ItemTitle (AboutHelpFunction s io)
:: AboutHelpFunction * s * io :== s ->  *(io -> (s,io)) 

:: DialogAttribute
		= DialogPos    Measure Measure
	|  DialogSize   Measure Measure
	|  DialogMargin Measure Measure
	|  ItemSpace    Measure Measure
	|  StandByDialog

:: DialogId    :== Int
:: DialogTitle :== String
:: Measure     = MM Real | Inch Real | Pixel Int
 
:: DialogItem * s * io
		= DialogButton DialogItemId ItemPos ItemTitle SelectState (ButtonFunction s io)
	|  DialogIconButton DialogItemId ItemPos PictureDomain IconLook
		  SelectState (ButtonFunction s io)
	|  StaticText   DialogItemId ItemPos String
	|  DynamicText  DialogItemId ItemPos TextWidth String
	|  EditText     DialogItemId ItemPos TextWidth NrEditLines String
	|  DialogPopUp  DialogItemId ItemPos SelectState DialogItemId
										   [RadioItemDef s io]
	|  RadioButtons DialogItemId ItemPos RowsOrColumns DialogItemId
										   [RadioItemDef s io]
	|  CheckBoxes   DialogItemId ItemPos RowsOrColumns [CheckBoxDef s io]
	|  Control      DialogItemId ItemPos PictureDomain SelectState ControlState
		  ControlLook ControlFeel (DialogFunction s io)
 
:: DialogItemId  :== Int
:: RowsOrColumns = Rows Int | Columns Int
:: ItemPos       = Left | Center | Right        |
		  RightTo DialogItemId         |
		  Below DialogItemId           |
		  XOffset DialogItemId Measure |
		  YOffset DialogItemId Measure |
		  XY Measure Measure           |
		  ItemBox Int Int Int Int
:: IconLook      :== SelectState -> [DrawFunction]
:: TextWidth     :== Measure
:: NrEditLines   :== Int
:: RadioItemDef * s * io
		= RadioItem DialogItemId ItemTitle SelectState (DialogFunction s io)
:: CheckBoxDef * s * io
		= CheckBox DialogItemId ItemTitle SelectState MarkState (DialogFunction s io)
 
:: ControlState = IntCS    Int                     |
		  BoolCS   Bool                    |
		  RealCS   Real                    | 
		  StringCS String                  |
		  PairCS ControlState ControlState |
		  ListCS [ControlState]
:: ControlLook :== SelectState ->  ControlState -> [DrawFunction] 
:: ControlFeel :== MouseState ->   ControlState -> (ControlState,[DrawFunction]) 
 
:: SetFunction    * s * io :== ButtonFunction s io
:: ResetFunction  * s * io :== ButtonFunction s io
:: DialogFunction * s * io :== DialogInfo -> (DialogState s io) -> DialogState s io
:: ButtonFunction *s * io :== DialogInfo -> ( s -> * (io -> (s,io)))
 
:: NoticeDef       = Notice [String] NoticeButtonDef [NoticeButtonDef]
:: NoticeButtonDef = NoticeButton NoticeButtonId ItemTitle
:: NoticeButtonId  :== Int

/* Rules for internal access on the DialogState and DialogInfo
*/

:: * DialogState * s * io :== DialogHandle s io
:: DialogInfo             :== (ItemInfo, IdTable)

:: OsId                   :== Int
:: IdTable                :== [(DialogItemId,OsId)]

:: DialogHandle * s * io :== (DialogId, Bool, ! DialogPtr, ! ItemInfo, ItemInfo2 s io, IdTable)

:: ItemFunction * s * io
		= ItemButtonFunction (ButtonFunction s io)
	|  ItemDialogFunction (DialogFunction s io)
	|  ItemHelpFunction (AboutHelpFunction s io)
	|  ItemEmptyFunction

:: ControlInfo :== (PictureDomain,ControlState,ControlLook,ControlFeel)

:: ItemInfo   :== ([(OsId,String)],         
                  [(OsId,Bool,Int,[OsId])],      
                  [(OsId,OsId,Bool)],
                  [(OsId,ControlInfo)],     
                  [(OsId,String)])

/* ItemInfo2 is no part of ItemInfo to prevent s and io vars in DialogInfo */
:: ItemInfo2 * s * io :== [(OsId,ItemFunction s io)]

		

/* access function on dialog structures */

DialogStateToDialogHandle :: !(DialogState  s io) -> DialogHandle s io
DialogStateToDialogHandle dialog = dialog
		
DialogHandleToDialogState :: !(DialogHandle * s * io) -> DialogState *s *io
DialogHandleToDialogState (id,mode,wptr,info,funs,osids) = (id,mode,wptr,info,funs,osids)

DialogInfoToItemInfo :: !DialogInfo -> (!ItemInfo, !IdTable)
DialogInfoToItemInfo (info, idtable)
		= (info, idtable)
		
ItemInfoToDialogInfo :: !ItemInfo IdTable -> DialogInfo
ItemInfoToDialogInfo info table
		= (info, table)

IsModalDialog :: !(DialogHandle s io) -> (Bool, DialogPtr)
IsModalDialog (id,modal,ptr,info,funs,osids) = (modal, ptr)

GetDialogHandleId :: !(DialogHandle s io) -> DialogId
GetDialogHandleId (id,modal,ptr,info,funs,osids) = id

DialogStateToDialogInfo :: !(DialogState s io) -> (DialogInfo, DialogState s io)
DialogStateToDialogInfo (id,modal,ptr,info,funs,osids) = ((info, osids), (id,modal,ptr,info,funs,osids))

OsIdToId    :: !OsId !IdTable -> DialogItemId
OsIdToId osid [(id,osid2) : ids]
	| osid == osid2 = id
		= OsIdToId osid ids
OsIdToId osid ids
		= -1
		
IdToOsId    :: !DialogItemId !IdTable -> OsId
IdToOsId id [(id2,osid) : osids]
	| id == id2 = osid
		= IdToOsId id osids
IdToOsId id osids
		= -1

		 

DummyDialogDef      :== CommandDialog (-1) "" [] (-1) []
DummyDialogInfo     :== (DummyItemInfo, [])
DummyItemInfo       :== ([],[],[],[],[])
DummyDialogHandle   :== (0, False, DummyPtr,DummyItemInfo,[],[])

