implementation module deltaMenu

import StdEnv
import ioState, deltaIOSystem, menuDevice, misc, osmenu

:: MenuItemChange * s :== (MenuItemHandle s (IOState s)) ->  MenuItemHandle s (IOState s) 
:: MenuChange * s :== (MenuHandle s (IOState s)) ->  MenuHandle s (IOState s) 

StrictMap:: (x -> y) [x] -> [y]
StrictMap f []    
		= []
StrictMap f [x:xs] 
		= let!
			strict1 = f x
			strict2 = StrictMap f xs
		  in [strict1: strict2]

ChangeMenus:: !(IOState s) !(MenuChange s) -> IOState s
ChangeMenus io_state function
		= IOStateSetCurrentMenu menus` io_state`
		  where
		  menus`            = ChangeMenus` menus function
		  (menus,io_state`) = IOStateGetCurrentMenu io_state

ChangeMenus`:: !(CurrentMenuSystem s) !(MenuChange s) -> CurrentMenuSystem s
ChangeMenus` NoCurMenu function
		= NoCurMenu
ChangeMenus` (CurMenu menus shortcuts state i) function
		= let!
			menus` = StrictMap function menus
		  in CurMenu menus` shortcuts state i

MenuItemChangeToMenuChange:: (MenuItemChange s) (MenuHandle s (IOState s)) -> MenuHandle s (IOState s)
MenuItemChangeToMenuChange f (PullDownHandle ptr myid id title state items)
		= let!
			items` = StrictMap f items
		  in PullDownHandle ptr myid id title state items`

ChangeMenuItems:: !(IOState s) !(MenuItemChange s) -> IOState s
ChangeMenuItems io_state function
		= ChangeMenus io_state (MenuItemChangeToMenuChange function)

/* Enabling and disabling of complete menusystems. */

EnableMenuSystem:: !(IOState s) -> IOState s
EnableMenuSystem io_state
		= ChangeMenus io_state`` (SetMenuAbility Able)
		  where
		  io_state``        = IOStateSetCurrentMenu menus` io_state`
		  menus`            = SetCutsOfSystem menus Able
		  (menus,io_state`) = IOStateGetCurrentMenu io_state

SetCutsOfSystem:: (CurrentMenuSystem s) SelectState -> CurrentMenuSystem s
SetCutsOfSystem NoCurMenu able
		= NoCurMenu
SetCutsOfSystem (CurMenu menus cuts state id) able
		= CurMenu menus cuts` state id
		  where
		  cuts` = SetShortCuts able cuts

DisableMenuSystem:: !(IOState s) -> IOState s
DisableMenuSystem io_state
		= ChangeMenus io_state`` (SetMenuAbility Unable)
		  where
		  io_state``        = IOStateSetCurrentMenu menus` io_state`
		  menus`            = SetCutsOfSystem menus Unable
		  (menus,io_state`) = IOStateGetCurrentMenu io_state

SetMenuAbility::  !SelectState (MenuHandle s (IOState s)) -> MenuHandle s (IOState s)
SetMenuAbility Able (PullDownHandle ptr myid id title Able items)
	= let!
		ptr` = OSEnOrDisableMenuItem ptr True
	  in PullDownHandle ptr` myid id title Able items
SetMenuAbility Unable (PullDownHandle ptr myid id title Able items)
	= let!
		ptr` = OSEnOrDisableMenuItem ptr False
	  in PullDownHandle ptr` myid id title Able items
SetMenuAbility newstate pd
	= pd

/*  Enabling and Disabling of Menus: */

EnableMenus:: ![MenuId] !(IOState state) -> IOState state
EnableMenus [] io_state
	= io_state
EnableMenus ids io_state
	=	ChangeShortCutsOfState Able ids io_state`
	where
		io_state` = ChangeMenus io_state (SetMenuAbilityOfIds ids Able)

DisableMenus:: ![MenuId] !(IOState s) -> IOState s
DisableMenus [] io_state
	= io_state
DisableMenus ids io_state
	=	ChangeShortCutsOfState Unable ids io_state`
	where
		io_state` = ChangeMenus io_state (SetMenuAbilityOfIds ids Unable)

SetMenuAbilityOfIds :: ![MenuId] !SelectState (MenuHandle s (IOState s)) -> MenuHandle s (IOState s)
SetMenuAbilityOfIds ids newstate m=:(PullDownHandle ptr myid id title state items)
	| isMember id ids
		= let!
			ptr` = SetAbility ptr state newstate
		  in  PullDownHandle ptr` myid id title newstate items
		= m

SetAbility:: !MenuPtr !SelectState !SelectState -> MenuPtr
SetAbility ptr Able  Unable = OSEnOrDisableMenuItem ptr False
SetAbility ptr Unable Able  = OSEnOrDisableMenuItem ptr True
SetAbility ptr a      on    = ptr

ChangeShortCutsOfState:: !SelectState [Int] !(IOState s) -> IOState s
ChangeShortCutsOfState newstate mids io_state
	=	IOStateSetCurrentMenu menus` io_state`
	where
		menus`             = ChangeShortCuts newstate mids menus
		(menus, io_state`) = IOStateGetCurrentMenu io_state

ChangeShortCuts:: !SelectState [Int] !(CurrentMenuSystem s) -> CurrentMenuSystem s
ChangeShortCuts newstate mids NoCurMenu
	= NoCurMenu
ChangeShortCuts newstate mids (CurMenu menus cuts state id)
	= let!
		cuts` = ChangeShortCutAbilities newstate state mids cuts
	  in CurMenu menus cuts` state id

ChangeShortCutAbilities:: !SelectState !SelectState [Int] ![ShortCut] -> [ShortCut]
ChangeShortCutAbilities able Unable mids [cut=: ShortCutHandle ptr myid id c state : cuts]
	| isMember id mids
		= let!
			cut`  = ShortCutHandle ptr myid id c able 
			cuts` = ChangeShortCutAbilities able Unable mids cuts
		  in [cut` : cuts`]
		= let!
			cuts` = ChangeShortCutAbilities able Unable mids cuts
		  in [cut  : cuts`]
ChangeShortCutAbilities able Unable mids [cut=: SubShortCuts myid id state subcuts : cuts]
	| isMember id mids
		= let!
			cut` 
			cuts`
		  in [cut`:cuts`]
		= let!
			cuts` 
			subcuts`
		  in  [cut``:cuts`]
		  where
		  cut`     = SubShortCuts myid id able subcuts`
		  cut``    = SubShortCuts myid id state subcuts`
		  cuts`    = ChangeShortCutAbilities able Unable mids cuts
		  subcuts` = ChangeShortCutAbilities able Unable mids subcuts
ChangeShortCutAbilities newstate able mids [cut=: ShortCutHandle ptr myid id c state : cuts]
	| isMember id mids
		= let!
			cut`
			cuts`
		  in [cut` : cuts`]
		= let!
			cuts`
		  in [cut : cuts`]
		  where
		  cut`  = SetCutAbility newstate cut
		  cuts` = ChangeShortCutAbilities newstate able mids cuts
ChangeShortCutAbilities newstate able mids [cut=: SubShortCuts myid id state subcuts : cuts]
	| isMember id mids
		= let!
			cut`
			cuts`
		  in [cut`:cuts`]
		= let!
			subcuts``
			cuts`
			cut``
		  in [cut``:cuts`]
		  where
		  cut`      = SubShortCuts myid id newstate subcuts`
		  subcuts`  = ChangeShortCutAbilities newstate newstate mids subcuts
		  cut``     = SubShortCuts myid id state subcuts``
		  subcuts`` = ChangeShortCutAbilities newstate (NewState state able) mids subcuts
		  cuts`     = ChangeShortCutAbilities newstate able mids cuts
ChangeShortCutAbilities newstate able mids cuts
		= []

SetShortCuts:: !SelectState ![ShortCut] -> [ShortCut]
SetShortCuts Unable [ShortCutHandle ptr myid id c Able : cuts]
		= let!
			ptr` 
			cuts`
			cut`
		  in [cut`:cuts`]
		  where
		  cut`  = ShortCutHandle ptr` myid id c Able
		  ptr`  = OSEnOrDisableShortCut ptr False
		  cuts` = SetShortCuts Unable cuts
SetShortCuts Able [ShortCutHandle ptr myid id c Unable : cuts]
		= let!
			ptr`
			cuts`
			cut`
		  in [cut`:cuts`]
		  where
		  cut`  = ShortCutHandle ptr` myid id c Unable
		  ptr`  = OSEnOrDisableShortCut ptr True
		  cuts` = SetShortCuts Able cuts
SetShortCuts able [SubShortCuts myid id Able subcuts : cuts]
		= let!
			cuts`
			subcuts`
			cut`
		  in [cut`:cuts`]
		  where
		  cut`     = SubShortCuts myid id Able subcuts`
		  cuts`    = SetShortCuts able cuts
		  subcuts` = SetShortCuts able subcuts
SetShortCuts able [cut : cuts]
		= let!
			strict1 = SetShortCuts able cuts
		  in [cut:strict1]
SetShortCuts able cuts
		= []

SetCutAbility:: SelectState ShortCut -> ShortCut
SetCutAbility Able (ShortCutHandle ptr myid id cut Unable)
		= let!
			ptr` = OSEnOrDisableShortCut ptr True
		  in ShortCutHandle ptr` myid id cut Able
SetCutAbility Unable (ShortCutHandle ptr myid id cut Able)
		= let!
			ptr` = OSEnOrDisableShortCut ptr False
		  in ShortCutHandle ptr` myid id cut Unable
SetCutAbility able cut
		= cut

NewState:: !SelectState !SelectState -> SelectState
NewState Unable state = Unable
NewState able   state = state

/*  Adding and removing items from groups
*/

InsertMenuItems:: !MenuItemGroupId !Int ![MenuElement s (IOState s)] !(IOState s) -> IOState s
InsertMenuItems group_id position new_items io_state
		= let!
			menus` = AddMenusItems group_id (max 0 (dec position)) new_items menus
			io_state`
		  in IOStateSetCurrentMenu menus` io_state`
		  where
		  (menus,io_state`) = IOStateGetCurrentMenu io_state


AppendMenuItems:: !MenuItemGroupId !Int ![MenuElement s (IOState s)] !(IOState s) -> IOState s
AppendMenuItems group_id position new_items io_state
		= IOStateSetCurrentMenu menus` io_state`
		  where
		  menus`            = AddMenusItems group_id (max 0 position) new_items menus
		  (menus,io_state`) = IOStateGetCurrentMenu io_state


AddMenusItems:: !MenuItemGroupId !Int ![MenuElement s (IOState s)] !(CurrentMenuSystem s) -> CurrentMenuSystem s
AddMenusItems group_id position new_items NoCurMenu
		= NoCurMenu
AddMenusItems group_id position new_items (CurMenu menus cuts state system_id)
		= CurMenu menus` cuts` state system_id`
		  where
		  (menus`,cuts`,system_id`) = AddMenusItems` group_id position new_items menus cuts system_id

AddMenusItems`:: !MenuItemGroupId !Int ![MenuElement s (IOState s)] ![MenuHandle s (IOState s)] ![ShortCut] !Int -> (![MenuHandle s (IOState s)], ![ShortCut], !Int)
AddMenusItems` group_id position new_items [menu : menus] [cut : cuts] system_id
	| current_menu_item_group
		= ([menu` : menus], [ cut` :cuts] , system_id`)
		= ([menu : menus`], [cut : other_cuts],system_id``)
		  where
		  (menus`,other_cuts,system_id``)                 = AddMenusItems` group_id position new_items menus cuts system_id
		  (current_menu_item_group,menu`,cut`,system_id`) = EnlargeMenuItemGroup group_id position new_items menu cut system_id
AddMenusItems` group_id position new_items menus cuts system_id
		= (menus, cuts,system_id)


EnlargeMenuItemGroup:: !MenuItemGroupId !Int ![MenuElement s (IOState s)] !(MenuHandle s (IOState s)) !ShortCut !Int -> (!Bool, !MenuHandle s (IOState s), !ShortCut, !Int)
EnlargeMenuItemGroup group_id position new_items menu_handle=:(PullDownHandle menuptr system_id menu_id title state items) cut=:(SubShortCuts cut_sysid cut_menuid cut_state cut_items) sys_id
	| has_group_changed
		= (True, PullDownHandle menuptr system_id menu_id title state items`, SubShortCuts cut_sysid cut_menuid cut_state cut_items`, sys_id`)
		= (False, menu_handle, cut, sys_id)
		  where
		  (has_group_changed,items`,cut_items`,sys_id`) = EnlargeMenuItemGroup` group_id position new_items items cut_items 1 sys_id

EnlargeMenuItemGroup`:: !MenuItemGroupId !Int ![MenuElement s (IOState s)] ![MenuItemHandle s (IOState s)] ![ShortCut] !Int !Int -> (!Bool, ![MenuItemHandle s (IOState s)], ![ShortCut], !Int)
EnlargeMenuItemGroup` group_id position new_items [group_h=:(ItemGroupHandle menuptr itemgroup_id itemgroup_items) : hs ] cuts item_nr system_id
	| (itemgroup_id == group_id)
		= (True, [ItemGroupHandle menuptr itemgroup_id itemgroup_items` : hs], cuts`, system_id`)
		= (b , [group_h : hs`], cuts``,system_id``)
		  where
		  (itemgroup_items`,cuts`,system_id`,_) = EnlargeItemGroup position new_items itemgroup_items cuts item_nr system_id menuptr (DetermineUsedAltKeys itemgroup_items [])
		  (b,hs`,cuts``,system_id``)            = EnlargeMenuItemGroup` group_id position new_items hs cuts item_nr` system_id
		  item_nr`                              = item_nr + # itemgroup_items
EnlargeMenuItemGroup` group_id position new_items [submenu_h=:(SubItemHandle menuptr system_id menu_id title state items) : hs] [cuts=:(SubShortCuts cut_sysid cut_menuid cut_state cut_items) : hcuts] item_nr sys_id
	| has_group
		= (True, [SubItemHandle menuptr system_id menu_id title state items` : hs] , [SubShortCuts cut_sysid cut_menuid cut_state cut_items` : hcuts], sys_id``)
		= (b , [submenu_h : hs`], [cuts : hcuts`], sys_id`)
		  where
		  (b,hs`,hcuts`,sys_id`)                 = EnlargeMenuItemGroup` group_id position new_items hs hcuts (inc item_nr) sys_id
		  (has_group,items`,cut_items`,sys_id``) = EnlargeMenuItemGroup` group_id position new_items items cut_items 1 sys_id
EnlargeMenuItemGroup` group_id position new_items [ handle : handles ] cuts item_nr system_id
		= (b, [handle : handles`], cuts`,system_id`)
		  where
		  (b,handles`,cuts`,system_id`) = EnlargeMenuItemGroup` group_id position new_items handles cuts (inc item_nr) system_id
EnlargeMenuItemGroup` id pos new_items handles cuts item_nr system_id
		= (False,handles,cuts,system_id)

EnlargeItemGroup:: !Int ![MenuElement s (IOState s)] ![MenuItemHandle s (IOState s)] ![ShortCut] !Int !Int !Int ![Char] -> (![MenuItemHandle s (IOState s)], ![ShortCut], !Int, ![Char])
EnlargeItemGroup 0 new_items items cuts item_nr system_id menuptr used_alt_keys
		= EnlargeItemGroup` new_items items cuts item_nr system_id menuptr used_alt_keys
EnlargeItemGroup position new_items [item : items] cuts item_nr system_id menuptr used_alt_keys
		= ([item : items`], cuts`,system_id`,used_alt_keys`)
		  where
		  (items`,cuts`,system_id`,used_alt_keys`) = EnlargeItemGroup (dec position) new_items items cuts (inc item_nr) system_id menuptr used_alt_keys
EnlargeItemGroup position new_items items cuts item_nr system_id menuptr used_alt_keys
		= EnlargeItemGroup` new_items items cuts (dec item_nr) system_id menuptr used_alt_keys

EnlargeItemGroup`:: ![MenuElement s (IOState s)] ![MenuItemHandle s (IOState s)] ![ShortCut] !Int !Int !Int ![Char] -> (![MenuItemHandle s (IOState s)], ![ShortCut], !Int, ![Char])
EnlargeItemGroup` [new_item : new_items] items cuts item_nr system_id menuptr used_alt_keys
	| (MenuElementIsGroupItem new_item == True)
		= ([item_h : items`],cuts``,system_id`,used_alt_keys``)
		= (items```,cuts```,system_id```,used_alt_keys```) 
		  where
		  (items```,cuts```,system_id```,used_alt_keys```) = EnlargeItemGroup` new_items items cuts item_nr system_id  menuptr used_alt_keys
		  (items`,cuts``,system_id`,used_alt_keys``)       = EnlargeItemGroup` new_items items cuts` item_nr system_id`` menuptr used_alt_keys`
		  (item_h,system_id``,used_alt_keys`, cuts`)       = NewMenuElement new_item item_nr system_id menuptr used_alt_keys cuts
EnlargeItemGroup` new items cuts item_nr system_id menuptr used_alt_keys
		= (items,cuts,system_id,used_alt_keys)

NewMenuElement:: (!MenuElement s (IOState s)) !Int !Int !Int ![Char] ![ShortCut]-> (!MenuItemHandle s (IOState s), !Int, ![Char], ![ShortCut])
NewMenuElement (MenuSeparator) nr system_id menuptr used_alt_keys cuts
		= let!
			ptr = OSInsertNewSeparatorItem (system_id + 1) menuptr (nr - 1)
		  in (SeparatorHandle ptr system_id, (system_id + 1), used_alt_keys, cuts)
NewMenuElement (MenuItem itemid title cut able f) nr system_id menuptr used_alt_keys cuts
		= let!
			ptr
			title``
			cuts`
		  in (ItemHandle ptr system_id itemid title`` cut able f, (system_id + 1), used_alt_keys`, cuts`)
		  where
		  ptr                     = OSInsertNewMenuItem system_id title`` menuptr (nr - 1) (GetAbility (able)) False False
		  (title`,used_alt_keys`) = AddAltShortKey title used_alt_keys
		  title``                 = AddShortCutText title` cut
		  cuts`                   = InsertNewShortCut system_id itemid cut cuts ptr able
NewMenuElement (CheckMenuItem itemid title cut able mark f) nr system_id menuptr used_alt_keys cuts
		= let!
			ptr
			title``
			cuts`
		  in (CheckItemHandle ptr system_id itemid title`` cut able mark f, (system_id + 1),used_alt_keys`, cuts`)
		  where
		  ptr                     = OSInsertNewMenuItem system_id title`` menuptr (nr - 1) (GetAbility (able)) (GetMark (mark)) False
		  (title`,used_alt_keys`) = AddAltShortKey title used_alt_keys
		  title``                 = AddShortCutText title` cut
		  cuts`                   = InsertNewShortCut system_id itemid cut cuts ptr able


AddShortCutText:: !String !KeyShortcut -> !String
AddShortCutText title (Key k)
		= title`
		  where
		  title` = title +++ "\tCtrl + " +++ toString k`
		  k`     = ValChar k
AddShortCutText title k
		= title


InsertNewShortCut:: !Int !Int !KeyShortcut ![ShortCut] !MenuPtr !SelectState-> ![ShortCut]
InsertNewShortCut system_id itemid (Key k) cut menuptr Able
		= let!
			ptr` = OSInsertNewShortCut k menuptr True
		  in ([(ShortCutHandle ptr` system_id itemid k Able) : cut])
InsertNewShortCut system_id itemid (Key k) cut menuptr Unable
		= let!
			ptr` = OSInsertNewShortCut k menuptr False
		  in ([(ShortCutHandle ptr` system_id itemid k Unable) : cut])
InsertNewShortCut system_id itemid k cut menuptr able
		= cut


ValChar:: !Char -> Char
ValChar c
	| 'A' <= c && c <= 'Z'
		= toChar (code_a + (charcode - code_A))
		= c
		  where
		  charcode = toInt c
		  code_a   = toInt 'a'
		  code_A   = toInt 'A'


GetAbility:: !SelectState -> !Bool
GetAbility Able = True
GetAbility able = False

GetMark:: !MarkState -> !Bool
GetMark Mark = True
GetMark mark = False


MenuElementIsGroupItem:: !(MenuElement s (IOState s)) -> !Bool
MenuElementIsGroupItem (MenuItem id t c s f)        = True
MenuElementIsGroupItem (CheckMenuItem id t c s m f) = True
MenuElementIsGroupItem MenuSeparator                = True
MenuElementIsGroupItem element                      = False

DetermineUsedAltKeys:: (![MenuItemHandle s (IOState s)]) ![Char] -> ![Char]
DetermineUsedAltKeys [ item : items ] key
		= key``
		  where
		  key`` = DetermineOneAltKey item (DetermineUsedAltKeys items key)
DetermineUsedAltKeys menu key 
		= key

DetermineOneAltKey:: (!MenuItemHandle s (IOState s)) ![Char] -> ![Char]
DetermineOneAltKey (ItemHandle ptr myid id title cut able f) key
		= AddKey title key
DetermineOneAltKey (CheckItemHandle ptr myid id title cut able mark f) key 
		= AddKey title key
DetermineOneAltKey (SubItemHandle ptr myid id title able sub) key 
		= AddKey title key
DetermineOneAltKey (RadioItemsHandle myid id items) key 
		= DetermineUsedAltKeys items key
DetermineOneAltKey item keys
		= keys

AddKey:: !String ![Char] -> ![Char]
AddKey title keys 
		= keys`
		  where
		  (_,keys`) = AddAltShortKey title keys

RemoveMenuItems :: ![MenuItemId] !(IOState s) -> IOState s
RemoveMenuItems [] io_state 
		= io_state
RemoveMenuItems item_ids io_state
		= IOStateSetCurrentMenu menus` io_state`
		  where
		  menus`              = RemoveMenusItems item_ids menus
		  (menus , io_state`) = IOStateGetCurrentMenu io_state

RemoveMenusItems:: ![MenuItemId] !(CurrentMenuSystem s) -> CurrentMenuSystem s
RemoveMenusItems item_ids NoCurMenu 
		= NoCurMenu
RemoveMenusItems item_ids (CurMenu menus cuts state system_id) 
		= (CurMenu menus` cuts` state system_id)
		  where
		  (menus`,cuts`) = RemoveMenusItems` item_ids menus cuts

RemoveMenusItems`:: ![MenuItemId] ![MenuHandle s (IOState s)] ![ShortCut] -> (![MenuHandle s (IOState s)] ,![ShortCut])
RemoveMenusItems` item_ids [] cuts
		= ([],cuts)
RemoveMenusItems` [] menus cuts 
		= (menus,cuts)
RemoveMenusItems` item_ids [menu : menus] cuts
		= ([menu` : menus`],cuts``)
		  where
		  (menus`,cuts``)         = RemoveMenusItems` item_ids` menus cuts`
		  (item_ids`,menu`,cuts`) = RemoveMenuItems` item_ids menu cuts  

RemoveMenuItems`:: ![MenuItemId] !(MenuHandle s (IOState s)) ![ShortCut] -> (![MenuItemId], !MenuHandle s (IOState s), ![ShortCut])
RemoveMenuItems` item_ids (PullDownHandle menuptr system_id menu_id title state items) cuts
		= (item_ids`,PullDownHandle menuptr system_id menu_id title state items`, cuts`)
		  where
		  (item_ids`,items`,cuts`) = RemoveFromGroupItems item_ids items cuts 1

RemoveFromGroupItems:: ![MenuItemId] ![MenuItemHandle s (IOState s)] ![ShortCut] !Int -> (![MenuItemId], ![MenuItemHandle s (IOState s)], ![ShortCut])
RemoveFromGroupItems item_ids done=:[] cuts item_nr
		= (item_ids,done,cuts)
RemoveFromGroupItems [] items cuts item_nr 
		= ([],items,cuts)
RemoveFromGroupItems item_ids [ItemGroupHandle menuptr id items : hs] cuts item_nr
		= (item_ids``,[ItemGroupHandle menuptr id items` : hs`] , cuts``)
		  where
		  (item_ids``,hs`,cuts``)  = RemoveFromGroupItems item_ids` hs cuts` item_nr`
		  (item_ids`,items`,cuts`) = RemoveGroupItems item_ids items cuts item_nr
		  item_nr`                 = item_nr + # items`
RemoveFromGroupItems item_ids [SubItemHandle menuptr system_id menu_id title state items : hs ] cuts item_nr 
		= (item_ids``,[SubItemHandle menuptr system_id menu_id title state items` : hs`], cuts``)
		  where
		  (item_ids``,hs`,cuts``)  = RemoveFromGroupItems item_ids` hs cuts` (inc item_nr)
		  (item_ids`,items`,cuts`) = RemoveFromGroupItems item_ids items cuts 1
RemoveFromGroupItems item_ids [no_item_group : hs] cuts item_nr
		= (item_ids`,[no_item_group : hs`], cuts`)
		  where
		  (item_ids`,hs`,cuts`) = RemoveFromGroupItems item_ids hs cuts (inc item_nr)

RemoveGroupItems:: ![MenuItemId] ![MenuItemHandle s (IOState s)] ![ShortCut] !Int -> (![MenuItemId],![MenuItemHandle s (IOState s)], ![ShortCut])
RemoveGroupItems item_ids [] cuts item_nr 
		= (item_ids,[],cuts)
RemoveGroupItems [] items cuts item_nr 
		= ([], items, cuts)
RemoveGroupItems item_ids [item_handle : hs] cuts item_nr
	| is_an_id_item && contains_item
		= (item_ids``,hs`,cuts`)
		= (item_ids``,[item_handle : hs`] , cuts``)
		  where
		  cuts`                      = RemoveShortCutAndMenuItem item_handle cuts
		  (contains_item,item_ids``) = IdWasPresent item_ids` id
		  (is_an_id_item,id)         = MenuHandle_MenuItemId item_handle
		  (item_ids`,hs`,cuts``)     = RemoveGroupItems item_ids hs cuts (inc item_nr)

RemoveShortCutAndMenuItem:: (!MenuItemHandle s (IOState s)) ![ShortCut] -> ![ShortCut]
RemoveShortCutAndMenuItem (ItemHandle menuptr sysid menuid title cut state f) cuts 
		= RemoveShortCut` (OSRemoveMenuItem sysid) cut cuts
RemoveShortCutAndMenuItem (CheckItemHandle menuptr sysid menuid title cut state mark f) cuts
		= RemoveShortCut` (OSRemoveMenuItem sysid) cut cuts
RemoveShortCutAndMenuItem item cuts 
		= cuts

RemoveShortCut`:: !Int !KeyShortcut ![ShortCut] -> ![ShortCut]
RemoveShortCut` sysid NoKey item
		= item
RemoveShortCut` sysid key=:(Key k) [(ShortCutHandle shortcutptr cutsysid menuid char state) : hs]
	| removed
		= RemoveShortCutFromOS hs (OSRemoveShortCut sysid)
		= RemoveShortCut` sysid key hs
		  where
		  removed = RemoveShortCut`` sysid cutsysid
RemoveShortCut` sysid key=:(Key k) [(SubShortCuts cutsysid menuid state items) : hs] 
		= [(SubShortCuts cutsysid menuid state items`) : hs`] 
		  where
		  items` = RemoveShortCut` sysid key items
		  hs`    = RemoveShortCut` sysid key hs
RemoveShortCut` sysid key [] = [] 

RemoveShortCut``:: !Int !Int -> !Bool
RemoveShortCut`` sysid cutsysid 
	| sysid == cutsysid
		= True
		= False

RemoveShortCutFromOS:: ![ShortCut] !x -> ![ShortCut]
RemoveShortCutFromOS hs f = hs

MenuHandle_MenuItemId:: !(MenuItemHandle s (IOState s)) -> (!Bool,!MenuItemId)
MenuHandle_MenuItemId (ItemHandle ptr sysid menuid title cut state f)
		= (True,menuid)
MenuHandle_MenuItemId (CheckItemHandle ptr sysid menuid title cut state mark f)
		= (True,menuid)
MenuHandle_MenuItemId (SubItemHandle ptr sysid menuid title state f) 
		= (True,menuid)
MenuHandle_MenuItemId (ItemGroupHandle menuptr menuid items) 
		= (True,menuid)
MenuHandle_MenuItemId no_id_item
		= (False,0)

RemoveMenuGroupItems:: !MenuItemGroupId ![Int] !(IOState s) -> IOState s
RemoveMenuGroupItems group_id [] io_state 
		= io_state
RemoveMenuGroupItems group_id item_inds io_state
		= IOStateSetCurrentMenu menus` io_state`
		  where
		  menus`            = RemoveMenusGroupItems group_id item_inds menus
		  (menus,io_state`) = IOStateGetCurrentMenu io_state

RemoveMenusGroupItems:: !MenuItemGroupId ![Int] (CurrentMenuSystem s) -> CurrentMenuSystem s
RemoveMenusGroupItems group_id item_inds NoCurMenu 
		= NoCurMenu
RemoveMenusGroupItems group_id item_inds (CurMenu menus cuts state system_id) 
		= (CurMenu menus` cuts` state system_id)
		  where
		  (menus`,cuts`) = RemoveMenusGroupItems` group_id item_inds menus cuts

RemoveMenusGroupItems` :: !MenuItemGroupId ![Int] ![MenuHandle s (IOState s)] ![ShortCut] -> (![MenuHandle s (IOState s)], ![ShortCut])
RemoveMenusGroupItems` group_id item_inds [menu : menus] cuts 
	| removed
		= ([menu` : menus], cuts`)
		= ([menu : menus`], cuts``)
		  where
		  (menus`,cuts``)       = RemoveMenusGroupItems` group_id item_inds menus cuts
		  (removed,menu`,cuts`) = RemoveMenuGroupItems` group_id item_inds menu cuts
RemoveMenusGroupItems` group_id item_inds no_menus cuts 
		= (no_menus, cuts)

RemoveMenuGroupItems`:: !MenuItemGroupId ![Int] !(MenuHandle s (IOState s)) ![ShortCut] -> (!Bool, !MenuHandle s (IOState s), ![ShortCut])
RemoveMenuGroupItems` group_id item_inds menu=:(PullDownHandle menuptr system_id menu_id title state items) cuts
	| removed
		= (True, (PullDownHandle menuptr system_id menu_id title state items`),cuts`)
		= (False,menu,cuts)
		  where
		  (removed,items`,cuts`) = RemoveFromMenuGroupItems group_id item_inds items cuts 1

RemoveFromMenuGroupItems:: !MenuItemGroupId ![Int] ![MenuItemHandle s (IOState s)] ![ShortCut] !Int -> (!Bool,![MenuItemHandle s (IOState s)], ![ShortCut])
RemoveFromMenuGroupItems group_id item_inds [item=:(ItemGroupHandle menuptr id items) : hs] cuts item_nr 
	| group_id == id
		= (True, [grouphandle : hs`],cuts`)  
		= (removed,[item:hs`],cuts``) 
		  where 
		  grouphandle          = ItemGroupHandle menuptr id items` 
		  (removed,hs`,cuts``) = RemoveFromMenuGroupItems group_id item_inds hs cuts item_nr` 
		  (_,items`,cuts`)     = RemoveGroupItems item_ids items cuts item_nr 
		  item_ids             = ItemIndicesToItemIds 1 item_inds items 
		  item_nr`             = item_nr + # items  
RemoveFromMenuGroupItems group_id item_inds [item=:(SubItemHandle menuptr system_id menu_id title state items) : hs] cuts item_nr
	| sub_removed
		= (True,[SubItemHandle menuptr system_id menu_id title state items` : hs], cuts`)
		= (removed,[item: hs`],cuts``)
		  where
		  (sub_removed,items`,cuts`) = RemoveFromMenuGroupItems group_id item_inds items cuts 1
		  (removed,hs`,cuts``)       = RemoveFromMenuGroupItems group_id item_inds hs cuts (inc item_nr)
RemoveFromMenuGroupItems group_id item_inds [no_item_group : hs] cuts item_nr
		= (removed,[no_item_group:hs`],cuts`)
		  where
		  (removed,hs`,cuts`) = RemoveFromMenuGroupItems group_id item_inds hs cuts (inc item_nr)
RemoveFromMenuGroupItems group_id item_inds done cuts item_nr
		= (False,done,cuts)

ItemIndicesToItemIds:: !Int ![Int] ![MenuItemHandle s (IOState s)] -> ![MenuItemId]
ItemIndicesToItemIds index indices [item : items]
	| contains 
		= let!
			id 
			ids
		  in [id : ids]
		= ids
		  where
		  (contains,indices`) = IdWasPresent indices index
		  (_,id)              = MenuHandle_MenuItemId item
		  ids                 = ItemIndicesToItemIds (inc index) indices` items
ItemIndicesToItemIds index indices no_items
		= []

IdWasPresent:: ![Int] !Int -> (!Bool,![Int])
IdWasPresent [id`:ids] id
	| id` == id
		= (True,ids)
		= (still_was,[id`:ids`])
		  where
		  (still_was,ids`) = IdWasPresent ids id
IdWasPresent ids id
		= (False, ids)

/* Press a RadioMenuItem. */
SelectMenuRadioItem :: !MenuItemId !(IOState s) -> IOState s
SelectMenuRadioItem id io_state
		= ChangeMenuItems io_state (SelectRadio id)

SelectRadio :: !Int !(MenuItemHandle s (IOState s)) -> MenuItemHandle s (IOState s)
SelectRadio id m=:(RadioItemsHandle myid id2 radios)
	| IsInRadioGroup id radios
		= let!
			(selid,radios`) = SelectRadios id myid radios
		  in RadioItemsHandle selid id radios`
		= m		  
SelectRadio id (SubItemHandle ptr myid id2 title state items)
		= let!
			items` = StrictMap (SelectRadio id) items
		  in SubItemHandle ptr myid id2 title state items`
SelectRadio id (ItemGroupHandle ptr id2 items)
		= let!
			items` = StrictMap (SelectRadio id) items
		  in ItemGroupHandle ptr id2 items`
SelectRadio id item
		= item 

IsInRadioGroup:: !Int ![MenuItemHandle s (IOState s)] -> Bool
IsInRadioGroup id [ItemHandle ptr myid id` t cut state f : radios]
	| id == id`
		= True
		= IsInRadioGroup id radios
IsInRadioGroup id radios
		= False

SelectRadios:: !Int !Int ![MenuItemHandle s (IOState s)] -> (Int, [MenuItemHandle s (IOState s)])
SelectRadios id selectedid [radio : radios]
	| selid == (-2)
		= let!
			radio` 
			radios`
			strict1
			strict2
		  in (selid`,[radio` : radios`])  // nothing happened
	| selid == (-1)
		= let!
			radio`
			radios`
			strict1
			strict2
		  in (selid`,[radio` : radios`])  // radio is deselected
		= let!
			radio`
			strict1
			strict3
		  in (selid, [radio` : radios``]) // radio is selected
		  where
		  (selid,radio`)   = strict1
		  (selid`,radios`) = strict2
		  (_,radios``)     = strict3
		  strict1          = SelectOrDeselectRadio id selectedid radio
		  strict2          = SelectRadios id selectedid radios
		  strict3          = SelectRadios (-1) selectedid radios
SelectRadios id selectedid radios
		= (-1, radios) 

SelectOrDeselectRadio:: !Int !Int !(MenuItemHandle s (IOState s)) -> (Int,MenuItemHandle s (IOState s))
SelectOrDeselectRadio id selectedid r=:(ItemHandle ptr myid id2 t cut state f)
	| id == id2 
		= let!
			ptr`` = OSMarkMenuItem ptr True
		  in (myid, ItemHandle ptr`` myid id2 t cut state f)
	| selectedid == myid 
		= let!
			ptr`  = OSMarkMenuItem ptr False
		  in (-1, ItemHandle ptr` myid id2 t cut state f)
		= (-2, r)

/*  Enabling and Disabling of MenuItems: */

EnableMenuItems:: ![MenuItemId] !(IOState state) -> IOState state
EnableMenuItems item_ids io_state
	=	ChangeShortCutsOfState Able item_ids io_state`
	where
		io_state` = ChangeMenuItems io_state (SetItemAbility item_ids Able)

DisableMenuItems:: ![MenuItemId] !(IOState state) -> IOState state
DisableMenuItems item_ids io_state
	=	ChangeShortCutsOfState Unable item_ids io_state`
	where
		io_state` = ChangeMenuItems io_state (SetItemAbility item_ids Unable)

SetItemAbility:: ![MenuItemId] SelectState !(MenuItemHandle s (IOState s)) -> MenuItemHandle s (IOState s)
SetItemAbility mids newstate m=:(ItemHandle ptr myid id title sc state fun)
	| isMember id mids
		= let!
			ptr` = SetAbility ptr state newstate
		  in ItemHandle ptr` myid id title sc newstate fun
		= m
SetItemAbility mids newstate m=:(CheckItemHandle ptr myid id title sc state mark fun)
	| isMember id mids
		= let!
			ptr` = SetAbility ptr state newstate
		  in CheckItemHandle ptr` myid id title sc newstate mark fun
		= m
SetItemAbility mids newstate m=:(SubItemHandle ptr myid id title state items)
	| isMember id mids
		= let!
			ptr` = SetAbility ptr state newstate
			items`
		  in SubItemHandle ptr` myid id title newstate items`
		= let!
			items`
		  in SubItemHandle ptr myid id title state items`
		  where
		  items` = StrictMap (SetItemAbility mids newstate) items
SetItemAbility misd newstate m=:(ItemGroupHandle ptr id items)
		= let!
			items` = StrictMap (SetItemAbility misd newstate) items
		  in ItemGroupHandle ptr id items`
SetItemAbility mids newstate m=:(RadioItemsHandle myid id ritems)
		= let!
			ritems` = StrictMap (SetItemAbility mids newstate) ritems
		  in RadioItemsHandle myid id ritems`
SetItemAbility mids newtitle m
		= m

/* Marking and Unmarking of MenuItems */
MarkMenuItems:: ![MenuItemId] !(IOState state) -> IOState state
MarkMenuItems [mid:mids] io_state
		= ChangeMenuItems (MarkMenuItems mids io_state) (SetItemMark mid Mark)
MarkMenuItems mids io_state
		= io_state

UnmarkMenuItems:: ![MenuItemId] !(IOState state) -> IOState state
UnmarkMenuItems [mid:mids] io_state
		= ChangeMenuItems (UnmarkMenuItems mids io_state) (SetItemMark mid NoMark)
UnmarkMenuItems mids io_state
		= io_state

SetItemMark:: !MenuItemId MarkState !(MenuItemHandle s (IOState s)) -> MenuItemHandle s (IOState s)
SetItemMark mid newmark m=:(CheckItemHandle ptr myid id title sc state mark fun)
	| mid == id
		= let!
			ptr` = OSMarkMenuItem ptr (IsMarkOn newmark)
		  in CheckItemHandle ptr` myid id title sc state newmark fun
		= m
SetItemMark mid newmark m=:(SubItemHandle ptr myid id title state items)
		= let!
			items` = StrictMap (SetItemMark mid newmark) items
		  in SubItemHandle ptr myid id title state items`
SetItemMark mid newmark m=:(ItemGroupHandle ptr id items)
		= let!
			items` = StrictMap (SetItemMark mid newmark) items
		  in ItemGroupHandle ptr id items`
SetItemMark mid newmark m=:(RadioItemsHandle myid id ritems)
		= let!
			ritems` = StrictMap (SetItemMark mid newmark) ritems
		  in RadioItemsHandle myid id ritems`
SetItemMark mid newmark m
		= m

IsMarkOn:: MarkState -> Bool
IsMarkOn Mark = True
IsMarkOn mark = False
		
/* Changing titles of MenuItems */

ChangeMenuItemTitles:: ![(MenuItemId, ItemTitle)] !(IOState s)-> IOState s
ChangeMenuItemTitles [(mid,title):mids] io_state
	=	ChangeMenuItemTitles mids io`
	where
		io` = ChangeMenuItems io_state (ChangeItemTitle mid title)
ChangeMenuItemTitles [] io_state
		= io_state

ChangeItemTitle:: !MenuItemId String !(MenuItemHandle s (IOState s)) -> MenuItemHandle s (IOState s)
ChangeItemTitle mid newtitle m=:(ItemHandle ptr myid id title sc state fun)
	| mid == id
		= let!
			ptr` = OSChangeMenuItemTitle ptr newtitle`
		  in ItemHandle ptr` myid id newtitle` sc state fun
		= m
	where
		  (_,newtitle`) = ValTitle sc myid id newtitle state []
ChangeItemTitle mid newtitle m=:(CheckItemHandle ptr myid id title sc state mark fun)
	| mid == id 
		= let!
			ptr` = OSChangeMenuItemTitle ptr newtitle`
			(_,newtitle`) = ValTitle sc myid id newtitle` state []
		  in CheckItemHandle ptr` myid id newtitle sc state mark fun
		= m
ChangeItemTitle mid newtitle m=:(SubItemHandle ptr myid id title state items)
	| mid == id
		= let!
			ptr` = OSChangeMenuItemTitle ptr newtitle
		  in SubItemHandle ptr` myid id newtitle state items
		= let!
			items` = StrictMap (ChangeItemTitle mid newtitle) items
		  in SubItemHandle ptr myid id title state items`
ChangeItemTitle mid newtitle m=:(ItemGroupHandle ptr id items)
		= let!
			items` = StrictMap (ChangeItemTitle mid newtitle) items
		  in ItemGroupHandle ptr id items`
ChangeItemTitle mid newtitle m=:(RadioItemsHandle myid id ritems)
		= let!
			ritems` = StrictMap (ChangeItemTitle mid newtitle) ritems
		  in RadioItemsHandle myid id ritems`
ChangeItemTitle mid newtitle m
		= m

/* changing menu functions*/

ChangeMenuItemFunctions:: ![(MenuItemId, MenuFunction s (IOState s))] !(IOState s)-> IOState s
ChangeMenuItemFunctions [(mid,function):mids] io_state
		= ChangeMenuItemFunctions mids io`
		  where
		  io` = ChangeMenuItems io_state (ChangeItemFunction mid function)
ChangeMenuItemFunctions [] io_state
		= io_state

ChangeItemFunction:: !MenuItemId (MenuFunction s (IOState s)) !(MenuItemHandle s (IOState s)) -> MenuItemHandle s (IOState s)
ChangeItemFunction mid newfun m=:(ItemHandle ptr myid id title sc state fun)
	| mid == id 
		= ItemHandle ptr myid id title sc state newfun
		= m
ChangeItemFunction mid newfun m=:(CheckItemHandle ptr myid id title sc state mark fun)
	| mid == id 
		= CheckItemHandle ptr myid id title sc state mark newfun
		= m
ChangeItemFunction mid newfun m=:(SubItemHandle ptr myid id title state items)
		= let!
			items` = StrictMap (ChangeItemFunction mid newfun) items
		  in SubItemHandle ptr myid id title state items`
ChangeItemFunction mid newfun m=:(ItemGroupHandle ptr id items)
		= let!
			items` = StrictMap (ChangeItemFunction mid newfun) items
		  in ItemGroupHandle ptr id items`
ChangeItemFunction mid newfun m=:(RadioItemsHandle myid id ritems)
		= let!
			ritems` = StrictMap (ChangeItemFunction mid newfun) ritems
		  in RadioItemsHandle myid id ritems`
ChangeItemFunction mid newfun m
		= m
