/*
 * Decompiled with CFR 0.152.
 */
package jme;

import java.util.LinkedList;
import java.util.Queue;
import jme.Evaluator;

public class Printer {
    Evaluator eval;
    private Queue queue = new LinkedList();
    private String stringval;
    boolean toplevelstring = true;

    public Printer(Evaluator eval) {
        this.eval = eval;
    }

    public void printRes() throws Exception {
        int type;
        int nrapp = 0;
        while ((type = this.getExpression()) == 0) {
            ++nrapp;
        }
        if (nrapp > 0) {
            System.out.print("(");
        }
        switch (type) {
            case 1: {
                System.out.print("" + this.getIntValue());
                break;
            }
            case 2: {
                System.out.print("" + this.getBoolValue());
                break;
            }
            case 3: {
                System.out.print("" + this.getCharValue());
                break;
            }
            case 5: {
                System.out.print(this.getStringValue());
                break;
            }
            case 4: {
                System.out.print("" + this.getFuncValue());
            }
        }
        for (int i = 0; i < nrapp; ++i) {
            System.out.print(" ");
            this.printRes();
        }
        if (nrapp > 0) {
            System.out.print(")");
        }
    }

    public String printRes2String() throws Exception {
        int type;
        int nrapp = 0;
        String res = "";
        while ((type = this.getExpression()) == 0) {
            ++nrapp;
        }
        if (nrapp > 0) {
            res = res + "(";
        }
        switch (type) {
            case 1: {
                res = res + this.getIntValue();
                break;
            }
            case 2: {
                res = res + this.getBoolValue();
                break;
            }
            case 3: {
                res = res + this.getCharValue();
                break;
            }
            case 5: {
                res = res + this.getStringValue();
                break;
            }
            case 4: {
                res = res + this.getFuncValue();
            }
        }
        for (int i = 0; i < nrapp; ++i) {
            res = res + " " + this.printRes2String();
        }
        if (nrapp > 0) {
            res = res + ")";
        }
        return res;
    }

    public String getNext() throws Exception {
        return this.eval.getNext();
    }

    public String getFuncValue() {
        this.toplevelstring = false;
        return this.eval.getFuncValue();
    }

    public int getIntValue() {
        this.toplevelstring = false;
        return this.eval.getIntValue();
    }

    public boolean getBoolValue() {
        this.toplevelstring = false;
        return this.eval.getBoolValue();
    }

    public String getCharValue() {
        this.toplevelstring = false;
        String res = this.quoteChar(this.eval.getCharValue());
        return res;
    }

    public String getStringValue() {
        if (!this.toplevelstring) {
            String res = this.quoteString(this.eval.getStringValue());
            return res;
        }
        this.toplevelstring = false;
        return this.eval.getStringValue();
    }

    public int getExpression() throws Exception {
        int type = this.eval.getExpression();
        switch (type) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        return -1;
    }

    public int getExpressionCharListIsString() throws Exception {
        int type;
        int nrapps = 0;
        if (!this.queue.isEmpty()) {
            if (((Bufval)this.queue.peek()).type == 0 && !((Bufval)this.queue.peek()).posstring) {
                return ((Bufval)this.queue.remove()).type;
            }
            if (((Bufval)this.queue.peek()).type == 0 && ((Bufval)this.queue.peek()).posstring) {
                ++nrapps;
            } else {
                return ((Bufval)this.queue.peek()).type;
            }
        }
        while ((type = this.eval.getExpression()) == 0) {
            this.queue.add(new Bufval(0));
            ++nrapps;
        }
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                if (nrapps == 2 && this.eval.getFuncValue().equals("cons")) {
                    type = this.eval.getExpression();
                    if (type == 3) {
                        this.stringval = this.getString();
                        this.toplevelstring = false;
                        nrapps = 0;
                        this.queue.clear();
                        return 5;
                    }
                    this.queue.add(new Bufval(4, "cons"));
                    switch (type) {
                        case 1: {
                            this.queue.add(new Bufval(type, this.eval.getIntValue()));
                            break;
                        }
                        case 2: {
                            this.queue.add(new Bufval(type, this.eval.getBoolValue()));
                            break;
                        }
                        case 4: {
                            this.queue.add(new Bufval(type, this.eval.getFuncValue()));
                            break;
                        }
                        case 0: {
                            this.queue.add(this.startApp());
                        }
                    }
                    this.toplevelstring = false;
                    this.queue.remove();
                    return 0;
                }
                if (nrapps == 0) {
                    return 4;
                }
                this.queue.add(new Bufval(4, this.eval.getFuncValue()));
                this.queue.remove();
                this.toplevelstring = false;
                return 0;
            }
        }
        return -1;
    }

    private void makeCharString(char c, StringBuffer buf) {
        if (this.toplevelstring) {
            buf.append(c);
        } else if (c == '\\') {
            buf.append("\\\\");
        } else if (c == '\"') {
            buf.append("\\\"");
        } else if (c == '\'') {
            buf.append("\\'");
        } else if (c == '\n') {
            buf.append("\\n");
        } else if (c == '\t') {
            buf.append("\\t");
        } else {
            buf.append(c);
        }
    }

    public String quoteString(String s) {
        StringBuffer buf = new StringBuffer();
        buf.append("\"");
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                buf.append("\\\\");
                continue;
            }
            if (c == '\"') {
                buf.append("\\\"");
                continue;
            }
            if (c == '\'') {
                buf.append("\\'");
                continue;
            }
            if (c == '\n') {
                buf.append("\\n");
                continue;
            }
            if (c == '\t') {
                buf.append("\\t");
                continue;
            }
            buf.append(c);
        }
        buf.append("\"");
        return buf.toString();
    }

    private String quoteChar(char c) {
        StringBuffer buf = new StringBuffer();
        buf.append("'");
        if (c == '\\') {
            buf.append("\\\\");
        } else if (c == '\"') {
            buf.append("\\\"");
        } else if (c == '\'') {
            buf.append("\\'");
        } else if (c == '\n') {
            buf.append("\\n");
        } else if (c == '\t') {
            buf.append("\\t");
        } else {
            buf.append(c);
        }
        buf.append("'");
        return buf.toString();
    }

    private String getString() throws Exception {
        StringBuffer buf = new StringBuffer();
        if (!this.toplevelstring) {
            buf.append("\"");
        }
        char c = this.eval.getCharValue();
        this.makeCharString(c, buf);
        boolean ready = false;
        while (!ready) {
            int type = this.eval.getExpression();
            boolean bl = ready = type == 4 && this.eval.getFuncValue().equals("nil");
            if (type != 3) continue;
            c = this.eval.getCharValue();
            this.makeCharString(c, buf);
        }
        if (!this.toplevelstring) {
            buf.append("\"");
        }
        return buf.toString();
    }

    private Bufval startApp() {
        Bufval res = new Bufval(0);
        res.posstring = true;
        return res;
    }

    class Bufval {
        int type;
        int intval;
        boolean posstring = false;
        String stringval;
        boolean boolval;

        Bufval(int type, int val) {
            this.type = type;
            this.intval = val;
        }

        Bufval(int type) {
            this.type = type;
        }

        Bufval(int type, boolean val) {
            this.type = type;
            this.boolval = val;
        }

        Bufval(int type, String val) {
            this.type = type;
            this.stringval = val;
        }
    }
}

