definition module EdInterrupt;

import EdProgramState;

/*	Starts an 'interruptable' function.
	1st arg.	The dialog id of the 'control dialog'. Closing this dialog 'terminates' the
				interruptable function. If the dialogid is -1 the function is non-interruptable.
	2nd arg.	The interruptable function. 'StartIntr' will start a timer which will cause the 
				interruptable function to be called once. The interruptable function must call
				'ContIntr' if it has not yet been completed its task, or 'StopIntr' when it has
				finished.
	3rd arg.	The program state.
	4th arg.	The io state.
*/
StartIntr :: !DialogId !CallBackFun !ProgState !IO -> ProgIO;

/*	Stops an 'interruptable' function. This function must be called when it wants to terminate.
	1st arg.	The program state.
	2nd arg.	The io state.
*/
StopIntr :: !ProgState !IO -> ProgIO;

/*	Continues an 'interruptable' function. This function is called by an 'interruptable' function to
	allow user interruption at this state of its processing.
	1st arg.	the continuation function
	2nd arg.	The program state.
	3rd arg.	The io state.
*/
ContIntr :: !CallBackFun !ProgState !IO -> ProgIO;
