definition module EdPath;

/* OS dependent operations on filenames */

from deltaIOSystem import :: Measure (MM, Inch, Pixel);

import EdTypes;     

EmptyPathname	:== "";

RemovePath :: !Pathname -> String;
RemoveSuffix :: !Pathname -> String;
RemoveFilename :: !Pathname -> Pathname;
IsDefPathname :: !Pathname -> Bool;
IsImpPathname :: !Pathname -> Bool;
IsPrjPathname :: !Pathname -> Bool;
IsFullPathname :: !Pathname -> Bool;
MakeDefPathname :: !String -> Pathname;
MakeImpPathname :: !String -> Pathname;
MakeABCPathname :: !String -> Pathname;
MakeObjPathname :: !Processor !String -> Pathname;
MakeMiraPathname :: !String -> Pathname;
MakeTextPathname :: !String -> Pathname;
MakeProjectPathname	:: !String -> Pathname;
MakeExecPathname :: !String -> Pathname;
MakeTempPathname :: !Pathname -> Pathname;
MakeABCSystemPathname :: !Pathname !*Files -> (!Pathname, !*Files);
MakeObjSystemPathname :: !Processor !Pathname !*Files -> (!Pathname, !*Files);
MakeFullPathname :: !Pathname !Modulename -> Pathname;
GetModuleName :: !Pathname -> Modulename;
MakeProjectDirName :: !Bool !String !String !String -> String;
MakeDefDirName :: !Bool !String !String -> String;
MatchProjectDirName :: !Bool !Pathname !String !String !(List Pathname) -> Pathname;
MatchDefDirName	:: !Bool !Pathname !String !(List Pathname) -> Pathname;
ListBoxWidth :: Measure;

replace_prefix_path	:: !Pathname !Pathname !Pathname -> Pathname;

DirSeparatorString:=="/";

