/*
 * Decompiled with CFR 0.152.
 */
package saplgraphics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JPanel;
import jme.ClientApplet;
import netscape.javascript.JSObject;
import saplgraphics.EncodeDecode;
import saplgraphics.Figure;
import saplgraphics.GraphLine;
import saplgraphics.GraphOval;
import saplgraphics.GraphPolyLine;
import saplgraphics.GraphRectangle;

public class DrawPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    JSObject jso;
    String content = "[]";
    String state;
    String callback;
    String appletname;
    int width;
    int height;
    boolean editable;
    String toSSapl;
    String fromSSapl;
    String eventwrap;
    JPanel btn_panel;
    ClientApplet sapl;
    static final int curve = 0;
    static final int line = 1;
    static final int oval = 2;
    static final int rectangle = 3;
    private List<Figure> curves;
    private Figure lastCurve;
    private Color color;
    private int kind;

    public DrawPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void setJSO(JSObject jso) {
        this.jso = jso;
    }

    void jbInit() throws Exception {
        this.setBackground(new Color(0, 153, 204));
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                DrawPanel.this.this_mouseDragged(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                DrawPanel.this.this_mousePressed(e);
            }

            public void mouseReleased(MouseEvent e) {
                DrawPanel.this.this_mouseUp(e);
            }
        });
        this.setLayout(this.borderLayout1);
        this.initialize();
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    public void initialize() {
        this.curves = new ArrayList<Figure>();
        this.color = Color.black;
        this.kind = 0;
    }

    public void paint(Graphics g) {
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.width, this.height);
        for (Figure p : this.curves) {
            p.Paint(g);
        }
    }

    void this_mousePressed(MouseEvent e) {
        String call;
        String result;
        if (this.editable && (result = this.sapl.evalExpression(call = this.eventwrap + " \"" + this.toSSapl + "\" \"" + this.fromSSapl + "\" \"" + this.callback + "\" \"" + this.state + "\" " + this.quoteString(this.content) + "\" " + "[MouseDown (" + e.getX() + "," + e.getY() + ")]\"")) != null) {
            this.setStateFigs(result);
        }
    }

    void this_mouseDragged(MouseEvent e) {
        String call;
        String result;
        if (this.editable && (result = this.sapl.evalExpression(call = this.eventwrap + " \"" + this.toSSapl + "\" \"" + this.fromSSapl + "\" \"" + this.callback + "\" \"" + this.state + "\"" + this.quoteString(this.content) + " \"" + "[MouseDrag (" + e.getX() + "," + e.getY() + ")]\"")) != null) {
            this.setStateFigs(result);
        }
    }

    void this_btnevent(ActionEvent e) {
        String call;
        String result;
        if (this.editable && (result = this.sapl.evalExpression(call = this.eventwrap + " \"" + this.toSSapl + "\" \"" + this.fromSSapl + "\" \"" + this.callback + "\" \"" + this.state + "\"" + this.quoteString(this.content) + " " + this.quoteString("[ButtonEvent \"" + e.getActionCommand() + "\"]"))) != null) {
            this.setStateFigs(result);
        }
    }

    void this_mouseUp(MouseEvent e) {
        block0: {
            if (!this.editable) break block0;
            String value = "GraphPicture \"" + this.toSSapl + "\" \"" + this.fromSSapl + "\" \"" + this.state + "\" \"" + this.callback + "\" \"" + this.appletname + "\" \"" + this.eventwrap + "\" " + this.width + " " + this.height + " " + this.content;
            this.jso.call("finishModal", this.appletname, EncodeDecode.encodeString(value));
        }
    }

    void setStateFigs(String input) {
        int separator = input.indexOf("@#@");
        this.state = input.substring(0, separator);
        this.content = input.substring(separator + 3);
        this.readFigs(this.content);
    }

    void readFigs(String input) {
        this.content = input;
        if (input.charAt(0) == '[') {
            input = input.substring(1, input.length() - 1);
        }
        this.curves = new ArrayList<Figure>();
        StringTokenizer stok = new StringTokenizer(input, " ,()\"");
        while (stok.hasMoreTokens()) {
            String tok = stok.nextToken();
            if (tok.equals("GraphLine")) {
                this.lastCurve = new GraphLine();
                this.lastCurve.addPoint(Integer.parseInt(stok.nextToken()), Integer.parseInt(stok.nextToken()));
                this.lastCurve.addPoint(Integer.parseInt(stok.nextToken()), Integer.parseInt(stok.nextToken()));
                this.curves.add(this.lastCurve);
                continue;
            }
            if (tok.equals("GraphPolyLine")) {
                this.lastCurve = new GraphPolyLine();
                stok.nextToken();
                while (!(tok = stok.nextToken()).equals("]")) {
                    this.lastCurve.addPoint(Integer.parseInt(tok), Integer.parseInt(stok.nextToken()));
                }
                this.curves.add(this.lastCurve);
                continue;
            }
            if (tok.equals("GraphRectangle")) {
                this.lastCurve = new GraphRectangle();
                this.lastCurve.addPoint(Integer.parseInt(stok.nextToken()), Integer.parseInt(stok.nextToken()));
                this.lastCurve.addPoint(Integer.parseInt(stok.nextToken()), Integer.parseInt(stok.nextToken()));
                this.curves.add(this.lastCurve);
                continue;
            }
            if (tok.equals("GraphOval")) {
                this.lastCurve = new GraphOval();
                this.lastCurve.addPoint(Integer.parseInt(stok.nextToken()), Integer.parseInt(stok.nextToken()));
                this.lastCurve.addPoint(Integer.parseInt(stok.nextToken()), Integer.parseInt(stok.nextToken()));
                this.curves.add(this.lastCurve);
                continue;
            }
            if (!tok.equals("GraphButton")) continue;
            String name = stok.nextToken();
            Component[] cmps = this.btn_panel.getComponents();
            boolean found = false;
            for (int i = 0; i < cmps.length && !found; ++i) {
                found = ((JButton)cmps[i]).getText().equals(name);
            }
            if (found) continue;
            JButton btn = new JButton(name);
            this.btn_panel.add(btn);
            btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DrawPanel.this.this_btnevent(e);
                }
            });
        }
        this.repaint();
    }

    public String quoteString(String s) {
        StringBuffer buf = new StringBuffer();
        buf.append("\"");
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                buf.append("\\\\");
                continue;
            }
            if (c == '\"') {
                buf.append("\\\"");
                continue;
            }
            if (c == '\'') {
                buf.append("\\'");
                continue;
            }
            if (c == '\n') {
                buf.append("\\n");
                continue;
            }
            if (c == '\r') {
                buf.append("\\r");
                continue;
            }
            if (c == '\t') {
                buf.append("\\t");
                continue;
            }
            buf.append(c);
        }
        buf.append("\"");
        return buf.toString();
    }
}

