/*
 * Decompiled with CFR 0.152.
 */
package jme;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import jme.Token;

public class Tokenizer {
    int stop = -1;
    Token tokentype;
    int tokenchar;
    StringBuffer tokenbuf = new StringBuffer();
    int tokenval;
    int current_string = 0;
    String tokenstring;
    BufferedReader in;
    int indent;
    int previndent;
    int line;
    int nlkar = 10;

    void readFile(String name) throws Exception {
        this.line = 0;
        this.indent = 0;
        FileInputStream f = new FileInputStream(name);
        InputStreamReader isr = new InputStreamReader(f);
        this.in = new BufferedReader(isr);
        this.nlkar = 10;
    }

    void readInputStream(InputStream name) throws Exception {
        this.line = 0;
        this.indent = 0;
        InputStreamReader isr = new InputStreamReader(name);
        this.in = new BufferedReader(isr);
        this.nlkar = 10;
    }

    void readString(String input) {
        this.line = 0;
        this.indent = 0;
        StringReader sr = new StringReader(input);
        this.in = new BufferedReader(sr);
        this.nlkar = 10;
    }

    boolean skipspace(BufferedReader in) throws Exception {
        int ch;
        boolean isblank = false;
        in.mark(100);
        while ((ch = in.read()) == 32 || ch == 9 || ch == 13) {
            isblank = true;
            in.mark(100);
        }
        in.reset();
        return isblank;
    }

    boolean isspace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    boolean isDelim(int ch) {
        return ch == 40 || ch == 41 || ch == 91 || ch == 93 || ch == 44 || ch == 59 || ch == 34 || ch == 10;
    }

    int getkar(BufferedReader in) throws Exception {
        in.mark(10);
        int c = in.read();
        if (c == this.nlkar) {
            ++this.line;
            this.previndent = this.indent;
            this.indent = 0;
        } else {
            ++this.indent;
        }
        return c;
    }

    void ungetkar(BufferedReader in, int c) throws Exception {
        if (c == this.nlkar) {
            --this.line;
            this.indent = this.previndent;
        } else {
            --this.indent;
        }
        in.reset();
    }

    void readDelim(BufferedReader in) throws Exception {
        int c = this.getkar(in);
        switch (c) {
            case 40: {
                this.tokentype = Token.Lpar;
                break;
            }
            case 41: {
                this.tokentype = Token.Rpar;
                break;
            }
            case 10: {
                this.tokentype = Token.NewLine;
                break;
            }
            default: {
                this.perror("unexpected token");
            }
        }
    }

    void readChar(BufferedReader in) throws Exception {
        this.getkar(in);
        int c = this.getkar(in);
        if (c == 92) {
            c = this.getkar(in);
            switch (c) {
                case 110: {
                    c = 10;
                    break;
                }
                case 114: {
                    c = 13;
                    break;
                }
                case 116: {
                    c = 9;
                    break;
                }
                case 92: {
                    c = 92;
                    break;
                }
                case 34: {
                    c = 34;
                    break;
                }
                case 39: {
                    c = 39;
                    break;
                }
                default: {
                    if (!this.isNum(c)) break;
                    int n = c - 48;
                    c = this.getkar(in);
                    n = 8 * n + c - 48;
                    c = this.getkar(in);
                    c = 8 * n + c - 48;
                }
            }
        }
        this.tokenchar = c;
        this.tokentype = Token.Char;
        c = this.getkar(in);
        if (c != 39) {
            this.perror("' expected");
        }
    }

    void readString(BufferedReader in) throws Exception {
        int c;
        this.getkar(in);
        while ((c = this.getkar(in)) != 34) {
            if (c == this.stop) {
                this.perror("non terminated string");
            }
            if (c == 10) {
                this.perror("\" expected");
                continue;
            }
            if (c == 92) {
                c = this.getkar(in);
                switch (c) {
                    case 110: {
                        this.tokenbuf.append('\n');
                        break;
                    }
                    case 114: {
                        this.tokenbuf.append('\r');
                        break;
                    }
                    case 116: {
                        this.tokenbuf.append('\t');
                        break;
                    }
                    case 92: {
                        this.tokenbuf.append('\\');
                        break;
                    }
                    case 34: {
                        this.tokenbuf.append('\"');
                        break;
                    }
                    case 39: {
                        this.tokenbuf.append('\'');
                    }
                }
                continue;
            }
            this.tokenbuf.append((char)c);
        }
        this.tokentype = Token.String;
        this.tokenstring = new String(this.tokenbuf);
        this.tokenbuf = new StringBuffer();
    }

    boolean isCharNum(int i) {
        return i >= 48 && i <= 57 || i >= 65 && i <= 90 || i >= 97 && i <= 122 || i == 95;
    }

    boolean isIdenChar(int i) {
        return i != 34 && i != 40 && i != 41 && i != 32 && i != 9 && i != 10 && i != 92 && i != 124 && i != 39;
    }

    boolean isChar(int i) {
        return i >= 65 && i <= 90 || i >= 97 && i <= 122;
    }

    boolean isNum(int i) {
        return i == 45 || i >= 48 && i <= 57;
    }

    void readIden(BufferedReader in) throws Exception {
        int c;
        int t = 0;
        while (this.isCharNum(c = this.getkar(in))) {
            this.tokenbuf.append((char)c);
            ++t;
        }
        this.ungetkar(in, c);
        this.tokentype = Token.Iden;
        this.tokenstring = new String(this.tokenbuf);
        this.tokenbuf = new StringBuffer();
    }

    void readDIden(BufferedReader in) throws Exception {
        int c = this.getkar(in);
        if (c != 123) {
            this.perror("{ expected");
        }
        this.tokenbuf.append("<{");
        while (true) {
            if ((c = this.getkar(in)) == 125) {
                c = this.getkar(in);
                if (c == 62) {
                    this.tokenbuf.append("}>");
                    this.tokentype = Token.Iden;
                    this.tokenstring = new String(this.tokenbuf);
                    this.tokenbuf = new StringBuffer();
                    return;
                }
                this.ungetkar(in, c);
                this.tokenbuf.append("}");
                continue;
            }
            this.tokenbuf.append((char)c);
        }
    }

    void readNum(BufferedReader in) throws Exception {
        int res = 0;
        int c = this.getkar(in);
        boolean neg = false;
        if (c == 45) {
            neg = true;
        } else {
            res = c - 48;
        }
        while (this.isNum(c = this.getkar(in))) {
            res = 10 * res + c - 48;
        }
        this.ungetkar(in, c);
        this.tokenval = neg ? -res : res;
        this.tokentype = Token.Num;
    }

    void gettoken() throws Exception {
        this.skipspace(this.in);
        int ch = this.getkar(this.in);
        while (ch == 124) {
            ch = this.getkar(this.in);
            if (ch == 124) {
                while ((ch = this.getkar(this.in)) != this.nlkar) {
                }
                this.skipspace(this.in);
                continue;
            }
            this.ungetkar(this.in, ch);
        }
        if (ch == this.stop) {
            this.tokentype = Token.Eof;
            this.in.close();
            return;
        }
        if (ch == 61) {
            this.tokentype = Token.Eq;
            return;
        }
        if (ch == 44) {
            this.tokentype = Token.Comma;
            return;
        }
        if (ch == 60) {
            this.readDIden(this.in);
            return;
        }
        if (this.isNum(ch)) {
            this.ungetkar(this.in, ch);
            this.readNum(this.in);
        } else if (this.isChar(ch) || ch == 95) {
            this.ungetkar(this.in, ch);
            this.readIden(this.in);
        } else if (ch == 39) {
            this.ungetkar(this.in, ch);
            this.readChar(this.in);
        } else if (ch == 34) {
            this.ungetkar(this.in, ch);
            this.readString(this.in);
        } else if (ch == 92) {
            this.tokentype = Token.Local;
        } else if (ch == this.nlkar) {
            if (this.skipspace(this.in)) {
                this.gettoken();
            } else {
                this.tokentype = Token.NewLine;
            }
        } else if (ch == 37) {
            this.readNum(this.in);
            this.tokentype = Token.AnVar;
        } else if (this.isDelim(ch)) {
            this.ungetkar(this.in, ch);
            this.readDelim(this.in);
        } else {
            this.perror("unexpected token");
            return;
        }
    }

    public static void test(String[] args) {
    }

    void perror(String string) throws Exception {
        throw new Exception("parse error: " + string + " at line : " + (this.line + 1) + " column:" + (this.indent + 1));
    }
}

