/*
 * Decompiled with CFR 0.152.
 */
package jme;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import jme.Interpreter;

public class Main {
    static String prog = "||test\nmain = add 5 6\n\nfac n = if (eq n 0) 1 (mult n (fac (sub n 1)))\n";

    public static void main(String[] args) {
        Main.interactive(args);
    }

    private static void interactive(String[] args) {
        int memsize = 1000000;
        int stacksize = 170000;
        String filename = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-help")) {
                System.out.printf("Usage sapl [-hsize] [-ssize] filename\nsize in memory Cells\n", new Object[0]);
                continue;
            }
            if (args[i].startsWith("-h")) {
                memsize = Integer.parseInt(args[i].substring(2));
                continue;
            }
            if (args[i].startsWith("-s")) {
                stacksize = Integer.parseInt(args[i].substring(2));
                continue;
            }
            filename = args[i];
        }
        System.out.printf("Sapl Interpreter in Java 2007\n", new Object[0]);
        Interpreter inter = new Interpreter(memsize, stacksize, 7000);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        if (filename != null) {
            Main.loadFile(filename, inter, true);
        }
        inter.eval.modname = filename.substring(0, filename.indexOf("."));
        boolean stop = false;
        inter.setInput("dit is de test input");
        while (!stop) {
            System.out.printf("\nSapl> ", new Object[0]);
            try {
                String line = in.readLine();
                if (line.equals("quit")) break;
                if (line.startsWith(":load")) {
                    Main.loadFile(line.substring(6), inter, true);
                    continue;
                }
                Main.evalExpr(line, inter, false);
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
            }
        }
        if (inter.getOutput() != null) {
            System.out.println("the output is: " + inter.getOutput());
        }
    }

    private static void doBenchmarks() {
        Interpreter inter = new Interpreter(2000000, 100000, 1000);
        Main.loadFile("primes.cfp", inter, false);
        Main.evalExpr("el 5000 primes", inter, true);
        Main.loadFile("sprimes.cfp", inter, false);
        Main.evalExpr("domain h20", inter, true);
        Main.loadFile("eval.cfp", inter, false);
        Main.evalExpr("main 100", inter, true);
        Main.loadFile("benchmarks.cfp", inter, false);
        Main.evalExpr("fib 35", inter, true);
        Main.evalExpr("match 2000", inter, true);
        Main.evalExpr("rephamming 4000 1000", inter, true);
        Main.evalExpr("reptwice 400", inter, true);
        Main.evalExpr("queens 11", inter, true);
        Main.evalExpr("hd1 (knights 5)", inter, true);
        Main.loadFile("sort.cfp", inter, false);
        Main.evalExpr("allsort", inter, true);
        Main.loadFile("parselibnew.cfp", inter, false);
        Main.evalExpr("parsetest 10", inter, true);
        Main.evalExpr("msol 500", inter, true);
    }

    private static void loadFile(String fname, Interpreter inter, boolean feedback) {
        try {
            inter.setFile(fname);
            if (feedback) {
                System.out.println("File " + fname + " correctly loaded");
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    static void printEvalExpression(Interpreter interpreter) {
        try {
            int type;
            while ((type = interpreter.printer.getExpression()) != -1) {
                System.out.print(" " + Interpreter.typeNames[type]);
                switch (type) {
                    case 1: {
                        System.out.print(" " + interpreter.printer.getIntValue());
                        break;
                    }
                    case 2: {
                        System.out.print(" " + interpreter.printer.getBoolValue());
                        break;
                    }
                    case 3: {
                        System.out.print(" " + interpreter.printer.getCharValue());
                        break;
                    }
                    case 5: {
                        System.out.print(" " + interpreter.printer.getStringValue());
                        break;
                    }
                    case 4: {
                        System.out.print(" " + interpreter.printer.getFuncValue());
                    }
                }
                System.out.flush();
            }
        }
        catch (Exception ex) {
            interpreter.eval.reset();
            if (ex.getMessage().startsWith("ABORT")) {
                System.out.print(ex.getMessage());
            }
            ex.printStackTrace();
        }
    }

    static void printRes(Interpreter interpreter) throws Exception {
        int type;
        int nrapp = 0;
        while ((type = interpreter.printer.getExpression()) == 0) {
            ++nrapp;
        }
        if (nrapp > 0) {
            System.out.print("(");
        }
        switch (type) {
            case 1: {
                System.out.print("" + interpreter.printer.getIntValue());
                break;
            }
            case 2: {
                System.out.print("" + interpreter.printer.getBoolValue());
                break;
            }
            case 3: {
                System.out.print("" + interpreter.printer.getCharValue());
                break;
            }
            case 5: {
                System.out.print("" + interpreter.printer.getStringValue());
                break;
            }
            case 4: {
                System.out.print("" + interpreter.printer.getFuncValue());
            }
        }
        for (int i = 0; i < nrapp; ++i) {
            System.out.print(" ");
            Main.printRes(interpreter);
        }
        if (nrapp > 0) {
            System.out.print(")");
        }
    }

    static void printEvalString(Interpreter inter) {
        try {
            Main.printRes(inter);
        }
        catch (Exception ex) {
            inter.eval.reset();
            if (ex.getMessage().startsWith("ABORT")) {
                System.out.print(ex.getMessage());
            }
            ex.printStackTrace();
        }
    }

    private static void evalExpr(String expr, Interpreter inter, boolean echo) {
        int p = -1;
        try {
            if (echo) {
                System.out.println(expr);
            }
            inter.setExpression(expr);
            long t1 = System.currentTimeMillis();
            Main.printEvalString(inter);
            long t2 = System.currentTimeMillis();
            long t3 = t2 - t1;
            System.out.println("\nTime = " + t3 / 1000L + "." + t3 / 100L % 10L + " s");
            inter.eval.printmemstats();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }
}

