/*
 * Decompiled with CFR 0.152.
 */
package jme;

import java.io.InputStream;
import jme.Evaluator;
import jme.Parse;
import jme.Printer;

public class Interpreter {
    Evaluator eval;
    private Parse parser;
    public Printer printer;
    public Printer debugprinter;
    public static final int APP = 0;
    public static final int NUM = 1;
    public static final int BOOL = 2;
    public static final int CHAR = 3;
    public static final int FUNC = 4;
    public static final int STRING = 5;
    public static final String[] typeNames = new String[]{"APP", "NUM", "BOOL", "CHAR", "FUNC", "STRING"};

    public Interpreter(int memsize, int stacksize, int maxnrfuncs) {
        this.eval = new Evaluator(memsize, stacksize, maxnrfuncs);
        this.parser = new Parse(this.eval);
        this.printer = new Printer(this.eval);
        this.debugprinter = new Printer(this.eval);
        this.debugprinter.toplevelstring = false;
        this.eval.parser = this.parser;
        this.eval.printer = this.debugprinter;
    }

    public void setFunctions(String functions) throws Exception {
        this.parser.readfuncsfromstring(functions);
    }

    public void setFile(String filename) throws Exception {
        this.parser.readfuncs(filename);
    }

    public void setInputStream(InputStream stream) throws Exception {
        this.parser.readInputStream(stream);
    }

    public void setExpression(String expr) throws Exception {
        this.reset();
        int p = this.parser.readExpression(expr);
        this.eval.pushs(p);
        this.printer.toplevelstring = true;
    }

    public void setInput(String inp) {
        this.eval.input = inp;
    }

    public String getOutput() {
        return this.eval.output;
    }

    public void reset() {
        this.eval.reset();
    }
}

