/*
 * Decompiled with CFR 0.152.
 */
package sapllinker;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import sapllinker.Depends;
import sapllinker.Deps;
import sapllinker.Module;

public class Main {
    Map<String, List<String>> modfuncs = new HashMap<String, List<String>>();
    List<String> unknownFuncs = new ArrayList<String>();
    Map<String, Module> modules = new HashMap<String, Module>();
    String current_module;
    String mainmod = null;
    List<String> unknownmodules = new ArrayList<String>();
    String[] stdenvfiles = new File(this.DIR_STDENV).list();
    String[] saplfiles = new File(this.DIR_SAPLFILES).list();
    String startfunc;
    long modtime = 0L;
    long starttime;
    String DIR_STDENV = "../stdenv";
    String DIR_SAPLFILES = "../saplfiles";
    static final String consnil = "cons a as f g = f a as\nnil f g       = g\nerror a b c d e f g = a\nnomatch a b c d e f g = a\nfst t = select t (\\x y = x)\nsnd t = select t (\\x y = y)\n_predefined__Tuple1 a1 f1 = f1 a1\nStdGeneric__GenericDict a1 f = f  a1\n";

    boolean putFunction(String module, String function) {
        List<String> funclist = this.modfuncs.get(module);
        if (funclist == null) {
            funclist = new ArrayList<String>();
            funclist.add(function);
            this.modfuncs.put(module, funclist);
            return true;
        }
        if (!funclist.contains(function)) {
            funclist.add(function);
            return true;
        }
        return false;
    }

    boolean isModuleName(String modname) {
        int i;
        for (i = 0; i < this.stdenvfiles.length; ++i) {
            if (!this.stdenvfiles[i].equals(modname + ".gfp")) continue;
            return true;
        }
        for (i = 0; i < this.saplfiles.length; ++i) {
            if (!this.saplfiles[i].equals(modname + ".gfp")) continue;
            return true;
        }
        return false;
    }

    String getFileDirectory(String filename) {
        int i;
        for (i = 0; i < this.stdenvfiles.length; ++i) {
            if (!this.stdenvfiles[i].equals(filename)) continue;
            return this.DIR_STDENV + "/" + filename;
        }
        for (i = 0; i < this.saplfiles.length; ++i) {
            if (!this.saplfiles[i].equals(filename)) continue;
            return this.DIR_SAPLFILES + "/" + filename;
        }
        return "";
    }

    String getModName(String modfunc) {
        int start = 0;
        if (modfunc.startsWith("<{")) {
            start = 2;
        }
        int ind = start;
        String modname = null;
        do {
            if ((ind = modfunc.indexOf(95, 2 + ind)) >= 0) continue;
            if (modname != null) {
                System.out.println("Module " + modname + " not found");
                this.unknownmodules.add(modname);
            }
            return null;
        } while (!this.isModuleName(modname = modfunc.substring(start, ind)));
        return modname;
    }

    boolean putFunction(String func) {
        this.current_module = this.getModName(func);
        if (this.current_module == null) {
            return false;
        }
        return this.putFunction(this.current_module, func);
    }

    String showModFuncs() {
        String result = "";
        Set<String> keys = this.modfuncs.keySet();
        for (String elem : keys) {
            List<String> funcs = this.modfuncs.get(elem);
            result = result + elem;
            for (String func : funcs) {
                result = result + " " + func;
            }
            result = result + "\n";
        }
        return result;
    }

    public static void main(String[] args) {
        Main main = new Main();
        main.start(args);
    }

    void writeLog(String mainmod) throws Exception {
        System.out.println("Writing log...");
        FileOutputStream out = new FileOutputStream(this.DIR_SAPLFILES + "/" + mainmod + ".log");
        BufferedWriter str = new BufferedWriter(new OutputStreamWriter(out));
        this.unknownFuncs = Main.removeDup(this.unknownFuncs);
        this.unknownmodules = Main.removeDup(this.unknownmodules);
        str.write("Log of " + mainmod + "\n");
        str.write("Unknown Functions: " + this.unknownFuncs + "\nUnknown Modules: " + this.unknownmodules + "\n" + this.showModFuncs());
        str.flush();
        str.close();
        out.close();
    }

    void start(String[] args) {
        this.starttime = System.currentTimeMillis();
        try {
            if (args[0].equals("-sl")) {
                System.out.println("Doing smartlink for " + args[1]);
                this.smartLink(args[1]);
            } else {
                ArrayList<String> start = new ArrayList<String>();
                System.out.println("Started");
                this.mainmod = args[0];
                this.startfunc = this.findStartFunc(this.mainmod);
                System.out.println("startfunc = " + this.startfunc + "\n" + "Checking dependencies...");
                start.add(this.startfunc);
                this.getAllDepends(start);
                System.out.println("Linking...");
                this.genSAPLFuncs(this.mainmod);
                System.out.println("Finished");
                long linktime = System.currentTimeMillis() - this.starttime;
                System.out.println("Total time " + linktime / 1000L + "." + linktime / 100L % 10L + " s");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    String findStartFunc(String mainmod) {
        try {
            String line;
            BufferedReader in = this.openModule(mainmod);
            String first = null;
            while ((line = in.readLine()) != null) {
                first = this.getFirstToken(line);
                if (first == null || first.indexOf("Start") <= 0) continue;
                return first;
            }
            in.close();
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    void getAllDepends(List<String> funcnames) {
        LinkedList<String> tobedone = new LinkedList<String>(funcnames);
        HashSet<String> handled = new HashSet<String>();
        handled.add("sapldebug_sapldebug");
        handled.add("graph_to_sapl_string_graph_to_sapl_string");
        handled.add("graph_to_sapl_string_string_to_graph");
        while (!tobedone.isEmpty()) {
            String elem = (String)tobedone.remove();
            handled.add(elem);
            if (!this.putFunction(elem)) continue;
            String[] deps = this.getDepends(elem);
            if (deps != null) {
                for (int i = 0; i < deps.length; ++i) {
                    if (handled.contains(deps[i])) continue;
                    tobedone.add(deps[i]);
                }
                continue;
            }
            this.unknownFuncs.add(elem);
        }
    }

    String[] getDepends(String modfunc) {
        try {
            Module module = null;
            module = this.modules.get(this.current_module);
            if (module == null) {
                module = this.readModule(this.current_module);
                this.modules.put(this.current_module, module);
            }
            return module.depends.getDepends(modfunc);
        }
        catch (Exception ex) {
            System.out.println("Module " + this.current_module + " not found");
            ex.printStackTrace();
            this.unknownFuncs.add(modfunc);
            this.unknownmodules.add(this.current_module);
            return null;
        }
    }

    static List<String> removeDup(List<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (String elem : list) {
            if (Main.elemof(result, elem)) continue;
            result.add(elem);
        }
        return result;
    }

    Module readModule(String modname) throws Exception {
        long time = System.currentTimeMillis();
        String totname = this.getFileDirectory(modname + ".deps");
        File depsfile = new File(totname);
        FileInputStream f = new FileInputStream(depsfile);
        ArrayList<Deps> depends = new ArrayList<Deps>();
        InputStreamReader isr = new InputStreamReader(f);
        BufferedReader in = new BufferedReader(isr);
        String line = in.readLine();
        while ((line = in.readLine()) != null) {
            StringTokenizer stk = new StringTokenizer(line);
            String name = stk.nextToken();
            ArrayList<String> deps = new ArrayList<String>();
            while (stk.hasMoreTokens()) {
                deps.add(stk.nextToken());
            }
            depends.add(new Deps(name, deps));
        }
        f.close();
        this.modtime += System.currentTimeMillis() - time;
        Module result = new Module(modname, new Depends(modname, depends));
        return result;
    }

    BufferedWriter openSAPLFile(String modname) throws Exception {
        FileOutputStream out = new FileOutputStream(modname + ".sapl");
        return new BufferedWriter(new OutputStreamWriter(out));
    }

    BufferedReader openModule(String modname) throws Exception {
        FileInputStream f = new FileInputStream(this.getFileDirectory(modname + ".gfp"));
        InputStreamReader isr = new InputStreamReader(f);
        return new BufferedReader(isr);
    }

    BufferedReader openFile(String filename) throws Exception {
        FileInputStream f = new FileInputStream(filename);
        InputStreamReader isr = new InputStreamReader(f);
        return new BufferedReader(isr);
    }

    void genSAPLFuncs(String modname) throws Exception {
        BufferedWriter out = this.openSAPLFile(modname);
        out.write("|| Generated SAPL file " + modname + ".sapl\n");
        out.write("start = " + this.startfunc + "\n");
        out.write(consnil);
        out.write("iDataSettings_ThisExe = \"" + modname + "\"\n");
        Set<String> all = this.modfuncs.keySet();
        for (String elem : all) {
            List<String> depends = this.modfuncs.get(elem);
            try {
                String line;
                BufferedReader in = this.openModule(elem);
                String first = null;
                while ((line = in.readLine()) != null) {
                    String newfirst;
                    first = this.getFirstToken(line);
                    if (first != null && depends.contains(first)) {
                        out.write(line + "\n");
                        continue;
                    }
                    if (first == null || !first.contains("TD;") || !depends.contains(newfirst = Main.removeTD(first))) continue;
                    line = line.replace(first, newfirst);
                    out.write(line + "\n");
                }
                in.close();
            }
            catch (Exception ex) {
                System.out.println("No module " + elem);
            }
        }
        out.write("iDataSettings_ThisExe = \"" + modname + "\"\n");
        for (String func : this.unknownFuncs) {
            out.write(func + " = error \"unknown function\"\n");
        }
        out.close();
    }

    void smartLink(String modname) throws Exception {
        String funcname;
        String line;
        BufferedWriter out = this.openSAPLFile(modname + "_sl");
        out.write("|| Generated SAPL file using smartlink " + modname + "_sl.sapl\n");
        BufferedReader fnames = this.openFile(modname + ".funcs");
        ArrayList<String> funcnames = new ArrayList<String>();
        while ((line = fnames.readLine()) != null && (funcname = this.getFirstToken(line)) != null) {
            funcnames.add(funcname);
        }
        BufferedReader mainmod = this.openFile(modname + ".sapl");
        String first = null;
        while ((line = mainmod.readLine()) != null) {
            first = this.getFirstToken(line);
            if (first == null || !Main.elemof(funcnames, first)) continue;
            out.write(line + "\n");
        }
        fnames.close();
        mainmod.close();
        out.flush();
        out.close();
    }

    String getFirstToken(String s) {
        if (s.equals("")) {
            return null;
        }
        StringTokenizer stk = new StringTokenizer(s);
        return stk.nextToken();
    }

    private static boolean elemof(List<String> list2, String elem) {
        for (String el : list2) {
            if (!el.equals(elem)) continue;
            return true;
        }
        return false;
    }

    private static boolean elemofnr(List<String> list2, String elem) {
        for (String el : list2) {
            if (!Main.equalnamenr(el, elem)) continue;
            return true;
        }
        return false;
    }

    private static String removeTD(String name) {
        if (name.contains("TD;")) {
            String newname = name.replace("TD;", "");
            if (newname.startsWith("<{")) {
                String altername = newname.substring(2, newname.length() - 2);
                boolean asciname = true;
                for (int i = 0; asciname && i < altername.length(); ++i) {
                    char c = altername.charAt(i);
                    asciname = Character.isLetterOrDigit(c) || c == '_';
                }
                if (asciname) {
                    newname = altername;
                }
            }
            return newname;
        }
        return name;
    }

    private static boolean endsWithNum(String name) {
        int index = name.lastIndexOf(95);
        boolean ok = true;
        int i = index + 1;
        while (ok && i < name.length()) {
            ok = Character.isDigit(name.charAt(i++));
        }
        return ok;
    }

    private List<String> remdups(List<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (String el : list) {
            if (Main.elemof(result, el)) continue;
            result.add(el);
        }
        return result;
    }

    static boolean equalnamenr(String s1, String s2) {
        if (s1.equals(s2)) {
            return true;
        }
        int fnr1 = Main.getFuncNr(s1);
        int fnr2 = Main.getFuncNr(s2);
        return fnr1 != -1 && fnr2 != -1 && fnr1 == fnr2;
    }

    static int getFuncNr(String funcname) {
        int ind = funcname.lastIndexOf(95);
        if (ind < 0) {
            return -1;
        }
        String fnr = funcname.substring(ind);
        try {
            if (fnr.endsWith("}>")) {
                fnr = fnr.substring(0, fnr.length() - 2);
            }
            int nr = Integer.parseInt(fnr);
            return nr;
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }
}

