definition module LibraryInstance;

from StdMaybe import :: Maybe;
from NamesTable import :: NamesTable, :: SNamesTable, :: NamesTableElement;
from pdSymbolTable import ::LibraryList;

:: *LibraryInstance 
	= {
		li_id				:: !String
	,	li_library_name		:: !Maybe String				// file name of library
	,	li_type_table_i		:: !Int							// index in cs_type_tables	
	,	li_s_type_available	:: !Int							// size of array below
	,	li_type_available	:: !*{#Bool}					// index in type implementation table True = made available, False = not available valid for chosen types from current library instance
	,	li_names_table		:: !*NamesTable					// names table
	,	li_library_list		:: !LibraryList
	,	li_library_initialized	:: !Bool					// names table is non-empty, marked_bool_a, marked_offset_a, etc. are adapted which is reflected in app_linker_state (DLClientState)
	,	li_have_internal_type_equivalent_class_been_fixed :: !Bool 	
	,	li_dynamic_index	:: !Maybe Int					// index in cs_dynamic_info
	,	li_memory_areas		:: [MemoryArea]
	};
	
:: MemoryArea
	= {
		ma_begin			:: !Int
	,	ma_end				:: !Int
	};
	
default_library_instance :: *LibraryInstance;
		
:: *LibraryInstances
	= { 
		lis_n_library_instances		:: !Int
	,	lis_library_instances		:: !*{#*LibraryInstance}
	,	lis_all_libraries :: !Libraries
	};

::	Libraries = Libraries !LibraryList !Libraries | EmptyLibraries;

default_library_instances :: *LibraryInstances;
	
class Library_Instances a
where {
	AddLibraryInstance :: !(Maybe Int) !String !Int !*a -> (!Int,!*a)
};
	
instance Library_Instances LibraryInstances;