definition module EdProgramState;

/*	Access functions on the programstate */

import StdFile;

import EdTypes, EdConstants, EdProject;

// import InterpreterState;

//	The IOState and program state
::	* ProgIO		:== (!ProgState,!IO);
::	* IO			:==	IOState ProgState;
::	* ProgState		= {editor :: !Editor};
::	CallBackFun		:== Bool -> ProgState -> * (IO -> ProgIO);

//	The local program state
::	 Editor		= 	{
						defaults	:: !Defaults,
						startupinfo	:: !StartupInfo,
						clipboard	:: !Clipboard,
						findinfo	:: !FindInfo,
						findidinfo	:: !FindIdentInfo,
						editwdids	:: !EditWdIds,
						editwindows	:: !EditWindows,
						execwdid	:: !ExecWdId,
						project		:: !Project,
						callback	:: !CallBackFun
					};

::	StartupInfo =	{
						startupdir	:: !Pathname,
      // RWS +++ move to platform dependent module 
						linker_file_name :: !String,
						linker_begin_object_files :: ![String],
						linker_libraries :: ![String],
						linker_end_object_files :: ![String],
						assembler_file_name :: !String
					};

//	The initial call back function

InitCallBack :: !Bool !ProgState !IO -> ProgIO;

InitEditor :: !{#Char} !*Files -> (!Editor,!*Files);

//	Window (id) operations

GetUsedWdIds :: !EditWindows -> List EditWdId;
GetUsedWindows :: !EditWindows -> List EditWindow;

//	EditWindow operations

GetFrontWindow	:: !EditWindows -> (!EditWdId,!EditWindow);
GetNextWindow	:: !EditWindows -> (!EditWdId,!EditWindow);
WindowsPresent :: !EditWindows -> Bool;
WindowPresent :: !EditWdId !EditWindows -> Bool;
SetFrontWindow	:: !EditWindow !EditWindows -> EditWindows;
RemoveFrontWindow :: !EditWindows !EditWdIds -> (!EditWindows,!EditWdIds);
GetWindow :: !EditWdId !EditWindows -> EditWindow;
SetWindow :: !EditWdId !EditWindow !EditWindows -> EditWindows;
AddWindow :: !WdType !EditWindow !EditWindows !EditWdIds -> (!EditWindows,!EditWdIds,!EditWdId);
SetWindowInFront :: !EditWdId !EditWindows -> EditWindows;
GetWindowIndex :: !String !EditWindows -> Int;
NewExecWdId :: !EditWdId !EditWindows -> EditWdId;
IsExistingPathname :: !Pathname !EditWindows -> (!Bool,!EditWdId);

//	Initializers

ZeroCursor				:: CursorPos;
EmptyCurLine			:: CurLine;
EmptySelection			:: Selection;
						
EmptyTSel				:: PartTSel;
						
EmptyClipCopied			:: ClipCopied;
EmptyRemoved			:: Removed;
EmptyReplaced			:: ReplacedAll;
EmptyAdded				:: PartTSel;
EmptyUndoItem			:: UndoMenuItem;
EmptyUndo				:: UndoInfo;

EmptyWindowUpdate		:: WindowUpdate;

DefaultLinkOptions :: LinkOptions;
DefaultEditOptions		:: EditOptions;
DefaultCompilerOptions	:: CompilerOptions;
DefaultABCOptions		:: ABCOptions;
DefCodeGenOptions :: CodeGenOptions;
DefApplicationOptions :: ApplicationOptions;
DefProjectOptions :: ProjectOptions;

//	Fresh Windows

EmptyWindow :: EditWindow;
NewEditWindow :: !WdType !EditOptions !CompilerOptions !Text !Pathname !NrLines -> EditWindow;

//	Window operations

EW_GetEditOptions :: !EditWindow -> EditOptions;
IsEmptySelection :: !Selection -> Bool;
EW_GetTextPosition :: !CurLine !Selection -> PartTSel;
EW_GetActivePos	:: !CurLine !CursorPos !Selection -> ActPasPos;
EW_GetPassivePos :: !CurLine !CursorPos !Selection -> ActPasPos;

EW_ResetCurLine	:: !Bool !Text !CurLine -> (!Bool,!Text,!CurLine);
EW_SetEditOptions :: !EditOptions !EditWindow -> EditWindow;

//	Miscellaneous functions

Between	:: !Int !Int !Int -> Int;

DummyModInfo :: ModInfo;

from deltaFont import :: FontStyle;
EditorDefaultFont :: (!FontName, ![FontStyle], !FontSize);
EditorGetFont :: !FontName !FontSize -> (!FontName, !FontSize, !Font);
