implementation module EdInterrupt;

import StdClass,StdBool,StdInt;
import deltaTimer, deltaDialog, deltaIOSystem, deltaMenu;
import EdProgramState, EdConstants;

StartIntr :: !DialogId !CallBackFun !ProgState !IO -> ProgIO;
StartIntr dialogid callback prog io
	= callback False prog (OpenTimer timerdef (DisableMenuSystem io`));
	where {
		timerdef					= Timer TriggerID Unable 0 /* 1 */ (TriggerIntr dialogid`);
		(dialog_exists,_,io`)		= GetDialogInfo dialogid io;
		dialogid` | dialog_exists	= dialogid;
									= (-1);
	};
	
StopIntr :: !ProgState !IO -> ProgIO;
StopIntr prog=:{editor} io
	= (prog`, io`);
	where {
		prog`	= {prog & editor={editor & callback=InitCallBack}};
		io`		= CloseTimer TriggerID (EnableMenuSystem io);
	};
	
ContIntr :: !CallBackFun !ProgState !IO -> ProgIO;
ContIntr callback prog=:{editor} io
	= (prog`, io`);
	where {
		prog`	= {prog & editor={editor & callback=callback}};
		io`		= EnableTimer TriggerID io;
	};

TriggerIntr :: !DialogId !TimerState !ProgState !IO -> ProgIO;
TriggerIntr dialogid timerstate prog=:{editor=ed=:{callback}} io
	| dialogid==(-1) || dialog_exists
		= callback False prog` (DisableTimer TriggerID io`);
		= callback True  prog` (EnableMenuSystem (CloseTimer TriggerID (CloseDialog dialogid io`)));
	where {
		prog`					= {prog & editor={ed & callback=InitCallBack}}; // Space leak
		(dialog_exists,_,io`)	= GetDialogInfo dialogid io;
	};
