implementation module Complex

import StdReal, StdOverloaded
    
::	ComplexNum
	=	{	re	:: !Real
		,	im	:: !Real
		}

instance zero ComplexNum where
	zero :: ComplexNum
	zero = {re=0.0,im=0.0}
instance + ComplexNum where
	(+) :: !ComplexNum !ComplexNum -> ComplexNum
	(+) a b = {re=a.re+b.re,im=a.im+b.im}

instance - ComplexNum where
	(-) :: !ComplexNum !ComplexNum -> ComplexNum
	(-) a b = {re=a.re-b.re,im=a.im-b.im}

instance * ComplexNum where
	(*) :: !ComplexNum !ComplexNum -> ComplexNum
	(*) a b = {re=a.re*b.re-a.im*b.im,im=a.re*b.im+a.im*b.re}

sqdist :: !ComplexNum -> Real
sqdist {re,im} = re*re+im*im

//	More complex functions
sinC :: !ComplexNum -> ComplexNum
sinC {re,im}
	= {re=0.5*b,im=(-0.5)*a}
where
	a	 = cos re * (emim-eim)
	b	 = sin re * (emim+eim)
	emim = 1.0 / eim
	eim	 = exp im

cosC :: !ComplexNum -> ComplexNum
cosC {re,im}
	= {re=0.5*a,im=0.5*b}
where
	a	 = cos re * (emim+eim)
	b	 = sin re * (emim-eim)
	emim = 1.0 / eim
	eim	 = exp im

expC :: !ComplexNum -> ComplexNum
expC {re,im}
	= {re=a*cos im,im=a*sin im}
where
	a	= exp re
