implementation module wormstate

import	StdInt, StdBool, StdTuple, StdList, StdEnum
from	deltaTimer		import TicksPerSecond
from	deltaPicture	import Point, Rectangle
from	deltaSystem		import RightKey
import	Highscore, Random

//	The worm data types.

::	*State
	=	{	level		:: Level
		,	food		:: Food
		,	foodsupply	:: [Food]
		,	grow		:: Grow
		,	points		:: Points
		,	dir			:: Direction
		,	worm		:: Worm
		,	best		:: HiScores
		,	lives		:: Lives
		}
::	Level
	=	{	fix			:: Int
		,	speed		:: Int
		,	level		:: Int
		,	obstacles	:: [Obstacle]
		}
::	Food
	=	{	value		:: Int
		,	pos			:: Point
		}
::	Grow		:== Int
::	Direction	:== Char
::	Obstacle	:== Rectangle
::	Segment		:== Point
::	Worm		:== [Segment]
::	Points		:== Int
::	Lives		:== Int

SizeX			:== 45
SizeY			:== 26

NrOfWorms		:== 4
NrOfLevels		:== 8
PointsPerLevel	:== 500
StartLevel		:== 0

EasySpeed		:== TicksPerSecond/6
MediumSpeed		:== TicksPerSecond/9
HardSpeed		:== TicksPerSecond/18
Accelation		:==	TicksPerSecond/18


//	Initial State.
InitState :: HiScores -> State
InitState best
	= {	level		= initlevel
	  ,	food		= initfood
	  ,	foodsupply	= []
	  ,	grow		= 0
	  ,	points		= 0
	  ,	dir			= RightKey
	  ,	worm		= initworm
	  ,	best		= best
	  ,	lives		= NrOfWorms
	  }
where
	initfood		= {value=0,pos=(-10,-10)}
	initlevel		= InitLevel EasySpeed
	initworm		= NewWorm initlevel


//	Make a new initial worm.
NewWorm :: Level -> Worm
NewWorm {Level | level}
	= [(x,y)\\x<-[5,4..1]]
where
	y	= StartHeights!!(level mod NrOfLevels)

StartHeights :: [Int]
StartHeights =: [13,5,13,13,13,1,1,14]


//	Construct the next level.
InitLevel :: Int -> Level
InitLevel fix
	= {fix=fix,speed=fix,level=StartLevel,obstacles=Obstacles!!StartLevel}

DecreaseLevel :: Level -> Level
DecreaseLevel curlevel=:{speed,level}
	# level	= level-1
	  speed	= if (level mod NrOfLevels==0 && level<>0) (speed+Accelation) speed
	= {	curlevel &	fix			= speed
				 ,	speed		= speed
				 ,	level		= level
				 ,	obstacles	= Obstacles!!(level mod NrOfLevels)
	  }

IncreaseLevel :: Level -> Level
IncreaseLevel curlevel=:{speed,level}
	# speed	= if (level mod NrOfLevels==0 && level<>0) (speed-Accelation) speed
	  level	= level+1
	= {	curlevel &	fix			= speed
				 ,	speed		= speed
				 ,	level		= level
				 ,	obstacles	= Obstacles!!(level mod NrOfLevels)
	  }

Obstacles :: [[Obstacle]]
Obstacles =: [	[]
			 ,	[((12,11),(34,16))]
			 ,	[((12, 1),(34, 3)), ((12,24),(34,26))]
			 ,	[(( 7, 7),(38, 9)), (( 7,17),(38,19))]
			 ,	[(( 1, 1),(18,10)), ((28,17),(45,26))]
			 ,	[((14, 3),(15,24)), ((30, 3),(31,24))]
			 ,	[(( 3,13),(43,14)), ((22, 3),(24,24))]
			 ,	[(( 3, 3),(20,12)), ((26,15),(43,24))]
			 ]



//	Generate a food supply.
FoodSupply :: RandomSeed -> [Food]
FoodSupply seed
	= [{value=value,pos=pos}:FoodSupply seed3]
where
	(random1,seed1)	= Random seed
	(random2,seed2)	= Random seed1
	(random3,seed3)	= Random seed2
	foodx			= (IncMod random2 (SizeX-2))+1
	foody			= (IncMod random3 (SizeY-2))+1
	pos				= (foodx,foody)
	value			= IncMod random1 9
	
	IncMod a b		= (a mod b)+1

//	Think of some new random food.
NewFood :: Worm Level [Food] -> (Food, [Food])
NewFood worm level=:{obstacles} [food=:{pos}:foods]
	| isMember pos worm || any (InRectangle pos) obstacles	= NewFood worm level foods
	| otherwise												= (food, foods)
where
	InRectangle :: Point Obstacle -> Bool
	InRectangle (x,y) ((lx,ty),(rx,by))
		= x>=lx && x<=rx && y>=ty && y<=by
