definition module basicDB

import StdEnv
import deltaEventIO, deltaDialog, deltaIOSystem, deltaMenu, deltaWindow, deltaFont
import deltaPicture, deltaIOState, deltaFileSelect, deltaControls, deltaSystem
import listextensions

::	*IO				:==	IOState *DataBase	 			// Synonym for IOState (see deltaEventIO)
::	DataBase		=	{old::State, current::State}	// State contains all relevant info
::  Descriptor    	:==	[AttDescriptor]
::	AttDescriptor	=	AttDesc AttributeName TypeCode
::	AttributeName	:==	String
::  TypeCode        =	STRING
::	Table  		  	:==	[ Record ]
::	Record		  	:==	[ AttributeValue ]
::	AttributeValue  =	AS String
instance < AttributeValue
instance toString AttributeValue
instance toString AttDescriptor

::	State		=	{ records		:: Table			// All records
					, descriptor	:: Descriptor		// All fieldnames
					, selection		:: Int				// Indicating current record selected
					, query			:: Record			// Record to look for
					, name			:: String			// Name of table
					, fw			:: Int				// Max width of field contents
					, dw			:: Int				// Max width of descriptor fields
					}

::	InfoFont	=	{	font		:: Font				// The font which is used
					,	width		:: Int				// Its widest character
					,	height		:: Int				// Its line height
					}
DbFont :: InfoFont

ShowEditDialog		:: *DataBase IO -> (*DataBase, IO)
MaxWidth			:: Font [String] -> Int;
DbPictureDomain		:: State Int Int -> PictureDomain
UpdateRecordWindow	:: UpdateArea u:DataBase -> (u:DataBase, [DrawFunction])
ChangeSelection		:: State Int Int IO -> IO
toRecCo				:: Descriptor Int -> Int
UpdateDbDomain		:: *DataBase IO -> (*DataBase,IO)

DontCareId			:: Int
RecordWindowId		:: Int
EdDialogId			:: Int
FieldDialogId		:: Int
MinDbDomainSize		:: (Int,Int)
InputBoxWidth		:: Measure
