definition module StdOrdList

//	****************************************************************************************
//	Concurrent Clean Standard Library Module Version 1.3
//	Copyright 1998 University of Nijmegen
//	****************************************************************************************

import StdClass
import StdInt,StdReal,StdChar

sort    ::               !u:[a] -> u:[a] | Ord a			// Sort the list (mergesort)
sortBy  :: (a a -> Bool) !u:[a] -> u:[a] 					// Sort the list, arg1 is < function
merge   ::               !u:[a] !v:[a] -> w:[a]	
										 | Ord a,[u v <= w] // Merge two sorted lists giving a sorted list
mergeBy :: (a a -> Bool) !u:[a] !v:[a] -> w:[a]				// Merge two sorted lists giving a sorted list
										 ,[u v <= w]		// arg1 is < function
maxList	:: !.[a] 			-> a 		 | Ord a			// Maximum element of list
maxListBy :: (a a -> Bool) !.[a] -> a						// Maximum element of list, arg1 is < function
minList	:: !.[a] 			-> a 		 | Ord a			// Minimum element of list
minListBy :: (a a -> Bool) !.[a] -> a						// Minimum element of list, arg1 is < function

export Ord Int
export Ord Real
export Ord Char
