module HelloWorld

/*	Hello World!
	This program is written in Clean 1.2 using the 0.8 I/O library.
*/

import StdTuple, deltaEventIO, deltaWindow, deltaPicture

DontCareId	:==	0

Start :: *World -> *World
Start world
	= snd (StartIO ioSystem initProgramState [] world)				// perform our IO function on the world
where
	ioSystem														// this program uses only a window
		= [WindowSystem [window]]
	window
		= FixedWindow DontCareId (10,10) "Greeting" ((0,0),(162,100)) updateFunction 
			[	Keyboard Able quitFunction							// pressing any key quits the program
			,	Mouse    Able quitFunction							// pressing the mouse quits the program
			,	GoAway   quit										// closing the window quits the program
			]
	quitFunction _ programState io									// ignore the first argument of mouse or keyboard information
		= quit programState io
	quit programState io											// bye, bye: causes StartIO to terminate
		= (programState, QuitIO io)	
	updateFunction _ programState									// display the contents of the window
		= (programState, [MovePenTo (30,30), DrawString "Hello World!"])
	
	initProgramState												// arbitrary because this program doesn't use the program state
		= 0
