
Module nat Import set;

Inductive [nat : SET]
Constructors [zeroN : nat] [succ : {n:nat} nat]
Double;

[    nat_rec [T|TYPE] = nat_elim nat\T
             : T -> ({n:nat}{ih:T}T) -> nat -> T
]
[    nat_iter [T|TYPE] = [x:T][f:T->T] nat_rec x (nat\f)
             : T -> ({ih:T}T) -> nat -> T
]
[    nat_ind [P:nat->Prop] = nat_elim P
             : (P zeroN) -> ({n:nat}{ih:P n} P (succ n)) -> {n:nat} P n 
];

(* We choose Leibniz equality as the equality on Nat. We also define an inductive
   equality eq_nat and prove that both equalities are equivalent. eq_nat will be
   useful for proving equalities in which the successor occurs.
*)

[     Nat : Set
          = QSet nat
]
[     ZeroN  : el Nat
          = zeroN
]
[     OneN   : el Nat
          = succ ZeroN
]
[     TwoN   : el Nat
          = succ OneN
]
[     ThreeN : el Nat
          = succ TwoN
]
[     FourN  : el Nat
          = succ ThreeN
]
[     FiveN  : el Nat
          = succ FourN
]
[     SixN   : el Nat
          = succ FiveN
]
;

[     Succ : UFun Nat
          = UFunI (succ:op Nat.el)
                  ([x,y:nat][H:Q x y] Q_subst H.Q_sym
                                              ([x:nat]Q x.succ y.succ) (Q_refl y.succ))
]
;

[     eq_nat : nat -> nat -> Prop
          = nat_double_elim (nat\nat\Prop)
                            trueProp
                            ([y:nat][ih_y:Prop] absurd)
                            ([x:nat][ih_x:nat->Prop] absurd)
                            ([x:nat][ih_x:nat->Prop][y:nat][ih_y:Prop] ih_x y)
];

Goal eq_nat_subs : substitutive eq_nat;
  Refine nat_double_elim [t,u:nat] (eq_nat t u) -> Q t u;
  intros; Refine Q_refl;
  intros; Immed;
  intros; Immed;
  intros; Refine exten Succ; Refine n_ih ? H;
Save;

[     eq_nat_refl : reflexive eq_nat
          = nat_ind ([n:nat]eq_nat n n) trueprf ([n:nat][n_ih:eq_nat n n]n_ih)
]
[     eq_nat_sym : symmetric eq_nat
          = subs_sym eq_nat eq_nat_subs eq_nat_refl
]
[     eq_nat_trans : transitive eq_nat
          = subs_trans eq_nat eq_nat_subs
]
[     eq_natI : {x,y|Nat.el} (Q x y) -> eq_nat x y
          = [x,y|el Nat][H:Q x y] Q_subst H.Q_sym ([z:nat]eq_nat z y) (eq_nat_refl y)
];

(* --------------------------------------------------------------------------------
   Prove some basic properties about Succ.
*)

Goal Succ_inj : {a,a'|el Nat} (Eq (Succ.ap a) (Succ.ap a')) -> Eq a a';
  Intros ___;
  Refine eq_nat_subs; Refine eq_natI H;
Save;

Goal Succ_not_zero : {n:Nat.el} ~(Eq (Succ.ap n) ZeroN);
  Intros __;
  Refine eq_natI H;
Save;

(* --------------------------------------------------------------------------------
   Prove some basic properties about Nat.
*)

Goal Nat_discr : Discrete Nat;
  Refine nat_double_elim [x,y:el Nat] (Eq x y) \/ ~(Eq x y);
  orIL; Refine Eq_refl;
  intros; orIR; notI; Refine Succ_not_zero ? H.Eq_sym;
  intros; orIR; notI; Refine Succ_not_zero ? H;
  intros; orE n_ih n';
    intros; orIL; Refine exten Succ H;
    intros; orIR; notI; notE H; Refine Succ_inj H1;
Save;

