
Module basic Import types lib_logic;

[trueprf = [P:Prop][p:P]p : trueProp];

(* Define the 8- and 9-ary boolean `and' by an impredicative definition. *)

[A,B,C,D,E,F,G,H,I|Prop] [a:A][b:B][c:C][d:D][e:E][f:F][g:G][h:H][i:I];

[and8 [A,B,C,D,E,F,G,H:Prop] = {chi|Prop}{premise:A->B->C->D->E->F->G->H->chi}chi];
[pair8 = [chi|Prop][premise:A->B->C->D->E->F->G->H->chi](premise a b c d e f g h)
       : and8 A B C D E F G H];
[and8_out1 [conj:and8 A B C D E F G H] = conj|A [a:A]B\C\D\E\F\G\H\a:A];
[and8_out2 [conj:and8 A B C D E F G H] = conj|B A\[b:B]C\D\E\F\G\H\b:B];
[and8_out3 [conj:and8 A B C D E F G H] = conj|C A\B\[c:C]D\E\F\G\H\c:C];
[and8_out4 [conj:and8 A B C D E F G H] = conj|D A\B\C\[d:D]E\F\G\H\d:D];
[and8_out5 [conj:and8 A B C D E F G H] = conj|E A\B\C\D\[e:E]F\G\H\e:E];
[and8_out6 [conj:and8 A B C D E F G H] = conj|F A\B\C\D\E\[f:F]G\H\f:F];
[and8_out7 [conj:and8 A B C D E F G H] = conj|G A\B\C\D\E\F\[g:G]H\g:G];
[and8_out8 [conj:and8 A B C D E F G H] = conj|H A\B\C\D\E\F\G\[h:H]h:H];

[and9 [A,B,C,D,E,F,G,H,I:Prop] = {chi|Prop}{premise:A->B->C->D->E->F->G->H->I->chi}chi];
[pair9 = [chi|Prop][premise:A->B->C->D->E->F->G->H->I->chi](premise a b c d e f g h i)
       : and9 A B C D E F G H I];
[and9_out1 [conj:and9 A B C D E F G H I] = conj|A [a:A]B\C\D\E\F\G\H\I\a:A];
[and9_out2 [conj:and9 A B C D E F G H I] = conj|B A\[b:B]C\D\E\F\G\H\I\b:B];
[and9_out3 [conj:and9 A B C D E F G H I] = conj|C A\B\[c:C]D\E\F\G\H\I\c:C];
[and9_out4 [conj:and9 A B C D E F G H I] = conj|D A\B\C\[d:D]E\F\G\H\I\d:D];
[and9_out5 [conj:and9 A B C D E F G H I] = conj|E A\B\C\D\[e:E]F\G\H\I\e:E];
[and9_out6 [conj:and9 A B C D E F G H I] = conj|F A\B\C\D\E\[f:F]G\H\I\f:F];
[and9_out7 [conj:and9 A B C D E F G H I] = conj|G A\B\C\D\E\F\[g:G]H\I\g:G];
[and9_out8 [conj:and9 A B C D E F G H I] = conj|H A\B\C\D\E\F\G\[h:H]I\h:H];
[and9_out9 [conj:and9 A B C D E F G H I] = conj|I A\B\C\D\E\F\G\H\[i:I]i:I];

Discharge A;

(* ------------------------------------------------------------------------------
   Define the notions of predicate, relation, operation and binary operation
   over a type T.
*)

[rel  [T:TYPE] : TYPE = T -> T -> Prop];
[op   [T:TYPE] : TYPE = T -> T];
[bop  [T:TYPE] : TYPE = T -> T -> T];

(* Define the notions respective, congruence. Note reflexive, symmetric,
   transitive etc. are already defined in the unit Logic. *)

[T,U,V | TYPE] [eq : rel T] [eqU : rel U] [eqV : rel V];

[R : rel T] [P : T -> Prop];

  [reflexive      = {x:T} R x x];
  [antireflexive  = {x:T} ~(R x x)];
  [symmetric      = {x,y|T} (R x y) -> (R y x)];
  [transitive     = {x|T}{y:T}{z|T} (R x y) -> (R y z) -> (R x z)];
  [antisymmetric  = {x,y|T} (R x y) -> (R y x) -> eq x y];
  [total          = {x,y:T} (R x y) \/ (R y x)];
  [decidable_pred = {x:T} (P x) \/ ~(P x)];
  [decidable_rel  = {x,y:T} (R x y) \/ ~(R x y)];

Discharge R;

[lowerbound    = [R:T->U->Prop][e:T] {x:U} R e x];

[o : bop T] [e : T] [f : op T];

  [idempotent    = {x:T} eq (o x x) x];
  [associative   = {x,y,z:T} eq (o x (o y z)) (o (o x y) z)];
  [commutative   = [o:U->U->T] {x,y:U} eq (o x y) (o y x)];
  [involutive    = {x:T} eq (f (f x)) x];

  [l_identity    = [o:U->T->T][e:U] {x:T} eq (o e x) x];
  [r_identity    = [o:T->U->T][e:U] {x:T} eq (o x e) x];

  [l_inverse     = [o:V->U->T][e:T][f:U->V] {x:U} eq (o (f x) x) e];
  [r_inverse     = [o:V->U->T][e:T][f:V->U] {x:V} eq (o x (f x)) e];

  [l_cancelation = [o:U->T->V] {a:U}{x,y|T} (eqV (o a x) (o a y)) -> eq x y];
  [r_cancelation = [o:T->U->V] {a:U}{x,y|T} (eqV (o x a) (o y a)) -> eq x y];

  [distributive  = {y,y':T} eq (f (o y y')) (o (f y) (f y'))];

DischargeKeep T;

[inverse     = [o:U->U->T][e:T][f:op U] and (l_inverse eq o e f) (r_inverse eq o e f)];
[identity    = and (l_identity eq o e) (r_identity eq o e)];
[cancelation = [o:T->U->V] and (l_cancelation eqU eqV o) (r_cancelation eq eqV o)];

Discharge o;

[RT : rel T] [RU : rel U] [RV : rel V] [f : T -> V] [o : T -> U -> V]

  [preserve1 = {x,x'|T} (RT x x') -> RV (f x) (f x')];
  [preserve2 = {x,x'|T} (RT x x') -> {y,y'|U} (RU y y') -> RV (o x y) (o x' y')];
  [preserve2r = {x,x'|T} (RT x x') -> {y:U} RV (o x y) (o x' y)];

Discharge T;

[     compose2 [S,T,U,V|SET] : (T->U->V) -> (S->T) -> (S->U) -> (S->V)
          = [h:T->U->V] [f:S->T] [g:S->U] [x:S] h (f x) (g x)
];
