
Module map Import product;

(* ---------------------------------------------------------------------------
   arrow T V n  =  T -> ... -> T -> V
*)

Goal arrow : SET -> SET -> nat -> SET;
  intros T V;
  Refine nat_iter V ([ih:SET] T -> ih);
Save;

(* Define the set of arrows. *)

[A,B | Set];

Goal eq_arrow : {n|nat} rel (arrow A.el B.el n);
  Refine nat_elim [n:nat] rel (arrow A.el B.el n);
  Refine Eq;
  Intros __ f g; Refine {x:el A} n_ih (f x) (g x);
Save;

Goal {n:nat} reflexive (eq_arrow|n);
  Refine nat_ind [n:nat] reflexive (eq_arrow|n);
  Refine Eq_refl;
  Intros; Refine ih;
Save eq_arrow_refl;

Goal {n:nat} symmetric (eq_arrow|n);
  Intros ___;
  Refine nat_ind [n:nat] symmetric (eq_arrow|n);
  Refine Eq_sym;
  Intros; Refine ih ?.H;
Save eq_arrow_sym;

Goal {n:nat} transitive (eq_arrow|n);
  Intros ____;
  Refine nat_ind [n:nat] transitive (eq_arrow|n);
  Refine Eq_trans;
  Intros; Refine ih ? ?.H ?.H1;
Save eq_arrow_trans;

Discharge A;

Goal Arrow : Set -> Set -> nat -> Set;
  intros A B n;
  Refine SetI;
  Refine +2 eq_arrow_refl|A|B n;
  Refine eq_arrow_sym;
  Refine eq_arrow_trans;
Save;

(* Define the n-ary functions. *)

[A,B | Set];

Goal arrow_extensional' : {n|nat} {f,f':arrow A.el B.el n} Prop;
  Refine nat_elim [n:nat] {f,f':arrow A.el B.el n} Prop;
  Refine Eq;
  intros; Refine {x,x'|el A} (Eq x x') -> n_ih (f x) (f' x');
Save;

Goal arrow_extensional : {n|nat} {f:arrow A.el B.el n} Prop;
  intros; Refine arrow_extensional' f f;
Save;

DischargeKeep A;

[    nFun [A,B:Set] [n:nat] : SET
          = <f:arrow A.el B.el n> arrow_extensional f
];

[    apn [n|nat][f:nFun A B n] : arrow A.el B.el n
          = f.1
]
[    ext [n|nat][f:nFun A B n] : arrow_extensional f.apn
          = f.2
]
[    nFunI [n|nat][f:arrow A.el B.el n][ext:arrow_extensional f] : nFun A B n
          = (f, ext : nFun A B n)
];

[   constant [x:el B] : nFun A B ZeroN
          = nFunI|ZeroN x x.Eq_refl
];

Discharge A;

[     nFunc [A:Set] [n:nat] : SET
          = nFun A A n
]
[     nPred [A:Set] [n:nat] : SET
          = nFun A Omega n
];

Goal nFunction : Set -> Set -> nat -> Set;
  intros A B n;
  Refine SetI;
  Refine nFun A B n;
  Intros f g; Refine eq_arrow f.apn g.apn;
  Intros _; Refine eq_arrow_refl;
  Intros __; Refine eq_arrow_sym;
  Intros ___; Refine eq_arrow_trans;
Save;

(* ================================================================================
*)

[A,B | Set];

Goal ap1 : {n|nat} (nFunction A B n.succ).el -> A.el -> (nFunction A B n).el;
  intros n f x; Refine nFunI;
  Refine apn f x;
  Refine ext f ?.Eq_refl;
Save;

(* swap f z x0 x1..xn  =  f x0 z x1..xn *)

Goal app_swap : {n|nat} (nFun A B n.succ.succ) -> (el A) -> (nFun A B n.succ);
  intros n f z; Refine nFunI;
  Refine [x:el A] f.apn x z;
  Intros ___; Refine f.ext H ?.Eq_refl;
Save;

Goal {n|nat} extensional2 (ap1|n);
  Intros n' g g' _ x y _;
  Refine eq_arrow_trans ? (g'.apn x) ?.H;
  Refine nat_elim [n:nat] {f:nFun A B n.succ} eq_arrow (f.apn x) (f.apn y);
  intros; Refine ext f H1;
  Intros n ih f z; Refine ih (app_swap f z);
Save ap1_exten;

Goal {n|nat} (nFun A B n) -> (Product A n).el -> B.el;
  intros n f;
  Refine nat_elim [n:nat] (arrow A.el B.el n) -> (product A.el n) -> B.el;
  intros a p; Refine a;
  intros n ih a p; Refine ih (a p.1) p.2;
  Refine f.apn;
Save app;

Goal {n|nat} extensional2|(nFunction A B n) (app|n);
  Refine nat_ind [n:nat] extensional2|(nFunction A B n) (app|n);
  Intros ______; Refine H;
  Intros __ f f' _ p p' _;
  Refine ih|(ap1 f p.first)|(ap1 f' p'.first) ? H1.snd;
  Refine ap1_exten H H1.fst;
Save app_exten;

Goal {n|nat} {f:nFun A B n} {p,q|el (Product A n)} (Eq p q) -> Eq (f.app p) (f.app q);
  intros __; Refine app_exten ?.Eq_refl;
Save extp;

Discharge A;
