
Module Group Import Semantics;

(* ================================================================================
   Groups
*)

(* Define the signature of a Group. *)

Goal sigGr : Signature;
  Refine SignatureI ThreeSET EmptySET;
  Refine ThreeSET_elim ThreeSET\nat;
  Refine ZeroN;                (* 1 constant *)
  Refine OneN;                 (* 1 unary function *)
  Refine TwoN;                 (* 1 binary function *)
  intros; Refine EmptySET_lemma H;
Save;

Goal axiomsGr : Axioms sigGr;
  Refine Axioms_intro;
  Intros A IC IP;
  One   == (IC star31).apn : el A;
  Inv   == IC star32       : UFun A;
  Times == IC star33       : BFun A;
  Refine and3 (Associative Times) (Inverse Times One Inv) (Identity Times One);
Save;

[Group = Model axiomsGr];

[G : Group];

  [OneGr         : obj G                        = intCons G star31]
  [InvGr         : UFun G.car                   = intFunc G star32]
  [TimesGr       : BFun G.car                   = intFunc G star33];

  [TimesGr_assoc : Associative TimesGr          = and3_out1 G.axioms]
  [InvGr_invers  : Inverse TimesGr OneGr InvGr  = and3_out2 G.axioms]
  [OneGr_ident   : Identity TimesGr OneGr       = and3_out3 G.axioms];

  [lInvGr_invers : lInverse TimesGr OneGr InvGr = fst InvGr_invers]
  [lOneGr_ident  : lIdentity TimesGr OneGr      = fst OneGr_ident]
  [rInvGr_invers : rInverse TimesGr OneGr InvGr = snd InvGr_invers]
  [rOneGr_ident  : rIdentity TimesGr OneGr      = snd OneGr_ident];

Discharge G;

