
Module product Import set nat;

(* --------------------------------------------------------------------------------
   Define the cartesian product of two types.
*)

[prod [T,U:SET] = T # U : SET];

[T,U | SET];

[     first [x:prod T U] : T
           = x.1
]
[     second [x:prod T U] : U
           = x.2
]
[     tuple [x:T][y:U] : prod T U
           = (x, y)
];

Discharge T;

(* --------------------------------------------------------------------------------
   Define the cartesian product of two sets.
*)

[A,B : Set];

[     eq_prod : rel (prod A.el B.el)
          = [x:prod A.el B.el][y:prod A.el B.el]
            (Eq x.first y.first) /\ (Eq x.second y.second)
];

Goal reflexive eq_prod;
  Intros _; Refine pair;
  Refine Eq_refl; Refine Eq_refl;
Save eq_prod_refl;

Goal symmetric eq_prod;
  Intros ___; Refine H; intros; Refine pair;
  Refine Eq_sym H1; Refine Eq_sym H2;
Save eq_prod_sym;

Goal transitive eq_prod;
  Intros _____; Refine H; Refine H1; intros; Refine pair;
  Refine Eq_trans ? H4 H2; Refine Eq_trans ? H5 H3;
Save eq_prod_trans;

Goal Prod : Set;
  Refine SetI;
  Refine +2 eq_prod_refl;
  Refine eq_prod_sym;
  Refine eq_prod_trans;
Save;

Discharge A;

[A,B | Set];

  [     First [x:el (Prod A B)] : el A
            = x.first
  ]
  [     Second [x:el (Prod A B)] : el B
            = x.second
  ]
  [     Tuple [x:el A][y:el B] : el (Prod A B)
            = tuple x y
  ];

  Goal Prod_discr : A.Discrete -> B.Discrete -> (Prod A B).Discrete;
    Intros discr_A discr_B x y;
    Refine discr_A x.First y.First;
    intros; Refine discr_B x.Second y.Second;
      intros; Refine inl; Refine pair H H1;
      intros; Refine inr; Intros _; Refine H1; Refine snd H2;
    intros; Refine inr; Intros _; Refine H; Refine fst H1;
  Save;

  Goal Prod_nEq : A.Discrete -> B.Discrete -> {x,y:el (Prod A B)}
                     ~(Eq x y) -> ~(Eq x.First y.First) \/ ~(Eq x.Second y.Second);
    intros A_discr B_discr ___;
    Refine A_discr x.First y.First;
    intros; Refine B_discr x.Second y.Second;
    intros; Refine H; Refine pair H1 H2;
    Refine inr;
    Refine inl;
  Save;

Discharge A;

(* --------------------------------------------------------------------------------
   Define the n-ary product of types and sets.
*)

Goal product : {S:SET}{n:nat} SET;
  intros _;
  Refine nat_iter UnitSET (prod S);
Save;

Goal {S:SET} (product S ZeroN);
  intros; Refine star;
Save prod0;

Goal {S|SET} S -> (product S OneN);
  intros S x; Refine tuple x star;
Save prod1;

Goal {S|SET} (product S OneN) -> S;
  intros _; Refine first;
Save prod1_elim;

[A : Set];

Goal eq_product : {n:nat} rel (product A.el n);
  Refine nat_elim [n:nat] rel (product A.el n);
  Refine Eq|UnitSet;
  Intros n ih p1 p2; Refine (Eq p1.first p2.first) /\ (ih p1.second p2.second);
Save;

Goal {n:nat} reflexive (eq_product n);
  Refine nat_elim [n:nat] reflexive (eq_product n);
  Refine Eq_refl|UnitSet;
  Intros n ih _; Refine pair;
  Refine Eq_refl; Refine ih;
Save eq_product_refl;

Goal {n:nat} symmetric (eq_product n);
  Refine nat_elim [n:nat] symmetric (eq_product n);
  Refine Eq_sym|UnitSet;
  Intros _____; Refine H; intros; Refine pair;
  Refine Eq_sym H1; Refine n_ih H2;
Save eq_product_sym;

Goal {n:nat} transitive (eq_product n);
  Refine nat_elim [n:nat] transitive (eq_product n);
  Refine Eq_trans|UnitSet;
  Intros _______; Refine H; Refine H1; intros; Refine pair;
  Refine Eq_trans ? H4 H2; Refine n_ih ? H5 H3;
Save eq_product_trans;

Goal Product : nat -> Set;
  intros n;
  Refine SetI;
  Refine +2 eq_product_refl n;
  Refine eq_product_sym;
  Refine eq_product_trans;
Save;

Goal {x,y:el (Product zeroN)} Eq x y;
  Refine UnitSet_trivial;
Save Product_zero;

Discharge A;

Goal Product_discr : {A|Set} A.Discrete -> {n:nat} (Product A n).Discrete;
  intros A A_discr;
  Refine nat_elim [n:nat] (Product A n).Discrete;
  Refine UnitSet_discr;
  intros;
  Equiv Discrete (Prod A (Product A n));
  Refine Prod_discr A_discr n_ih;
Save;
